/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.Collection;
import java.util.List;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.BracketIndentRule;
import org.gjt.sp.jedit.indent.IndentAction;

public class OpenBracketIndentRule
extends BracketIndentRule {
    private boolean aligned;

    public OpenBracketIndentRule(char c, boolean bl) {
        super(c, TextUtilities.getComplementaryBracket(c, null));
        this.aligned = bl;
    }

    @Override
    public void apply(JEditBuffer jEditBuffer, int n, int n2, int n3, List<IndentAction> list) {
        int n4 = this.getOpenBracketCount(jEditBuffer, n2);
        if (n4 != 0) {
            OpenBracketIndentRule.handleCollapse(list, true);
            boolean bl = jEditBuffer.getBooleanProperty("multipleBracketIndent");
            IndentAction.Increase increase = new IndentAction.Increase(bl ? n4 : 1);
            list.add(increase);
        } else if (this.getOpenBracketCount(jEditBuffer, n) != 0) {
            OpenBracketIndentRule.handleCollapse(list, false);
        }
    }

    private int getOpenBracketCount(JEditBuffer jEditBuffer, int n) {
        if (n == -1) {
            return 0;
        }
        return this.getBrackets((JEditBuffer)jEditBuffer, (int)n).openCount;
    }

    private static void handleCollapse(Collection<IndentAction> collection, boolean bl) {
        if (collection.contains(IndentAction.PrevCollapse)) {
            collection.clear();
            return;
        }
        if (bl && collection.contains(IndentAction.PrevPrevCollapse)) {
            collection.clear();
        }
    }
}

