/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiJavaModuleReferenceImpl
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement>
implements PsiJavaModuleReference {
    public PsiJavaModuleReferenceImpl(@NotNull PsiJavaModuleReferenceElement element) {
        if (element == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(0);
        }
        super(element, new TextRange(0, element.getTextLength()), false);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string2 == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public PsiJavaModule resolve() {
        return (PsiJavaModule)super.resolve();
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newName2) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement element;
        if (newName2 == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(3);
        }
        if ((element = (PsiJavaModuleReferenceElement)this.getElement()) instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaCoreBundle.message("psi.error.attempt.to.edit.class.file", element.getContainingFile()));
        }
        PsiJavaModuleReferenceElement newElement = PsiElementFactory.getInstance(element.getProject()).createModuleReferenceFromText(newName2, null);
        return element.replace(newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaModuleReferenceImpl reference, boolean incompleteCode) {
            PsiJavaModule module2;
            if (reference == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            PsiJavaModuleReferenceElement refElement = (PsiJavaModuleReferenceElement)reference.getElement();
            PsiFile file2 = refElement.getContainingFile();
            String moduleName = reference.getCanonicalText();
            if (file2 instanceof PsiJavaFile && (module2 = ((PsiJavaFile)file2).getModuleDeclaration()) != null && module2.getName().equals(moduleName)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(module2)};
                if (resolveResultArray == null) {
                    Resolver.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }
            boolean global = incompleteCode || refElement.getParent() instanceof PsiPackageAccessibilityStatement;
            Project project = file2.getProject();
            GlobalSearchScope scope2 = global ? GlobalSearchScope.allScope(project) : file2.getResolveScope();
            Collection<PsiJavaModule> modules = JavaPsiFacade.getInstance(project).findModules(moduleName, scope2);
            if (!modules.isEmpty()) {
                ResolveResult[] result2 = new ResolveResult[modules.size()];
                int i = 0;
                for (PsiJavaModule module3 : modules) {
                    result2[i++] = new PsiElementResolveResult(module3);
                }
                if (result2 == null) {
                    Resolver.$$$reportNull$$$0(2);
                }
                return result2;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                Resolver.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl$Resolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl$Resolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

