/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralUtil {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);

    @Nullable
    public static Integer parseInteger(String text2) {
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                long value2 = PsiLiteralUtil.parseDigits(text2.substring(2), 4, 32);
                return (int)value2;
            }
            if (text2.startsWith(BIN_PREFIX)) {
                long value3 = PsiLiteralUtil.parseDigits(text2.substring(2), 1, 32);
                return (int)value3;
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                long value4 = PsiLiteralUtil.parseDigits(text2, 3, 32);
                return (int)value4;
            }
            return PsiLiteralUtil.parseIntegerNoPrefix(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Integer parseIntegerNoPrefix(String text2) {
        long l = Long.parseLong(text2, 10);
        if (text2.equals(_2_IN_31) || l == (long)((int)l)) {
            return (int)l;
        }
        return null;
    }

    @Nullable
    public static Long parseLong(String text2) {
        if (StringUtil.endsWithChar(text2, 'L') || StringUtil.endsWithChar(text2, 'l')) {
            text2 = text2.substring(0, text2.length() - 1);
        }
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 4, 64);
            }
            if (text2.startsWith(BIN_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 1, 64);
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                return PsiLiteralUtil.parseDigits(text2, 3, 64);
            }
            if (_2_IN_63.equals(text2)) {
                return Long.MIN_VALUE;
            }
            return Long.valueOf(text2, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String text2) {
        try {
            return Float.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double parseDouble(String text2) {
        try {
            return Double.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long parseDigits(String text2, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text2.length();
        if (textLength == 0) {
            throw new NumberFormatException(text2);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text2.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text2);
        }
        int lastDigit = Character.digit(text2.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text2);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @NotNull
    public static String stringForCharLiteral(@NotNull String charLiteral) {
        if (charLiteral == null) {
            PsiLiteralUtil.$$$reportNull$$$0(0);
        }
        if ("'\"'".equals(charLiteral)) {
            return "\"\\\"\"";
        }
        if ("'\\''".equals(charLiteral)) {
            return "\"'\"";
        }
        String string2 = '\"' + charLiteral.substring(1, charLiteral.length() - 1) + '\"';
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public static boolean isUnsafeLiteral(PsiLiteralExpression expression2) {
        PsiElement literal = expression2.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type2 = ((PsiJavaToken)literal).getTokenType();
        return (type2 == JavaTokenType.CHARACTER_LITERAL || type2 == JavaTokenType.STRING_LITERAL) && expression2.getValue() == null;
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s) {
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(2);
        }
        return PsiLiteralUtil.escapeTextBlockCharacters(s, false, true, true);
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s, boolean escapeStartQuote, boolean escapeEndQuote, boolean escapeSpacesInTheEnd) {
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(3);
        }
        int i = 0;
        int length = s.length();
        StringBuilder result2 = new StringBuilder(length);
        while (i < length) {
            int nextIdx = PsiLiteralUtil.parseQuotes(i, s, result2, escapeStartQuote, escapeEndQuote);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseSpaces(i, s, result2, escapeSpacesInTheEnd);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseBackSlashes(i, s, result2);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            result2.append(s.charAt(i));
            ++i;
        }
        String string2 = result2.toString();
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static int parseQuotes(int start, @NotNull String s, @NotNull StringBuilder result2, boolean escapeStartQuote, boolean escapeEndQuote) {
        char c;
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(6);
        }
        if ((c = s.charAt(start)) != '\"') {
            return -1;
        }
        int nQuotes = 1;
        int i = start;
        while (true) {
            int nextIdx;
            int n = nextIdx = i + 1 >= s.length() ? -1 : PsiLiteralUtil.parseBackSlash(s, i + 1);
            if (nextIdx == -1) {
                nextIdx = i + 1;
            }
            if (nextIdx >= s.length() || s.charAt(nextIdx) != '\"') break;
            ++nQuotes;
            i = nextIdx;
        }
        for (int q = 0; q < nQuotes; ++q) {
            if (q == 0 && start == 0 && escapeStartQuote || q % 3 == 2 || q == nQuotes - 1 && i + 1 == s.length() && escapeEndQuote) {
                result2.append("\\\"");
                continue;
            }
            result2.append('\"');
        }
        return i + 1;
    }

    private static int parseSpaces(int start, @NotNull String s, @NotNull StringBuilder result2, boolean escapeSpacesInTheEnd) {
        int nextIdx;
        int i;
        char c;
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(8);
        }
        if ((c = s.charAt(start)) != ' ') {
            return -1;
        }
        int nSpaces = 0;
        for (i = start; i < s.length() && s.charAt(i) == ' '; ++i) {
            ++nSpaces;
        }
        if (i >= s.length() && escapeSpacesInTheEnd) {
            result2.append(StringUtil.repeat("\\040", nSpaces));
            return i;
        }
        int n = nextIdx = i >= s.length() ? -1 : PsiLiteralUtil.parseBackSlash(s, i);
        if (nextIdx != -1 && nextIdx < s.length() && s.charAt(nextIdx) == 'n') {
            result2.append(StringUtil.repeat("\\040", nSpaces));
            return i;
        }
        result2.append(StringUtil.repeatSymbol(' ', nSpaces));
        return i;
    }

    private static int parseBackSlashes(int start, @NotNull String s, @NotNull StringBuilder result2) {
        int nextIdx;
        int i;
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(10);
        }
        if ((i = PsiLiteralUtil.parseBackSlash(s, start)) == -1) {
            return -1;
        }
        int prev = start;
        int nSlashes = 1;
        while (i < s.length() && (nextIdx = PsiLiteralUtil.parseBackSlash(s, i)) != -1) {
            result2.append(s, prev, i);
            prev = i;
            i = nextIdx;
            ++nSlashes;
        }
        if (i >= s.length()) {
            result2.append(s, prev, s.length());
        } else if (nSlashes % 2 == 0) {
            result2.append(s, prev, i);
        } else {
            char next = s.charAt(i);
            if (next == 'n') {
                result2.append('\n');
            } else {
                if (next == '\"') {
                    return i;
                }
                result2.append(s, prev, i).append(next);
            }
            return i + 1;
        }
        return i;
    }

    @NotNull
    public static String escapeBackSlashesInTextBlock(@NotNull String str) {
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(11);
        }
        int i = 0;
        int length = str.length();
        StringBuilder result2 = new StringBuilder(length);
        while (i < length) {
            int nextIdx = PsiLiteralUtil.parseBackSlash(str, i);
            if (nextIdx != -1) {
                result2.append("\\\\");
                i = nextIdx;
                continue;
            }
            result2.append(str.charAt(i));
            ++i;
        }
        String string2 = result2.toString();
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NotNull
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder(str.length());
        int nSlashes = 0;
        int idx = 0;
        while (idx < str.length()) {
            char c = str.charAt(idx);
            int nextIdx = PsiLiteralUtil.parseBackSlash(str, idx);
            if (nextIdx > 0) {
                ++nSlashes;
            } else {
                if (c == '\"' && nSlashes % 2 == 0) {
                    sb.append('\\');
                }
                nSlashes = 0;
                nextIdx = idx + 1;
            }
            sb.append(c);
            idx = nextIdx;
        }
        String string2 = sb.toString();
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(14);
        }
        return string2;
    }

    private static int parseBackSlash(@NotNull String str, int idx) {
        char c;
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(15);
        }
        if ((c = str.charAt(idx)) != '\\') {
            return -1;
        }
        int nextIdx = PsiLiteralUtil.parseEscapedBackSlash(str, idx);
        return nextIdx > 0 ? nextIdx : idx + 1;
    }

    private static int parseEscapedBackSlash(@NotNull String str, int idx) {
        int next;
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(16);
        }
        if ((next = idx + 1) >= str.length() || str.charAt(next) != 'u') {
            return -1;
        }
        while (str.charAt(next) == 'u') {
            ++next;
        }
        if (next + 3 >= str.length()) {
            return -1;
        }
        try {
            int code = Integer.parseInt(str.substring(next, next + 4), 16);
            if (code == 92) {
                return next + 4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charLiteral";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "stringForCharLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTextBlockCharacters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackSlashesInTextBlock";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringForCharLiteral";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "escapeTextBlockCharacters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseQuotes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSpaces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseBackSlashes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashesInTextBlock";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseBackSlash";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseEscapedBackSlash";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

