/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.konan.properties.PropertiesKt;
import org.jetbrains.kotlin.library.BaseWriter;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.KotlinLibraryVersioningKt;
import org.jetbrains.kotlin.library.impl.BaseWriterImpl;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutForWriter;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000bH\u0016J\u0014\u0010%\u001a\u00020\"2\n\u0010&\u001a\u00060\u0017j\u0002`\u0018H\u0016J\b\u0010'\u001a\u00020\"H\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/library/impl/BaseWriterImpl;", "Lorg/jetbrains/kotlin/library/BaseWriter;", "libraryLayout", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;", "moduleName", "", "versions", "Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "builtInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "nativeTargets", "", "nopack", "", "shortName", "(Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;Ljava/lang/String;Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;Ljava/util/List;ZLjava/lang/String;)V", "klibFile", "Lorg/jetbrains/kotlin/konan/file/File;", "getKlibFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "getLibraryLayout", "()Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;", "manifestProperties", "Ljava/util/Properties;", "Lorg/jetbrains/kotlin/konan/properties/Properties;", "getManifestProperties", "()Ljava/util/Properties;", "getNopack", "()Z", "getShortName", "()Ljava/lang/String;", "getVersions", "()Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "addLinkDependencies", "", "libraries", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "addManifestAddend", "properties", "commit", "kotlin-util-klib"})
public class BaseWriterImpl
implements BaseWriter {
    @NotNull
    private final File klibFile;
    @NotNull
    private final Properties manifestProperties;
    @NotNull
    private final KotlinLibraryLayoutForWriter libraryLayout;
    @NotNull
    private final KotlinLibraryVersioning versions;
    private final boolean nopack;
    @Nullable
    private final String shortName;

    @NotNull
    public final File getKlibFile() {
        return this.klibFile;
    }

    @NotNull
    public final Properties getManifestProperties() {
        return this.manifestProperties;
    }

    @Override
    public void addLinkDependencies(@NotNull List<? extends KotlinLibrary> libraries) {
        Intrinsics.checkNotNullParameter(libraries, "libraries");
        if (libraries.isEmpty()) {
            this.manifestProperties.remove("depends");
            return;
        }
        String newValue2 = CollectionsKt.joinToString$default(libraries, " ", null, null, 0, null, addLinkDependencies.newValue.1.INSTANCE, 30, null);
        this.manifestProperties.setProperty("depends", newValue2);
        Iterable $this$forEach$iv = libraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinLibrary it = (KotlinLibrary)element$iv;
            boolean bl = false;
            if (it.getVersions().getLibraryVersion() == null) continue;
            this.manifestProperties.setProperty("dependency_version_" + KotlinLibraryKt.getUniqueName(it), it.getVersions().getLibraryVersion());
        }
    }

    @Override
    public void addManifestAddend(@NotNull Properties properties2) {
        Intrinsics.checkNotNullParameter(properties2, "properties");
        this.manifestProperties.putAll((Map<?, ?>)properties2);
    }

    @Override
    public void commit() {
        PropertiesKt.saveToFile(this.manifestProperties, this.libraryLayout.getManifestFile());
        if (!this.nopack) {
            ZipUtilKt.zipDirAs(this.libraryLayout.getLibDir(), this.klibFile);
            this.libraryLayout.getLibDir().deleteRecursively();
        }
    }

    @NotNull
    public final KotlinLibraryLayoutForWriter getLibraryLayout() {
        return this.libraryLayout;
    }

    @Override
    @NotNull
    public KotlinLibraryVersioning getVersions() {
        return this.versions;
    }

    public final boolean getNopack() {
        return this.nopack;
    }

    @Nullable
    public final String getShortName() {
        return this.shortName;
    }

    public BaseWriterImpl(@NotNull KotlinLibraryLayoutForWriter libraryLayout, @NotNull String moduleName, @NotNull KotlinLibraryVersioning versions2, @NotNull BuiltInsPlatform builtInsPlatform, @NotNull List<String> nativeTargets, boolean nopack, @Nullable String shortName) {
        block2: {
            Intrinsics.checkNotNullParameter(libraryLayout, "libraryLayout");
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            Intrinsics.checkNotNullParameter(versions2, "versions");
            Intrinsics.checkNotNullParameter((Object)builtInsPlatform, "builtInsPlatform");
            Intrinsics.checkNotNullParameter(nativeTargets, "nativeTargets");
            this.libraryLayout = libraryLayout;
            this.versions = versions2;
            this.nopack = nopack;
            this.shortName = shortName;
            this.klibFile = new File(this.libraryLayout.getLibDir().getPath() + ".klib");
            this.manifestProperties = new Properties();
            this.libraryLayout.getLibDir().deleteRecursively();
            this.klibFile.delete();
            this.libraryLayout.getLibDir().mkdirs();
            this.libraryLayout.getResourcesDir().mkdirs();
            this.manifestProperties.setProperty("unique_name", moduleName);
            KotlinLibraryVersioningKt.writeKonanLibraryVersioning(this.manifestProperties, this.getVersions());
            if (builtInsPlatform != BuiltInsPlatform.COMMON) {
                this.manifestProperties.setProperty("builtins_platform", builtInsPlatform.name());
                if (builtInsPlatform == BuiltInsPlatform.NATIVE) {
                    this.manifestProperties.setProperty("native_targets", CollectionsKt.joinToString$default(nativeTargets, " ", null, null, 0, null, null, 62, null));
                }
            }
            String string2 = this.shortName;
            if (string2 == null) break block2;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.manifestProperties.setProperty("short_name", it);
        }
    }

    public /* synthetic */ BaseWriterImpl(KotlinLibraryLayoutForWriter kotlinLibraryLayoutForWriter, String string2, KotlinLibraryVersioning kotlinLibraryVersioning, BuiltInsPlatform builtInsPlatform, List list2, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        this(kotlinLibraryLayoutForWriter, string2, kotlinLibraryVersioning, builtInsPlatform, list2, bl, string3);
    }
}

