/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.repository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.file.FileRepository;

public class FileResource
implements Resource {
    private File file;
    private FileRepository repository;

    public FileResource(FileRepository repository, File f) {
        this.repository = repository;
        this.file = f;
    }

    @Override
    public String getName() {
        return this.file.getPath();
    }

    @Override
    public Resource clone(String cloneName) {
        return new FileResource(this.repository, this.repository.getFile(cloneName));
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    public String toString() {
        return this.getName();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isLocal() {
        return this.repository.isLocal();
    }

    @Override
    public InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

