/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextArea;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.cellrenderer.CellRendererBaseWithStart;
import mediathek.tool.table.MVTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellRendererFilme
extends CellRendererBaseWithStart {
    private static final Logger logger = LogManager.getLogger(CellRendererFilme.class);
    private final Icon selectedStopIcon;
    private final Icon normalStopIcon;
    private final SeenHistoryController history;
    private final Icon selectedDownloadIcon = IconFontSwing.buildIcon(FontAwesome.DOWNLOAD, 16.0f, Color.WHITE);
    private final Icon normalDownloadIcon = IconFontSwing.buildIcon(FontAwesome.DOWNLOAD, 16.0f);
    private final Icon selectedPlayIcon = IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f, Color.WHITE);
    private final Icon normalPlayIcon = IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f);
    private final Icon selectedBookmarkIcon;
    private final Icon normalBookmarkIcon;
    private final Icon selectedBookmarkIconHighlighted;

    public CellRendererFilme(Daten d) {
        super(d.getSenderIconCache());
        this.history = d.getSeenHistoryController();
        this.selectedStopIcon = IconFontSwing.buildIcon(FontAwesome.STOP, 16.0f, Color.WHITE);
        this.normalStopIcon = IconFontSwing.buildIcon(FontAwesome.STOP, 16.0f);
        this.selectedBookmarkIcon = IconFontSwing.buildIcon(FontAwesome.BOOKMARK, 16.0f, Color.BLUE);
        this.selectedBookmarkIconHighlighted = IconFontSwing.buildIcon(FontAwesome.BOOKMARK, 16.0f, Color.yellow);
        this.normalBookmarkIcon = IconFontSwing.buildIcon(FontAwesome.BOOKMARK_O, 16.0f);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.resetComponent();
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int rowModelIndex = table.convertRowIndexToModel(row);
            int columnModelIndex = table.convertColumnIndexToModel(column);
            DatenFilm datenFilm = (DatenFilm)table.getModel().getValueAt(rowModelIndex, 16);
            DatenDownload datenDownload = Daten.getInstance().getListeDownloadsButton().getDownloadUrlFilm(datenFilm.getUrl());
            boolean isBookMarked = datenFilm.isBookmarked();
            if (((MVTable)table).isLineBreak()) {
                switch (columnModelIndex) {
                    case 2: 
                    case 3: 
                    case 14: {
                        JTextArea textArea = new JTextArea();
                        textArea.setLineWrap(true);
                        textArea.setWrapStyleWord(true);
                        textArea.setText(value.toString());
                        textArea.setForeground(this.getForeground());
                        textArea.setBackground(this.getBackground());
                        this.setSelectionFont(textArea, isSelected);
                        this.setColor(textArea, datenFilm, datenDownload, isSelected, isBookMarked);
                        return textArea;
                    }
                }
            }
            this.setSelectionFont(this, isSelected);
            switch (columnModelIndex) {
                case 0: 
                case 7: 
                case 8: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 9: {
                    this.setHorizontalAlignment(0);
                    this.setText(datenFilm.getDauer());
                    break;
                }
                case 10: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    this.handleButtonStartColumn(datenDownload, isSelected);
                    break;
                }
                case 5: {
                    this.handleButtonDownloadColumn(isSelected);
                    break;
                }
                case 6: {
                    this.handleButtonBookmarkColumn(isBookMarked, isSelected);
                    break;
                }
                case 1: {
                    if (!((MVTable)table).showSenderIcons()) break;
                    this.setSenderIcon((String)value, ((MVTable)table).useSmallSenderIcons);
                }
            }
            this.setColor(this, datenFilm, datenDownload, isSelected, isBookMarked);
        }
        catch (Exception ex) {
            logger.error("Fehler", (Throwable)ex);
        }
        return this;
    }

    private void setColor(Component c, DatenFilm datenFilm, DatenDownload datenDownload, boolean isSelected, boolean isBookMarked) {
        boolean start;
        boolean bl = start = datenDownload != null && datenDownload.start != null;
        if (start) {
            this.setBackgroundColor(c, datenDownload.start, isSelected);
        } else {
            if (datenFilm.isLivestream()) {
                c.setForeground(MVColor.FILM_LIVESTREAM.color);
            } else if (this.history.urlPruefen(datenFilm.getUrl())) {
                if (!isSelected) {
                    c.setBackground(MVColor.FILM_HISTORY.color);
                }
            } else if (datenFilm.isNew()) {
                if (!isSelected) {
                    c.setForeground(MVColor.FILM_NEU.color);
                }
            } else if (isBookMarked && !isSelected) {
                c.setBackground(MVColor.FILM_BOOKMARKED.color);
            }
            if (this.geoMelden) {
                this.setupGeoblockingBackground(c, datenFilm.getGeo().orElse(""), isSelected);
            }
        }
    }

    private void handleButtonStartColumn(DatenDownload datenDownload, boolean isSelected) {
        this.setHorizontalAlignment(0);
        if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
            this.setIconAndToolTip(isSelected, this.normalStopIcon, this.selectedStopIcon, "Film stoppen");
        }
        if (this.getIcon() == null) {
            this.setIconAndToolTip(isSelected, this.normalPlayIcon, this.selectedPlayIcon, "Film abspielen");
        }
    }

    private void setIconAndToolTip(boolean isSelected, Icon normal, Icon selected, String text) {
        this.setToolTipText(text);
        Icon icon = isSelected ? selected : normal;
        this.setIcon(icon);
    }

    private void handleButtonDownloadColumn(boolean isSelected) {
        this.setHorizontalAlignment(0);
        this.setIconAndToolTip(isSelected, this.normalDownloadIcon, this.selectedDownloadIcon, "Film aufzeichnen");
    }

    private void handleButtonBookmarkColumn(boolean isBookMarked, boolean isSelected) {
        this.setHorizontalAlignment(0);
        this.setToolTipText(isBookMarked ? "Film aus Merkliste entfernen" : "Film merken");
        this.setIcon(isBookMarked ? (isSelected ? this.selectedBookmarkIconHighlighted : this.selectedBookmarkIcon) : this.normalBookmarkIcon);
    }
}

