/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.passwords;
import com.gitlab.pdftk_java.pdftk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import pdftk.com.lowagie.text.exceptions.InvalidPdfException;
import pdftk.com.lowagie.text.pdf.PdfReader;

class InputPdf {
    String m_filename = "";
    String m_password = "";
    boolean m_authorized_b = true;
    byte[] m_buffer = null;
    String m_role = "input";
    String m_role_determined = "an input";
    ArrayList<PagesReader> m_readers = new ArrayList();
    int m_num_pages = 0;

    InputPdf() {
    }

    PagesReader add_reader(boolean keep_artifacts_b, boolean ask_about_warnings_b) {
        boolean open_success_b = true;
        PagesReader pr = null;
        if (this.m_filename.equals("-")) {
            ask_about_warnings_b = false;
        }
        try {
            PdfReader reader = null;
            if (this.m_filename.equals("PROMPT")) {
                this.m_filename = pdftk.prompt_for_filename("Please enter a filename for " + this.m_role_determined + " PDF:");
            }
            if (this.m_password.isEmpty()) {
                if (this.m_filename.equals("-")) {
                    if (this.m_buffer == null) {
                        this.m_buffer = pdftk.readAllBytes(System.in);
                    }
                    reader = new PdfReader(this.m_buffer);
                } else {
                    reader = new PdfReader(this.m_filename);
                }
            } else {
                byte[] password;
                if (this.m_password.equals("PROMPT")) {
                    this.m_password = pdftk.prompt_for_password("open", "the " + this.m_role + " PDF:\n   " + this.m_filename);
                }
                if ((password = passwords.utf8_password_to_pdfdoc(this.m_password, false)) != null) {
                    if (this.m_filename.equals("-")) {
                        if (this.m_buffer == null) {
                            this.m_buffer = pdftk.readAllBytes(System.in);
                        }
                        reader = new PdfReader(this.m_buffer, password);
                    } else {
                        reader = new PdfReader(this.m_filename, password);
                    }
                } else {
                    System.err.println("Error: Password used to decrypt " + this.m_role + " PDF:");
                    System.err.println("   " + this.m_filename);
                    System.err.println("   includes invalid characters.");
                    return null;
                }
            }
            if (reader == null) {
                System.err.println("Error: Unexpected null from open_reader()");
                return null;
            }
            if (!keep_artifacts_b) {
                reader.consolidateNamedDestinations();
                reader.removeUnusedObjects();
            }
            this.m_num_pages = reader.getNumberOfPages();
            pr = new PagesReader(reader);
            this.m_readers.add(pr);
            this.m_authorized_b = true;
            if (open_success_b && reader.encrypted && !reader.ownerPasswordUsed) {
                System.err.println("WARNING: The creator of the " + this.m_role + " PDF:");
                System.err.println("   " + this.m_filename);
                System.err.println("   has set an owner password (which is not required to handle this PDF).");
                System.err.println("   You did not supply this password. Please respect any copyright.");
            }
            if (!this.m_authorized_b) {
                open_success_b = false;
            }
        }
        catch (InvalidPdfException e) {
            System.err.println("Error: " + e.getMessage());
            open_success_b = false;
        }
        catch (IOException ioe_p) {
            if (ioe_p.getMessage().equals("Bad password")) {
                this.m_authorized_b = false;
            } else if (ioe_p.getMessage().indexOf("not found as file or resource") != -1) {
                System.err.println("Error: Unable to find file.");
            } else {
                System.err.println("Error: Unexpected Exception in open_reader()");
                ioe_p.printStackTrace();
            }
            open_success_b = false;
        }
        catch (Throwable t_p) {
            System.err.println("Error: Unexpected Exception in open_reader()");
            t_p.printStackTrace();
            open_success_b = false;
        }
        if (!this.m_authorized_b && ask_about_warnings_b) {
            System.err.println("The password you supplied for the " + this.m_role + " PDF:");
            System.err.println("   " + this.m_filename);
            System.err.println("   did not work.  This PDF is encrypted, and you must supply the");
            System.err.println("   owner or the user password to open it. To quit, enter a blank");
            System.err.println("   password at the next prompt.");
            this.m_password = pdftk.prompt_for_password("open", "the " + this.m_role + " PDF:\n   " + this.m_filename);
            if (!this.m_password.isEmpty()) {
                this.m_authorized_b = true;
                return this.add_reader(keep_artifacts_b, ask_about_warnings_b);
            }
        }
        if (!open_success_b) {
            System.err.println("Error: Failed to open " + this.m_role + " PDF file: ");
            System.err.println("   " + this.m_filename);
            if (!this.m_authorized_b) {
                System.err.println("   OWNER OR USER PASSWORD REQUIRED, but not given (or incorrect)");
            }
        }
        return open_success_b ? pr : null;
    }

    static class PagesReader {
        HashSet<Integer> first = new HashSet();
        PdfReader second;

        PagesReader(PdfReader second) {
            this.second = second;
        }
    }
}

