/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.retrieve;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.retrieve.RetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveArtifactEvent;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveEngine$1;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class RetrieveEngine {
    private RetrieveEngineSettings settings;
    private EventManager eventManager;

    public RetrieveEngine(RetrieveEngineSettings retrieveEngineSettings, EventManager eventManager) {
        this.settings = retrieveEngineSettings;
        this.eventManager = eventManager;
    }

    /*
     * Unable to fully structure code
     */
    public RetrieveReport retrieve(ModuleRevisionId var1_1, RetrieveOptions var2_2) {
        var3_3 = new RetrieveReport();
        var4_4 = var1_1.getModuleId();
        if ("default".equals(var2_2.getLog())) {
            Message.info(":: retrieving :: " + var4_4);
        } else {
            Message.verbose(":: retrieving :: " + var4_4);
        }
        Message.verbose("\tcheckUpToDate=" + this.settings.isCheckUpToDate());
        var5_5 = System.currentTimeMillis();
        var7_6 = IvyPatternHelper.substituteVariables(var2_2.getDestArtifactPattern(), this.settings.getVariables());
        var8_7 = IvyPatternHelper.substituteVariables(null, this.settings.getVariables());
        var9_8 = this.getConfs(var1_1, var2_2);
        if ("default".equals(var2_2.getLog())) {
            Message.info("\tconfs: " + Arrays.asList(var9_8));
        } else {
            Message.verbose("\tconfs: " + Arrays.asList(var9_8));
        }
        if (this.eventManager != null) {
            this.eventManager.fireIvyEvent(new RetrieveArtifactEvent(var1_1, var9_8, var2_2));
        }
        try {
            var10_9 = this.determineArtifactsToCopy(var1_1, var7_6, var2_2);
            var11_11 = this.settings.resolveFile(IvyPatternHelper.getTokenRoot(var7_6));
            var12_12 = var8_7 == null ? null : this.settings.resolveFile(IvyPatternHelper.getTokenRoot(var8_7));
            var13_13 = new HashSet<E>();
            var14_14 = new HashSet<E>();
            var15_15 = 0L;
            for (ArtifactDownloadReport var18_18 : var10_9.keySet()) {
                var19_19 = var18_18.getLocalFile();
                if (var19_19 == null) {
                    Message.verbose("\tno local file available for " + var18_18 + ": skipping");
                    continue;
                }
                var20_20 = (Set)var10_9.get(var18_18);
                Message.verbose("\tretrieving " + var19_19);
                var21_21 = var20_20.iterator();
                while (var21_21.hasNext()) {
                    IvyContext.getContext().checkInterrupted();
                    var22_22 = this.settings.resolveFile((String)var21_21.next());
                    if (!this.settings.isCheckUpToDate()) ** GOTO lbl-1000
                    var25_25 = var2_2;
                    var24_24 = var22_22;
                    var23_23 = var19_19;
                    if (!var24_24.exists() || "always".equals(var26_26 = var25_25.getOverwriteMode())) ** GOTO lbl-1000
                    if ("never".equals(var26_26)) {
                        v0 = true;
                    } else if ("newer".equals(var26_26)) {
                        v0 = var23_23.lastModified() <= var24_24.lastModified();
                    } else if ("different".equals(var26_26)) {
                        v0 = var23_23.lastModified() == var24_24.lastModified();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) lbl-1000:
                    // 2 sources

                    {
                        Message.verbose("\t\tto " + var22_22);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new StartRetrieveArtifactEvent(var18_18, var22_22));
                        }
                        FileUtil.copy((File)var19_19, var22_22, null, true);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new RetrieveArtifactEvent(var18_18, var22_22));
                        }
                        var15_15 += var22_22.length();
                        var3_3.addCopiedFile(var22_22, var18_18);
                    } else {
                        Message.verbose("\t\tto " + var22_22 + " [NOT REQUIRED]");
                        var3_3.addUpToDateFile(var22_22, var18_18);
                    }
                    if ("ivy".equals(var18_18.getType())) {
                        var14_14.addAll(FileUtil.getPathFiles(var12_12, var22_22));
                        continue;
                    }
                    var13_13.addAll(FileUtil.getPathFiles(var11_11, var22_22));
                }
            }
            var17_17 = System.currentTimeMillis() - var5_5;
            var19_19 = "\t" + var3_3.getNbrArtifactsCopied() + " artifacts copied" + (this.settings.isCheckUpToDate() != false ? ", " + var3_3.getNbrArtifactsUpToDate() + " already retrieved" : "") + " (" + var15_15 / 1024L + "kB/" + var17_17 + "ms)";
            if ("default".equals(var2_2.getLog())) {
                Message.info((String)var19_19);
            } else {
                Message.verbose((String)var19_19);
            }
            Message.verbose("\tretrieve done (" + var17_17 + "ms)");
            if (this.eventManager != null) {
                this.eventManager.fireIvyEvent(new RetrieveArtifactEvent(var1_1, var9_8, var17_17, var3_3.getNbrArtifactsCopied(), var3_3.getNbrArtifactsUpToDate(), var15_15, var2_2));
            }
            return var3_3;
        }
        catch (Exception var10_10) {
            throw new RuntimeException("problem during retrieve of " + var4_4 + ": " + var10_10, var10_10);
        }
    }

    private String[] getConfs(ModuleRevisionId moduleRevisionId, RetrieveOptions retrieveOptions) {
        String[] stringArray = retrieveOptions.getConfs();
        if (stringArray == null || stringArray.length == 1 && "*".equals(stringArray[0])) {
            try {
                ModuleDescriptor moduleDescriptor = this.getCache().getResolvedModuleDescriptor(moduleRevisionId);
                Message.verbose("no explicit confs given for retrieve, using ivy file: " + moduleDescriptor.getResource().getName());
                stringArray = moduleDescriptor.getConfigurationsNames();
                retrieveOptions.setConfs(stringArray);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        }
        return stringArray;
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    public final Map determineArtifactsToCopy(ModuleRevisionId moduleRevisionId, String string, RetrieveOptions retrieveOptions) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Collection<ArtifactDownloadReport> collection;
        Object object5;
        ModuleId moduleId = moduleRevisionId.getModuleId();
        if (retrieveOptions.getResolveId() == null) {
            retrieveOptions.setResolveId(ResolveOptions.getDefaultResolveId(moduleId));
        }
        ResolutionCacheManager resolutionCacheManager = this.getCache();
        String[] stringArray = this.getConfs(moduleRevisionId, retrieveOptions);
        String string2 = IvyPatternHelper.substituteVariables(null, this.settings.getVariables());
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        XmlReportParser xmlReportParser = new XmlReportParser();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            object5 = resolutionCacheManager.getConfigurationResolveReportInCache(retrieveOptions.getResolveId(), string3);
            xmlReportParser.parse((File)object5);
            collection = new ArrayList<ArtifactDownloadReport>(Arrays.asList(xmlReportParser.getArtifactReports()));
            if (string2 != null) {
                object4 = xmlReportParser.getRealDependencyRevisionIds();
                for (int j = 0; j < ((Object)object4).length; ++j) {
                    collection.add(xmlReportParser.getMetadataArtifactReport((ModuleRevisionId)object4[j]));
                }
            }
            for (ArtifactDownloadReport artifactDownloadReport : collection) {
                Object object6 = object3 = "ivy".equals(artifactDownloadReport.getType()) ? string2 : string;
                if (!"ivy".equals(artifactDownloadReport.getType()) && !retrieveOptions.getArtifactFilter().accept(artifactDownloadReport.getArtifact())) continue;
                String string4 = IvyPatternHelper.substitute((String)object3, artifactDownloadReport.getArtifact().getModuleRevisionId(), artifactDownloadReport.getArtifact(), string3, artifactDownloadReport.getArtifactOrigin());
                object2 = (Set)hashMap.get(artifactDownloadReport);
                if (object2 == null) {
                    object2 = new HashSet<String>();
                    hashMap.put(artifactDownloadReport, object2);
                }
                object = this.settings.resolveFile(string4).getAbsolutePath();
                String[] stringArray2 = new String[]{object};
                for (int j = 0; j < stringArray2.length; ++j) {
                    object2.add(stringArray2[j]);
                    HashSet<ArtifactRevisionId> hashSet = (HashSet<ArtifactRevisionId>)hashMap2.get(stringArray2[j]);
                    HashSet<ArtifactDownloadReport> hashSet2 = (HashSet<ArtifactDownloadReport>)hashMap3.get(stringArray2[j]);
                    HashSet<String> hashSet3 = (HashSet<String>)hashMap4.get(stringArray2[j]);
                    if (hashSet == null) {
                        hashSet = new HashSet<ArtifactRevisionId>();
                        hashMap2.put(stringArray2[j], hashSet);
                    }
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<ArtifactDownloadReport>();
                        hashMap3.put(stringArray2[j], hashSet2);
                    }
                    if (hashSet3 == null) {
                        hashSet3 = new HashSet<String>();
                        hashMap4.put(stringArray2[j], hashSet3);
                    }
                    if (!hashSet.add(artifactDownloadReport.getArtifact().getId())) continue;
                    hashSet2.add(artifactDownloadReport);
                    hashSet3.add(string3);
                }
            }
        }
        for (String string3 : hashMap2.keySet()) {
            int n;
            object5 = (Set)hashMap2.get(string3);
            collection = (Set)hashMap4.get(string3);
            if (object5.size() <= 1) continue;
            object4 = new ArrayList((Collection)hashMap3.get(string3));
            Collections.sort(object4, new RetrieveEngine$1());
            object3 = ((ArtifactDownloadReport)object4.get(object4.size() - 1)).getArtifact().getModuleRevisionId();
            for (n = object4.size() - 2; n >= 0; --n) {
                object2 = (ArtifactDownloadReport)object4.get(n);
                if (!((ModuleRevisionId)object3).equals(((ArtifactDownloadReport)object2).getArtifact().getModuleRevisionId())) continue;
                throw new RuntimeException("Multiple artifacts of the module " + object3 + " are retrieved to the same file! Update the retrieve pattern  to fix this error.");
            }
            Message.info("\tconflict on " + string3 + " in " + collection + ": " + ((ModuleRevisionId)object3).getRevision() + " won");
            for (n = object4.size() - 2; n >= 0; --n) {
                object2 = (ArtifactDownloadReport)object4.get(n);
                Message.verbose("\t\tremoving conflict looser artifact: " + ((ArtifactDownloadReport)object2).getArtifact());
                object = (Set)hashMap.get(object2);
                object.remove(string3);
                if (!object.isEmpty()) continue;
                hashMap.remove(object2);
            }
        }
        return hashMap;
    }
}

