/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.tabbedpane;

import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.protege.editor.core.ui.tabbedpane.TabCloseHandler;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceTabCloseHandler
implements TabCloseHandler {
    private final Logger logger = LoggerFactory.getLogger((String)TabCloseHandler.class.getName());

    @Override
    public boolean shouldCloseTab(int tabIndex, JTabbedPane tabbedPane) {
        int ret = JOptionPane.showConfirmDialog(tabbedPane, String.format("Do you want to close the %s tab?", tabbedPane.getTitleAt(tabIndex)), "Close tab?", 0);
        return ret == 0;
    }

    @Override
    public void handleCloseTab(int tabIndex, JTabbedPane tabbedPane) {
        WorkspaceTab workspaceTab = (WorkspaceTab)tabbedPane.getComponentAt(tabIndex);
        workspaceTab.getWorkspace().removeTab(workspaceTab);
        try {
            workspaceTab.dispose();
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst disposing of a tab.", (Throwable)e);
        }
    }
}

