/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.deprecation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.editor.owl.model.conf.IRIExpander;
import org.protege.editor.owl.model.deprecation.DeprecationCode;
import org.semanticweb.owlapi.model.IRI;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeprecationProfile {
    @Nonnull
    private final String name;
    @Nonnull
    private final String description;
    @Nullable
    private final String activatedBy;
    private final boolean removeLogicalDefinition;
    private final boolean removeAnnotationAssertions;
    @Nullable
    private final String replacedByAnnotationPropertyIri;
    @Nullable
    private final String textualReasonAnnotationPropertyIri;
    @Nullable
    private final String alternateEntityAnnotationPropertyIri;
    @Nullable
    private final String labelPrefix;
    @Nullable
    private final String annotationValuePrefix;
    @Nonnull
    private final Set<String> preservedAnnotationAssertionPropertyIris;
    @Nullable
    private final String deprecatedClassParentIri;
    @Nullable
    private final String deprecatedObjectPropertyParentIri;
    @Nullable
    private final String deprecatedDataPropertyParentIri;
    @Nullable
    private final String deprecatedAnnotationPropertyParentIri;
    @Nullable
    private final String deprecatedIndividualParentClassIri;
    @Nullable
    private final DeprecationCode deprecationCode;

    @JsonCreator
    public DeprecationProfile(@Nonnull @JsonProperty(value="name", required=true) String name, @Nonnull @JsonProperty(value="description", required=true) String description, @Nullable @JsonProperty(value="activatedBy") String activatedBy, @JsonProperty(value="removeLogicalDefinition") boolean removeLogicalDefinition, @JsonProperty(value="removeAnnotationAssertions") boolean removeAnnotationAssertions, @JsonProperty(value="replacedByAnnotationPropertyIri") String replacedByAnnotationPropertyIri, @JsonProperty(value="textualReasonAnnotationPropertyIri") String textualReasonAnnotationPropertyIri, @JsonProperty(value="alternateEntityAnnotationPropertyIri") String alternateEntityAnnotationPropertyIri, @Nonnull @JsonProperty(value="labelPrefix", defaultValue="") String labelPrefix, @Nonnull @JsonProperty(value="annotationValuePrefix", defaultValue="") String annotationValuePrefix, @Nullable @JsonProperty(value="preservedAnnotationAssertionPropertyIris") Set<String> preservedAnnotationAssertionPropertyIris, @Nullable @JsonProperty(value="deprecatedClassParentIri") String deprecatedClassParentIri, @Nullable @JsonProperty(value="deprecatedObjectPropertyParentIri") String deprecatedObjectPropertyParentIri, @Nullable @JsonProperty(value="deprecatedDataPropertyParentIri") String deprecatedDataPropertyParentIri, @Nullable @JsonProperty(value="deprecatedAnnotationPropertyParentIri") String deprecatedAnnotationPropertyParentIri, @Nullable @JsonProperty(value="deprecatedIndividualParentClassIri") String deprecatedIndividualParentClassIri, @Nullable @JsonProperty(value="deprecationCode") DeprecationCode deprecationCode) {
        this.name = name;
        this.description = description;
        this.activatedBy = activatedBy;
        this.removeLogicalDefinition = removeLogicalDefinition;
        this.removeAnnotationAssertions = removeAnnotationAssertions;
        this.replacedByAnnotationPropertyIri = replacedByAnnotationPropertyIri;
        this.textualReasonAnnotationPropertyIri = textualReasonAnnotationPropertyIri;
        this.alternateEntityAnnotationPropertyIri = alternateEntityAnnotationPropertyIri;
        this.labelPrefix = labelPrefix;
        this.annotationValuePrefix = annotationValuePrefix;
        this.preservedAnnotationAssertionPropertyIris = preservedAnnotationAssertionPropertyIris != null ? preservedAnnotationAssertionPropertyIris : Collections.emptySet();
        this.deprecatedClassParentIri = deprecatedClassParentIri;
        this.deprecatedObjectPropertyParentIri = deprecatedObjectPropertyParentIri;
        this.deprecatedDataPropertyParentIri = deprecatedDataPropertyParentIri;
        this.deprecatedAnnotationPropertyParentIri = deprecatedAnnotationPropertyParentIri;
        this.deprecatedIndividualParentClassIri = deprecatedIndividualParentClassIri;
        this.deprecationCode = deprecationCode;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Optional<IRI> getActivatedBy() {
        return Optional.ofNullable(this.activatedBy).map(IRI::create);
    }

    public boolean shouldRemoveLogicalDefinition() {
        return this.removeLogicalDefinition;
    }

    public boolean shouldRemoveAnnotationAssertions() {
        return this.removeAnnotationAssertions;
    }

    @Nonnull
    public Optional<IRI> getReplacedByAnnotationPropertyIri() {
        return DeprecationProfile.expandIri(this.replacedByAnnotationPropertyIri);
    }

    @Nonnull
    public Optional<IRI> getDeprecationTextualReasonAnnotationPropertyIri() {
        return DeprecationProfile.expandIri(this.textualReasonAnnotationPropertyIri);
    }

    @Nonnull
    public Optional<IRI> getAlternateEntityAnnotationPropertyIri() {
        return DeprecationProfile.expandIri(this.alternateEntityAnnotationPropertyIri);
    }

    @Nonnull
    public String getDeprecatedEntityLabelPrefix() {
        return this.labelPrefix != null ? this.labelPrefix : "";
    }

    @Nonnull
    public String getPreservedAnnotationValuePrefix() {
        return this.annotationValuePrefix != null ? this.annotationValuePrefix : "";
    }

    @Nonnull
    public Set<IRI> getPreservedAnnotationValuePropertiesIris() {
        return this.preservedAnnotationAssertionPropertyIris.stream().map(DeprecationProfile::expandIri).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Nonnull
    public Optional<IRI> getDeprecatedClassParentIri() {
        return DeprecationProfile.expandIri(this.deprecatedClassParentIri);
    }

    @Nonnull
    public Optional<IRI> getDeprecatedObjectPropertyParentIri() {
        return DeprecationProfile.expandIri(this.deprecatedObjectPropertyParentIri);
    }

    @Nonnull
    public Optional<IRI> getDeprecatedDataPropertyParentIri() {
        return DeprecationProfile.expandIri(this.deprecatedDataPropertyParentIri);
    }

    @Nonnull
    public Optional<IRI> getDeprecatedAnnotationPropertyParentIri() {
        return DeprecationProfile.expandIri(this.deprecatedAnnotationPropertyParentIri);
    }

    @Nonnull
    public Optional<IRI> getDeprecatedIndividualParentClassIri() {
        return DeprecationProfile.expandIri(this.deprecatedIndividualParentClassIri);
    }

    @Nonnull
    public Optional<DeprecationCode> getDeprecationCode() {
        return Optional.ofNullable(this.deprecationCode);
    }

    private static Optional<IRI> expandIri(@Nullable String iri) {
        return IRIExpander.expand(iri);
    }
}

