/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Vector;
import javax.accessibility.AccessibleState;

public class AccessibleStateSet {
    protected Vector<AccessibleState> states = null;

    public AccessibleStateSet() {
        this.states = null;
    }

    public AccessibleStateSet(AccessibleState[] states) {
        if (states.length != 0) {
            this.states = new Vector(states.length);
            for (int i = 0; i < states.length; ++i) {
                if (this.states.contains(states[i])) continue;
                this.states.addElement(states[i]);
            }
        }
    }

    public boolean add(AccessibleState state) {
        if (this.states == null) {
            this.states = new Vector();
        }
        if (!this.states.contains(state)) {
            this.states.addElement(state);
            return true;
        }
        return false;
    }

    public void addAll(AccessibleState[] states) {
        if (states.length != 0) {
            if (this.states == null) {
                this.states = new Vector(states.length);
            }
            for (int i = 0; i < states.length; ++i) {
                if (this.states.contains(states[i])) continue;
                this.states.addElement(states[i]);
            }
        }
    }

    public boolean remove(AccessibleState state) {
        if (this.states == null) {
            return false;
        }
        return this.states.removeElement(state);
    }

    public void clear() {
        if (this.states != null) {
            this.states.removeAllElements();
        }
    }

    public boolean contains(AccessibleState state) {
        if (this.states == null) {
            return false;
        }
        return this.states.contains(state);
    }

    public AccessibleState[] toArray() {
        if (this.states == null) {
            return new AccessibleState[0];
        }
        AccessibleState[] stateArray = new AccessibleState[this.states.size()];
        for (int i = 0; i < stateArray.length; ++i) {
            stateArray[i] = this.states.elementAt(i);
        }
        return stateArray;
    }

    public String toString() {
        String ret = null;
        if (this.states != null && this.states.size() > 0) {
            ret = this.states.elementAt(0).toDisplayString();
            for (int i = 1; i < this.states.size(); ++i) {
                ret = ret + "," + this.states.elementAt(i).toDisplayString();
            }
        }
        return ret;
    }
}

