/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    private static final long oldSerialVersionUID = -8179019472410837190L;
    private static final long newSerialVersionUID = 4611072955724144607L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myTypeName", String.class), new ObjectStreamField("myRoleName2InfoMap", HashMap.class), new ObjectStreamField("myIsInRelServFlg", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("typeName", String.class), new ObjectStreamField("roleName2InfoMap", Map.class), new ObjectStreamField("isInRelationService", Boolean.TYPE)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String typeName = null;
    private Map<String, RoleInfo> roleName2InfoMap = new HashMap<String, RoleInfo>();
    private boolean isInRelationService = false;

    public RelationTypeSupport(String relationTypeName, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeName == null || roleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "RelationTypeSupport", relationTypeName);
        this.initMembers(relationTypeName, roleInfoArray);
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "RelationTypeSupport");
    }

    protected RelationTypeSupport(String relationTypeName) {
        if (relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "RelationTypeSupport", relationTypeName);
        this.typeName = relationTypeName;
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "RelationTypeSupport");
    }

    @Override
    public String getRelationTypeName() {
        return this.typeName;
    }

    @Override
    public List<RoleInfo> getRoleInfos() {
        return new ArrayList<RoleInfo>(this.roleName2InfoMap.values());
    }

    @Override
    public RoleInfo getRoleInfo(String roleInfoName) throws IllegalArgumentException, RoleInfoNotFoundException {
        if (roleInfoName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "getRoleInfo", roleInfoName);
        RoleInfo result = this.roleName2InfoMap.get(roleInfoName);
        if (result == null) {
            StringBuilder excMsgStrB = new StringBuilder();
            String excMsg = "No role info for role ";
            excMsgStrB.append(excMsg);
            excMsgStrB.append(roleInfoName);
            throw new RoleInfoNotFoundException(excMsgStrB.toString());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "getRoleInfo");
        return result;
    }

    protected void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "addRoleInfo", roleInfo);
        if (this.isInRelationService) {
            String excMsg = "Relation type cannot be updated as it is declared in the Relation Service.";
            throw new RuntimeException(excMsg);
        }
        String roleName = roleInfo.getName();
        if (this.roleName2InfoMap.containsKey(roleName)) {
            StringBuilder excMsgStrB = new StringBuilder();
            String excMsg = "Two role infos provided for role ";
            excMsgStrB.append(excMsg);
            excMsgStrB.append(roleName);
            throw new InvalidRelationTypeException(excMsgStrB.toString());
        }
        this.roleName2InfoMap.put(roleName, new RoleInfo(roleInfo));
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "addRoleInfo");
    }

    void setRelationServiceFlag(boolean flag) {
        this.isInRelationService = flag;
    }

    private void initMembers(String relationTypeName, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeName == null || roleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "initMembers", relationTypeName);
        this.typeName = relationTypeName;
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        for (int i = 0; i < roleInfoArray.length; ++i) {
            RoleInfo currRoleInfo = roleInfoArray[i];
            this.roleName2InfoMap.put(currRoleInfo.getName(), new RoleInfo(currRoleInfo));
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "initMembers");
    }

    static void checkRoleInfos(RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (roleInfoArray.length == 0) {
            String excMsg = "No role info provided.";
            throw new InvalidRelationTypeException(excMsg);
        }
        HashSet<String> roleNames = new HashSet<String>();
        for (int i = 0; i < roleInfoArray.length; ++i) {
            RoleInfo currRoleInfo = roleInfoArray[i];
            if (currRoleInfo == null) {
                String excMsg = "Null role info provided.";
                throw new InvalidRelationTypeException(excMsg);
            }
            String roleName = currRoleInfo.getName();
            if (roleNames.contains(roleName)) {
                StringBuilder excMsgStrB = new StringBuilder();
                String excMsg = "Two role infos provided for role ";
                excMsgStrB.append(excMsg);
                excMsgStrB.append(roleName);
                throw new InvalidRelationTypeException(excMsgStrB.toString());
            }
            roleNames.add(roleName);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.typeName = (String)fields.get("myTypeName", null);
            if (fields.defaulted("myTypeName")) {
                throw new NullPointerException("myTypeName");
            }
            this.roleName2InfoMap = (Map)Util.cast(fields.get("myRoleName2InfoMap", null));
            if (fields.defaulted("myRoleName2InfoMap")) {
                throw new NullPointerException("myRoleName2InfoMap");
            }
            this.isInRelationService = fields.get("myIsInRelServFlg", false);
            if (fields.defaulted("myIsInRelServFlg")) {
                throw new NullPointerException("myIsInRelServFlg");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myTypeName", this.typeName);
            fields.put("myRoleName2InfoMap", this.roleName2InfoMap);
            fields.put("myIsInRelServFlg", this.isInRelationService);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -8179019472410837190L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 4611072955724144607L;
        }
    }
}

