/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.io.ListenCallback;
import org.apache.catalina.tribes.jmx.JmxRegistry;
import org.apache.catalina.tribes.transport.RxTaskPool;
import org.apache.catalina.tribes.util.ExecutorFactory;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class ReceiverBase
implements ChannelReceiver,
ListenCallback,
RxTaskPool.TaskCreator {
    public static final int OPTION_DIRECT_BUFFER = 4;
    private static final Log log = LogFactory.getLog(ReceiverBase.class);
    private static final Object bindLock = new Object();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.transport");
    private MessageListener listener;
    private String host = "auto";
    private InetAddress bind;
    private int port = 4000;
    private int udpPort = -1;
    private int securePort = -1;
    private int rxBufSize = 43800;
    private int txBufSize = 25188;
    private int udpRxBufSize = 43800;
    private int udpTxBufSize = 25188;
    private volatile boolean listen = false;
    private RxTaskPool pool;
    private boolean direct = true;
    private long tcpSelectorTimeout = 5000L;
    private int autoBind = 100;
    private int maxThreads = 15;
    private int minThreads = 6;
    private int maxTasks = 100;
    private int minTasks = 10;
    private boolean tcpNoDelay = true;
    private boolean soKeepAlive = false;
    private boolean ooBInline = true;
    private boolean soReuseAddress = true;
    private boolean soLingerOn = true;
    private int soLingerTime = 3;
    private int soTrafficClass = 28;
    private int timeout = 3000;
    private boolean useBufferPool = true;
    private boolean daemon = true;
    private long maxIdleTime = 60000L;
    private ExecutorService executor;
    private Channel channel;
    private ObjectName oname = null;

    @Override
    public void start() throws IOException {
        Object object;
        if (this.executor == null) {
            object = "";
            if (this.channel.getName() != null) {
                object = "[" + this.channel.getName() + "]";
            }
            TaskThreadFactory taskThreadFactory = new TaskThreadFactory("Tribes-Task-Receiver" + (String)object + "-");
            this.executor = ExecutorFactory.newThreadPool(this.minThreads, this.maxThreads, this.maxIdleTime, TimeUnit.MILLISECONDS, taskThreadFactory);
        }
        if ((object = JmxRegistry.getRegistry(this.channel)) != null) {
            this.oname = ((JmxRegistry)object).registerJmx(",component=Receiver", this);
        }
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
        if (this.oname != null) {
            JmxRegistry jmxRegistry = JmxRegistry.getRegistry(this.channel);
            if (jmxRegistry != null) {
                jmxRegistry.unregisterJmx(this.oname);
            }
            this.oname = null;
        }
        this.channel = null;
    }

    @Override
    public MessageListener getMessageListener() {
        return this.listener;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public int getRxBufSize() {
        return this.rxBufSize;
    }

    public int getTxBufSize() {
        return this.txBufSize;
    }

    @Override
    public void setMessageListener(MessageListener messageListener) {
        this.listener = messageListener;
    }

    public void setRxBufSize(int n) {
        this.rxBufSize = n;
    }

    public void setTxBufSize(int n) {
        this.txBufSize = n;
    }

    public InetAddress getBind() {
        if (this.bind == null) {
            try {
                if ("auto".equals(this.host)) {
                    this.host = InetAddress.getLocalHost().getHostAddress();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starting replication listener on address:" + this.host));
                }
                this.bind = InetAddress.getByName(this.host);
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("receiverBase.bind.failed", this.host), (Throwable)iOException);
            }
        }
        return this.bind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(ServerSocket serverSocket, int n, int n2) throws IOException {
        Object object = bindLock;
        synchronized (object) {
            InetSocketAddress inetSocketAddress = null;
            int n3 = n;
            while (n2 > 0) {
                try {
                    inetSocketAddress = new InetSocketAddress(this.getBind(), n3);
                    serverSocket.bind(inetSocketAddress);
                    this.setPort(n3);
                    log.info((Object)sm.getString("receiverBase.socket.bind", inetSocketAddress));
                    n2 = 0;
                }
                catch (IOException iOException) {
                    if (--n2 <= 0) {
                        log.info((Object)sm.getString("receiverBase.unable.bind", inetSocketAddress));
                        throw iOException;
                    }
                    ++n3;
                }
            }
        }
    }

    protected int bindUdp(DatagramSocket datagramSocket, int n, int n2) throws IOException {
        InetSocketAddress inetSocketAddress = null;
        while (n2 > 0) {
            try {
                inetSocketAddress = new InetSocketAddress(this.getBind(), n);
                datagramSocket.bind(inetSocketAddress);
                this.setUdpPort(n);
                log.info((Object)sm.getString("receiverBase.udp.bind", inetSocketAddress));
                return 0;
            }
            catch (IOException iOException) {
                if (--n2 <= 0) {
                    log.info((Object)sm.getString("receiverBase.unable.bind.udp", inetSocketAddress));
                    throw iOException;
                }
                ++n;
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                n2 = this.bindUdp(datagramSocket, n, n2);
            }
        }
        return n2;
    }

    @Override
    public void messageDataReceived(ChannelMessage channelMessage) {
        if (this.listener != null && this.listener.accept(channelMessage)) {
            this.listener.messageReceived(channelMessage);
        }
    }

    public int getWorkerThreadOptions() {
        int n = 0;
        if (this.getDirect()) {
            n |= 4;
        }
        return n;
    }

    public void setBind(InetAddress inetAddress) {
        this.bind = inetAddress;
    }

    public boolean getDirect() {
        return this.direct;
    }

    public void setDirect(boolean bl) {
        this.direct = bl;
    }

    public String getAddress() {
        this.getBind();
        return this.host;
    }

    @Override
    public String getHost() {
        return this.getAddress();
    }

    public long getSelectorTimeout() {
        return this.tcpSelectorTimeout;
    }

    public boolean doListen() {
        return this.listen;
    }

    public MessageListener getListener() {
        return this.listener;
    }

    public RxTaskPool getTaskPool() {
        return this.pool;
    }

    public int getAutoBind() {
        return this.autoBind;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean getSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean getOoBInline() {
        return this.ooBInline;
    }

    public boolean getSoLingerOn() {
        return this.soLingerOn;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    public int getSoTrafficClass() {
        return this.soTrafficClass;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getUseBufferPool() {
        return this.useBufferPool;
    }

    @Override
    public int getSecurePort() {
        return this.securePort;
    }

    public int getMinTasks() {
        return this.minTasks;
    }

    public int getMaxTasks() {
        return this.maxTasks;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public boolean isListening() {
        return this.listen;
    }

    public void setSelectorTimeout(long l) {
        this.tcpSelectorTimeout = l;
    }

    public void setListen(boolean bl) {
        this.listen = bl;
    }

    public void setAddress(String string) {
        this.host = string;
    }

    public void setHost(String string) {
        this.setAddress(string);
    }

    public void setListener(MessageListener messageListener) {
        this.listener = messageListener;
    }

    public void setPool(RxTaskPool rxTaskPool) {
        this.pool = rxTaskPool;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setAutoBind(int n) {
        this.autoBind = n;
        if (this.autoBind <= 0) {
            this.autoBind = 1;
        }
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    public void setMinThreads(int n) {
        this.minThreads = n;
    }

    public void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    public void setSoKeepAlive(boolean bl) {
        this.soKeepAlive = bl;
    }

    public void setOoBInline(boolean bl) {
        this.ooBInline = bl;
    }

    public void setSoLingerOn(boolean bl) {
        this.soLingerOn = bl;
    }

    public void setSoLingerTime(int n) {
        this.soLingerTime = n;
    }

    public void setSoReuseAddress(boolean bl) {
        this.soReuseAddress = bl;
    }

    public void setSoTrafficClass(int n) {
        this.soTrafficClass = n;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setUseBufferPool(boolean bl) {
        this.useBufferPool = bl;
    }

    public void setSecurePort(int n) {
        this.securePort = n;
    }

    public void setMinTasks(int n) {
        this.minTasks = n;
    }

    public void setMaxTasks(int n) {
        this.maxTasks = n;
    }

    public void setExecutor(ExecutorService executorService) {
        this.executor = executorService;
    }

    @Override
    public void heartbeat() {
    }

    @Override
    public int getUdpPort() {
        return this.udpPort;
    }

    public void setUdpPort(int n) {
        this.udpPort = n;
    }

    public int getUdpRxBufSize() {
        return this.udpRxBufSize;
    }

    public void setUdpRxBufSize(int n) {
        this.udpRxBufSize = n;
    }

    public int getUdpTxBufSize() {
        return this.udpTxBufSize;
    }

    public void setUdpTxBufSize(int n) {
        this.udpTxBufSize = n;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public int getPoolSize() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getPoolSize();
        }
        return -1;
    }

    public int getActiveCount() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getActiveCount();
        }
        return -1;
    }

    public long getTaskCount() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getTaskCount();
        }
        return -1L;
    }

    public long getCompletedTaskCount() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getCompletedTaskCount();
        }
        return -1L;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public void setMaxIdleTime(long l) {
        this.maxIdleTime = l;
    }

    class TaskThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        TaskThreadFactory(String string) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement());
            thread.setDaemon(ReceiverBase.this.daemon);
            thread.setPriority(5);
            return thread;
        }
    }
}

