/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodSuperSearcher
extends QueryExecutorBase<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.MethodSuperSearcher");

    public MethodSuperSearcher() {
        super(true);
    }

    @Override
    public void processQuery(@NotNull SuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super MethodSignatureBackedByPsiMethod> consumer) {
        if (queryParameters == null) {
            MethodSuperSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MethodSuperSearcher.$$$reportNull$$$0(1);
        }
        PsiClass parentClass = queryParameters.getPsiClass();
        PsiMethod method = queryParameters.getMethod();
        HierarchicalMethodSignature signature2 = method.getHierarchicalMethodSignature();
        boolean checkBases = queryParameters.isCheckBases();
        boolean allowStaticMethod = queryParameters.isAllowStaticMethod();
        List<HierarchicalMethodSignature> supers = signature2.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature2) || MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer)) continue;
            return;
        }
    }

    private static boolean addSuperMethods(HierarchicalMethodSignature signature2, PsiMethod method, PsiClass parentClass, boolean allowStaticMethod, boolean checkBases, Processor<? super MethodSignatureBackedByPsiMethod> consumer) {
        PsiMethod signatureMethod = signature2.getMethod();
        PsiClass hisClass = signatureMethod.getContainingClass();
        if ((parentClass == null || InheritanceUtil.isInheritorOrSelf(parentClass, hisClass, true)) && MethodSuperSearcher.isAcceptable(signatureMethod, method, allowStaticMethod)) {
            if (parentClass != null && !parentClass.equals(hisClass) && !checkBases) {
                return true;
            }
            LOG.assertTrue(signatureMethod != method, method);
            return consumer.process(signature2);
        }
        for (HierarchicalMethodSignature superSignature : signature2.getSuperSignatures()) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature2)) continue;
            MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer);
        }
        return true;
    }

    private static boolean isAcceptable(PsiMethod superMethod, PsiMethod method, boolean allowStaticMethod) {
        boolean hisStatic = superMethod.hasModifierProperty("static");
        return hisStatic == method.hasModifierProperty("static") && (allowStaticMethod || !hisStatic) && JavaPsiFacade.getInstance(method.getProject()).getResolveHelper().isAccessible(superMethod, method, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/MethodSuperSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

