/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class Acceptor<U>
implements Runnable {
    private static final Log log = LogFactory.getLog(Acceptor.class);
    private static final StringManager sm = StringManager.getManager(Acceptor.class);
    private static final int INITIAL_ERROR_DELAY = 50;
    private static final int MAX_ERROR_DELAY = 1600;
    private final AbstractEndpoint<?, U> endpoint;
    private String threadName;
    private volatile boolean stopCalled = false;
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    protected volatile AcceptorState state = AcceptorState.NEW;

    public Acceptor(AbstractEndpoint<?, U> abstractEndpoint) {
        this.endpoint = abstractEndpoint;
    }

    public final AcceptorState getState() {
        return this.state;
    }

    final void setThreadName(String string) {
        this.threadName = string;
    }

    final String getThreadName() {
        return this.threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int n = 0;
        try {
            while (!this.stopCalled) {
                while (this.endpoint.isPaused() && !this.stopCalled) {
                    this.state = AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.stopCalled) break;
                this.state = AcceptorState.RUNNING;
                try {
                    this.endpoint.countUpOrAwaitConnection();
                    if (this.endpoint.isPaused()) continue;
                    Object u = null;
                    try {
                        u = this.endpoint.serverSocketAccept();
                    }
                    catch (Exception exception) {
                        this.endpoint.countDownConnection();
                        if (this.endpoint.isRunning()) {
                            n = this.handleExceptionWithDelay(n);
                            throw exception;
                        }
                        break;
                    }
                    n = 0;
                    if (!this.stopCalled && !this.endpoint.isPaused()) {
                        if (this.endpoint.setSocketOptions(u)) continue;
                        this.endpoint.closeSocket(u);
                        continue;
                    }
                    this.endpoint.destroySocket(u);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    String string = sm.getString("endpoint.accept.fail");
                    if (throwable instanceof Error) {
                        Error error = (Error)throwable;
                        if (error.getError() == 233) {
                            log.warn((Object)string, throwable);
                            continue;
                        }
                        log.error((Object)string, throwable);
                        continue;
                    }
                    log.error((Object)string, throwable);
                }
            }
        }
        finally {
            this.stopLatch.countDown();
        }
        this.state = AcceptorState.ENDED;
    }

    public void stop() {
        this.stopCalled = true;
        try {
            this.stopLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected int handleExceptionWithDelay(int n) {
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n == 0) {
            return 50;
        }
        if (n < 1600) {
            return n * 2;
        }
        return 1600;
    }

    public static enum AcceptorState {
        NEW,
        RUNNING,
        PAUSED,
        ENDED;

    }
}

