/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.Util;
import javax.el.ValueExpression;

public abstract class ExpressionFactory {
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    private static final String PROPERTY_NAME = "javax.el.ExpressionFactory";
    private static final String PROPERTY_FILE;
    private static final CacheValue nullTcclFactory;
    private static final Map<CacheKey, CacheValue> factoryCache;

    public static ExpressionFactory newInstance() {
        return ExpressionFactory.newInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionFactory newInstance(Properties properties) {
        Object object;
        Class<?> clazz;
        Object object2;
        Object object3;
        CacheValue cacheValue;
        ExpressionFactory expressionFactory = null;
        ClassLoader classLoader = Util.getContextClassLoader();
        if (classLoader == null) {
            cacheValue = nullTcclFactory;
        } else {
            object3 = new CacheKey(classLoader);
            cacheValue = factoryCache.get(object3);
            if (cacheValue == null && (cacheValue = factoryCache.putIfAbsent((CacheKey)object3, (CacheValue)(object2 = new CacheValue()))) == null) {
                cacheValue = object2;
            }
        }
        object3 = cacheValue.getLock().readLock();
        object3.lock();
        try {
            clazz = cacheValue.getFactoryClass();
        }
        finally {
            object3.unlock();
        }
        if (clazz == null) {
            object2 = null;
            try {
                object = cacheValue.getLock().writeLock();
                object.lock();
                try {
                    object2 = cacheValue.getFactoryClassName();
                    if (object2 == null) {
                        object2 = ExpressionFactory.discoverClassName(classLoader);
                        cacheValue.setFactoryClassName((String)object2);
                    }
                    clazz = classLoader == null ? Class.forName((String)object2) : classLoader.loadClass((String)object2);
                    cacheValue.setFactoryClass(clazz);
                }
                finally {
                    object.unlock();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ELException(Util.message(null, "expressionFactory.cannotFind", object2), classNotFoundException);
            }
        }
        try {
            object2 = null;
            if (properties != null) {
                try {
                    object2 = clazz.getConstructor(Properties.class);
                }
                catch (SecurityException securityException) {
                    throw new ELException(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            expressionFactory = object2 == null ? (ExpressionFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]) : (ExpressionFactory)((Constructor)object2).newInstance(properties);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getCause();
            Util.handleThrowable((Throwable)object);
            throw new ELException(Util.message(null, "expressionFactory.cannotCreate", clazz.getName()), invocationTargetException);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new ELException(Util.message(null, "expressionFactory.cannotCreate", clazz.getName()), exception);
        }
        return expressionFactory;
    }

    public abstract ValueExpression createValueExpression(ELContext var1, String var2, Class<?> var3);

    public abstract ValueExpression createValueExpression(Object var1, Class<?> var2);

    public abstract MethodExpression createMethodExpression(ELContext var1, String var2, Class<?> var3, Class<?>[] var4);

    public abstract Object coerceToType(Object var1, Class<?> var2);

    public ELResolver getStreamELResolver() {
        return null;
    }

    public Map<String, Method> getInitFunctionMap() {
        return null;
    }

    private static String discoverClassName(ClassLoader classLoader) {
        String string = null;
        string = ExpressionFactory.getClassNameServices(classLoader);
        if (string == null) {
            string = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return ExpressionFactory.getClassNameJreDir();
                }
            }) : ExpressionFactory.getClassNameJreDir();
        }
        if (string == null) {
            string = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return ExpressionFactory.getClassNameSysProp();
                }
            }) : ExpressionFactory.getClassNameSysProp();
        }
        if (string == null) {
            string = "org.apache.el.ExpressionFactoryImpl";
        }
        return string;
    }

    private static String getClassNameServices(ClassLoader classLoader) {
        Object object = null;
        ServiceLoader<ExpressionFactory> serviceLoader = ServiceLoader.load(ExpressionFactory.class, classLoader);
        Iterator<ExpressionFactory> iterator = serviceLoader.iterator();
        while (object == null && iterator.hasNext()) {
            object = iterator.next();
        }
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getClassNameJreDir() {
        File file = new File(PROPERTY_FILE);
        if (!file.canRead()) return null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string2 = properties.getProperty(PROPERTY_NAME);
            if (string2 == null) return null;
            if (string2.trim().length() <= 0) return null;
            String string = string2.trim();
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            throw new ELException(Util.message(null, "expressionFactory.readFailed", PROPERTY_FILE), iOException);
        }
    }

    private static final String getClassNameSysProp() {
        String string = System.getProperty(PROPERTY_NAME);
        if (string != null && string.trim().length() > 0) {
            return string.trim();
        }
        return null;
    }

    static {
        nullTcclFactory = new CacheValue();
        factoryCache = new ConcurrentHashMap<CacheKey, CacheValue>();
        PROPERTY_FILE = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.home") + File.separator + "lib" + File.separator + "el.properties";
            }
        }) : System.getProperty("java.home") + File.separator + "lib" + File.separator + "el.properties";
    }

    private static class CacheValue {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private String className;
        private WeakReference<Class<?>> ref;

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public String getFactoryClassName() {
            return this.className;
        }

        public void setFactoryClassName(String string) {
            this.className = string;
        }

        public Class<?> getFactoryClass() {
            return this.ref != null ? (Class)this.ref.get() : null;
        }

        public void setFactoryClass(Class<?> clazz) {
            this.ref = new WeakReference(clazz);
        }
    }

    private static class CacheKey {
        private final int hash;
        private final WeakReference<ClassLoader> ref;

        public CacheKey(ClassLoader classLoader) {
            this.hash = classLoader.hashCode();
            this.ref = new WeakReference<ClassLoader>(classLoader);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CacheKey)) {
                return false;
            }
            ClassLoader classLoader = (ClassLoader)this.ref.get();
            if (classLoader == null) {
                return false;
            }
            return classLoader == ((CacheKey)object).ref.get();
        }
    }
}

