var Universes={
  "Universe08": {
    "GlobalSchema": {
      "name": "GlobalSchema",
      "properties": {
        "key": {
          "name": "key",
          "range": "StringType",
          "domain": "GlobalSchema"
        },
        "value": {
          "name": "value",
          "range": "SchemaString",
          "domain": "GlobalSchema"
        }
      }
    },
    "Api": {
      "name": "Api",
      "properties": {
        "title": {
          "name": "title",
          "range": "StringType",
          "domain": "Api"
        },
        "version": {
          "name": "version",
          "range": "StringType",
          "domain": "Api"
        },
        "baseUri": {
          "name": "baseUri",
          "range": "FullUriTemplateString",
          "domain": "Api"
        },
        "baseUriParameters": {
          "name": "baseUriParameters",
          "range": "Parameter",
          "domain": "Api"
        },
        "uriParameters": {
          "name": "uriParameters",
          "range": "Parameter",
          "domain": "Api"
        },
        "protocols": {
          "name": "protocols",
          "range": "StringType",
          "domain": "Api"
        },
        "mediaType": {
          "name": "mediaType",
          "range": "MimeType",
          "domain": "Api"
        },
        "schemas": {
          "name": "schemas",
          "range": "GlobalSchema",
          "domain": "Api"
        },
        "traits": {
          "name": "traits",
          "range": "Trait",
          "domain": "Api"
        },
        "securedBy": {
          "name": "securedBy",
          "range": "SecuritySchemeRef",
          "domain": "Api"
        },
        "securitySchemes": {
          "name": "securitySchemes",
          "range": "AbstractSecurityScheme",
          "domain": "Api"
        },
        "resourceTypes": {
          "name": "resourceTypes",
          "range": "ResourceType",
          "domain": "Api"
        },
        "resources": {
          "name": "resources",
          "range": "Resource",
          "domain": "Api"
        },
        "documentation": {
          "name": "documentation",
          "range": "DocumentationItem",
          "domain": "Api"
        },
        "RAMLVersion": {
          "name": "RAMLVersion"
        }
      }
    },
    "DocumentationItem": {
      "name": "DocumentationItem",
      "properties": {
        "title": {
          "name": "title",
          "range": "StringType",
          "domain": "DocumentationItem"
        },
        "content": {
          "name": "content",
          "range": "MarkdownString",
          "domain": "DocumentationItem"
        }
      }
    },
    "ValueType": {
      "name": "ValueType",
      "properties": {}
    },
    "StringType": {
      "name": "StringType",
      "properties": {}
    },
    "AnyType": {
      "name": "AnyType",
      "properties": {}
    },
    "NumberType": {
      "name": "NumberType",
      "properties": {}
    },
    "BooleanType": {
      "name": "BooleanType",
      "properties": {}
    },
    "Referencable": {
      "name": "Referencable",
      "properties": {}
    },
    "Reference": {
      "name": "Reference",
      "properties": {
        "structuredValue": {
          "name": "structuredValue"
        },
        "name": {
          "name": "name"
        }
      }
    },
    "DeclaresDynamicType": {
      "name": "DeclaresDynamicType",
      "properties": {}
    },
    "UriTemplate": {
      "name": "UriTemplate",
      "properties": {}
    },
    "RelativeUriString": {
      "name": "RelativeUriString",
      "properties": {}
    },
    "FullUriTemplateString": {
      "name": "FullUriTemplateString",
      "properties": {}
    },
    "FixedUri": {
      "name": "FixedUri",
      "properties": {}
    },
    "MarkdownString": {
      "name": "MarkdownString",
      "properties": {}
    },
    "SchemaString": {
      "name": "SchemaString",
      "properties": {}
    },
    "JSonSchemaString": {
      "name": "JSonSchemaString",
      "properties": {}
    },
    "XMLSchemaString": {
      "name": "XMLSchemaString",
      "properties": {}
    },
    "ExampleString": {
      "name": "ExampleString",
      "properties": {}
    },
    "StatusCodeString": {
      "name": "StatusCodeString",
      "properties": {}
    },
    "JSONExample": {
      "name": "JSONExample",
      "properties": {}
    },
    "XMLExample": {
      "name": "XMLExample",
      "properties": {}
    },
    "TypeInstance": {
      "name": "TypeInstance",
      "properties": {
        "properties": {
          "name": "properties",
          "range": "TypeInstanceProperty",
          "domain": "TypeInstance"
        },
        "isScalar": {
          "name": "isScalar",
          "range": "BooleanType",
          "domain": "TypeInstance"
        },
        "value": {
          "name": "value",
          "range": "AnyType",
          "domain": "TypeInstance"
        }
      }
    },
    "TypeInstanceProperty": {
      "name": "TypeInstanceProperty",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "TypeInstanceProperty"
        },
        "value": {
          "name": "value",
          "range": "TypeInstance",
          "domain": "TypeInstanceProperty"
        },
        "values": {
          "name": "values",
          "range": "TypeInstance",
          "domain": "TypeInstanceProperty"
        },
        "isArray": {
          "name": "isArray",
          "range": "BooleanType",
          "domain": "TypeInstanceProperty"
        }
      }
    },
    "RAMLSimpleElement": {
      "name": "RAMLSimpleElement",
      "properties": {}
    },
    "Parameter": {
      "name": "Parameter",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Parameter"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Parameter"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "Parameter"
        },
        "location": {
          "name": "location",
          "range": "ParameterLocation",
          "domain": "Parameter"
        },
        "required": {
          "name": "required",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "default": {
          "name": "default",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "example": {
          "name": "example",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "repeat": {
          "name": "repeat",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Parameter"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties"
        }
      }
    },
    "StringTypeDeclaration": {
      "name": "StringTypeDeclaration",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Parameter"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Parameter"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "Parameter"
        },
        "location": {
          "name": "location",
          "range": "ParameterLocation",
          "domain": "Parameter"
        },
        "required": {
          "name": "required",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "default": {
          "name": "default",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "example": {
          "name": "example",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "repeat": {
          "name": "repeat",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Parameter"
        },
        "pattern": {
          "name": "pattern",
          "range": "StringType",
          "domain": "StringTypeDeclaration"
        },
        "enum": {
          "name": "enum",
          "range": "StringType",
          "domain": "StringTypeDeclaration"
        },
        "minLength": {
          "name": "minLength",
          "range": "NumberType",
          "domain": "StringTypeDeclaration"
        },
        "maxLength": {
          "name": "maxLength",
          "range": "NumberType",
          "domain": "StringTypeDeclaration"
        }
      }
    },
    "BooleanTypeDeclaration": {
      "name": "BooleanTypeDeclaration",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Parameter"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Parameter"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "Parameter"
        },
        "location": {
          "name": "location",
          "range": "ParameterLocation",
          "domain": "Parameter"
        },
        "required": {
          "name": "required",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "default": {
          "name": "default",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "example": {
          "name": "example",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "repeat": {
          "name": "repeat",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Parameter"
        }
      }
    },
    "NumberTypeDeclaration": {
      "name": "NumberTypeDeclaration",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Parameter"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Parameter"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "Parameter"
        },
        "location": {
          "name": "location",
          "range": "ParameterLocation",
          "domain": "Parameter"
        },
        "required": {
          "name": "required",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "default": {
          "name": "default",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "example": {
          "name": "example",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "repeat": {
          "name": "repeat",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Parameter"
        },
        "minimum": {
          "name": "minimum",
          "range": "NumberType",
          "domain": "NumberTypeDeclaration"
        },
        "maximum": {
          "name": "maximum",
          "range": "NumberType",
          "domain": "NumberTypeDeclaration"
        }
      }
    },
    "IntegerTypeDeclaration": {
      "name": "IntegerTypeDeclaration",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Parameter"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Parameter"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "Parameter"
        },
        "location": {
          "name": "location",
          "range": "ParameterLocation",
          "domain": "Parameter"
        },
        "required": {
          "name": "required",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "default": {
          "name": "default",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "example": {
          "name": "example",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "repeat": {
          "name": "repeat",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Parameter"
        },
        "minimum": {
          "name": "minimum",
          "range": "NumberType",
          "domain": "NumberTypeDeclaration"
        },
        "maximum": {
          "name": "maximum",
          "range": "NumberType",
          "domain": "NumberTypeDeclaration"
        }
      }
    },
    "DateTypeDeclaration": {
      "name": "DateTypeDeclaration",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Parameter"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Parameter"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "Parameter"
        },
        "location": {
          "name": "location",
          "range": "ParameterLocation",
          "domain": "Parameter"
        },
        "required": {
          "name": "required",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "default": {
          "name": "default",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "example": {
          "name": "example",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "repeat": {
          "name": "repeat",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Parameter"
        }
      }
    },
    "FileTypeDeclaration": {
      "name": "FileTypeDeclaration",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Parameter"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Parameter"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "Parameter"
        },
        "location": {
          "name": "location",
          "range": "ParameterLocation",
          "domain": "Parameter"
        },
        "required": {
          "name": "required",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "default": {
          "name": "default",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "example": {
          "name": "example",
          "range": "AnyType",
          "domain": "Parameter"
        },
        "repeat": {
          "name": "repeat",
          "range": "BooleanType",
          "domain": "Parameter"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Parameter"
        }
      }
    },
    "ParameterLocation": {
      "name": "ParameterLocation",
      "properties": {}
    },
    "MimeType": {
      "name": "MimeType",
      "properties": {}
    },
    "BodyLike": {
      "name": "BodyLike",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "BodyLike"
        },
        "schema": {
          "name": "schema",
          "range": "SchemaString",
          "domain": "BodyLike"
        },
        "example": {
          "name": "example",
          "range": "ExampleString",
          "domain": "BodyLike"
        },
        "formParameters": {
          "name": "formParameters",
          "range": "Parameter",
          "domain": "BodyLike"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "BodyLike"
        },
        "schemaContent": {
          "name": "schemaContent"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties"
        }
      }
    },
    "XMLBody": {
      "name": "XMLBody",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "BodyLike"
        },
        "schema": {
          "name": "schema",
          "range": "XMLSchemaString",
          "domain": "XMLBody"
        },
        "example": {
          "name": "example",
          "range": "ExampleString",
          "domain": "BodyLike"
        },
        "formParameters": {
          "name": "formParameters",
          "range": "Parameter",
          "domain": "BodyLike"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "BodyLike"
        }
      }
    },
    "JSONBody": {
      "name": "JSONBody",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "BodyLike"
        },
        "schema": {
          "name": "schema",
          "range": "JSonSchemaString",
          "domain": "JSONBody"
        },
        "example": {
          "name": "example",
          "range": "ExampleString",
          "domain": "BodyLike"
        },
        "formParameters": {
          "name": "formParameters",
          "range": "Parameter",
          "domain": "BodyLike"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "BodyLike"
        }
      }
    },
    "Response": {
      "name": "Response",
      "properties": {
        "code": {
          "name": "code",
          "range": "StatusCodeString",
          "domain": "Response"
        },
        "headers": {
          "name": "headers",
          "range": "Parameter",
          "domain": "Response"
        },
        "body": {
          "name": "body",
          "range": "BodyLike",
          "domain": "Response"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Response"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties"
        }
      }
    },
    "Resource": {
      "name": "Resource",
      "properties": {
        "relativeUri": {
          "name": "relativeUri",
          "range": "RelativeUriString",
          "domain": "Resource"
        },
        "type": {
          "name": "type",
          "range": "ResourceTypeRef",
          "domain": "Resource"
        },
        "is": {
          "name": "is",
          "range": "TraitRef",
          "domain": "Resource"
        },
        "securedBy": {
          "name": "securedBy",
          "range": "SecuritySchemeRef",
          "domain": "Resource"
        },
        "uriParameters": {
          "name": "uriParameters",
          "range": "Parameter",
          "domain": "Resource"
        },
        "methods": {
          "name": "methods",
          "range": "Method",
          "domain": "Resource"
        },
        "resources": {
          "name": "resources",
          "range": "Resource",
          "domain": "Resource"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Resource"
        },
        "baseUriParameters": {
          "name": "baseUriParameters",
          "range": "Parameter",
          "domain": "Resource"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "Resource"
        }
      }
    },
    "ResourceTypeRef": {
      "name": "ResourceTypeRef",
      "properties": {
        "resourceType": {
          "name": "resourceType"
        }
      }
    },
    "ResourceType": {
      "name": "ResourceType",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "ResourceType"
        },
        "usage": {
          "name": "usage",
          "range": "StringType",
          "domain": "ResourceType"
        },
        "methods": {
          "name": "methods",
          "range": "Method",
          "domain": "ResourceType"
        },
        "is": {
          "name": "is",
          "range": "TraitRef",
          "domain": "ResourceType"
        },
        "type": {
          "name": "type",
          "range": "ResourceTypeRef",
          "domain": "ResourceType"
        },
        "securedBy": {
          "name": "securedBy",
          "range": "SecuritySchemeRef",
          "domain": "ResourceType"
        },
        "uriParameters": {
          "name": "uriParameters",
          "range": "Parameter",
          "domain": "ResourceType"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "ResourceType"
        },
        "baseUriParameters": {
          "name": "baseUriParameters",
          "range": "Parameter",
          "domain": "ResourceType"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "ResourceType"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties"
        }
      }
    },
    "MethodBase": {
      "name": "MethodBase",
      "properties": {
        "responses": {
          "name": "responses",
          "range": "Response",
          "domain": "MethodBase"
        },
        "body": {
          "name": "body",
          "range": "BodyLike",
          "domain": "MethodBase"
        },
        "protocols": {
          "name": "protocols",
          "range": "StringType",
          "domain": "MethodBase"
        },
        "securedBy": {
          "name": "securedBy",
          "range": "SecuritySchemeRef",
          "domain": "MethodBase"
        },
        "baseUriParameters": {
          "name": "baseUriParameters",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "queryParameters": {
          "name": "queryParameters",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "headers": {
          "name": "headers",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "MethodBase"
        }
      }
    },
    "Method": {
      "name": "Method",
      "properties": {
        "responses": {
          "name": "responses",
          "range": "Response",
          "domain": "MethodBase"
        },
        "body": {
          "name": "body",
          "range": "BodyLike",
          "domain": "MethodBase"
        },
        "protocols": {
          "name": "protocols",
          "range": "StringType",
          "domain": "MethodBase"
        },
        "securedBy": {
          "name": "securedBy",
          "range": "SecuritySchemeRef",
          "domain": "MethodBase"
        },
        "baseUriParameters": {
          "name": "baseUriParameters",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "queryParameters": {
          "name": "queryParameters",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "headers": {
          "name": "headers",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "MethodBase"
        },
        "method": {
          "name": "method",
          "range": "StringType",
          "domain": "Method"
        },
        "is": {
          "name": "is",
          "range": "TraitRef",
          "domain": "Method"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties"
        }
      }
    },
    "Trait": {
      "name": "Trait",
      "properties": {
        "responses": {
          "name": "responses",
          "range": "Response",
          "domain": "MethodBase"
        },
        "body": {
          "name": "body",
          "range": "BodyLike",
          "domain": "MethodBase"
        },
        "protocols": {
          "name": "protocols",
          "range": "StringType",
          "domain": "MethodBase"
        },
        "securedBy": {
          "name": "securedBy",
          "range": "SecuritySchemeRef",
          "domain": "MethodBase"
        },
        "baseUriParameters": {
          "name": "baseUriParameters",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "queryParameters": {
          "name": "queryParameters",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "headers": {
          "name": "headers",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "MethodBase"
        },
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Trait"
        },
        "usage": {
          "name": "usage",
          "range": "StringType",
          "domain": "Trait"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "Trait"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties"
        }
      }
    },
    "TraitRef": {
      "name": "TraitRef",
      "properties": {
        "trait": {
          "name": "trait"
        }
      }
    },
    "SecuritySchemePart": {
      "name": "SecuritySchemePart",
      "properties": {
        "responses": {
          "name": "responses",
          "range": "Response",
          "domain": "SecuritySchemePart"
        },
        "body": {
          "name": "body",
          "range": "BodyLike",
          "domain": "MethodBase"
        },
        "protocols": {
          "name": "protocols",
          "range": "StringType",
          "domain": "MethodBase"
        },
        "securedBy": {
          "name": "securedBy",
          "range": "SecuritySchemeRef",
          "domain": "MethodBase"
        },
        "baseUriParameters": {
          "name": "baseUriParameters",
          "range": "Parameter",
          "domain": "MethodBase"
        },
        "queryParameters": {
          "name": "queryParameters",
          "range": "Parameter",
          "domain": "SecuritySchemePart"
        },
        "headers": {
          "name": "headers",
          "range": "Parameter",
          "domain": "SecuritySchemePart"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "SecuritySchemePart"
        },
        "displayName": {
          "name": "displayName",
          "range": "StringType",
          "domain": "SecuritySchemePart"
        },
        "is": {
          "name": "is",
          "range": "TraitRef",
          "domain": "SecuritySchemePart"
        }
      }
    },
    "SecuritySchemeSettings": {
      "name": "SecuritySchemeSettings",
      "properties": {}
    },
    "AbstractSecurityScheme": {
      "name": "AbstractSecurityScheme",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "AbstractSecurityScheme"
        },
        "describedBy": {
          "name": "describedBy",
          "range": "SecuritySchemePart",
          "domain": "AbstractSecurityScheme"
        },
        "settings": {
          "name": "settings",
          "range": "SecuritySchemeSettings",
          "domain": "AbstractSecurityScheme"
        }
      }
    },
    "SecuritySchemeRef": {
      "name": "SecuritySchemeRef",
      "properties": {
        "securitySchemeName": {
          "name": "securitySchemeName"
        },
        "securityScheme": {
          "name": "securityScheme"
        }
      }
    },
    "OAuth1SecuritySchemeSettings": {
      "name": "OAuth1SecuritySchemeSettings",
      "properties": {
        "requestTokenUri": {
          "name": "requestTokenUri",
          "range": "FixedUri",
          "domain": "OAuth1SecuritySchemeSettings"
        },
        "authorizationUri": {
          "name": "authorizationUri",
          "range": "FixedUri",
          "domain": "OAuth1SecuritySchemeSettings"
        },
        "tokenCredentialsUri": {
          "name": "tokenCredentialsUri",
          "range": "FixedUri",
          "domain": "OAuth1SecuritySchemeSettings"
        }
      }
    },
    "OAuth2SecuritySchemeSettings": {
      "name": "OAuth2SecuritySchemeSettings",
      "properties": {
        "accessTokenUri": {
          "name": "accessTokenUri",
          "range": "FixedUri",
          "domain": "OAuth2SecuritySchemeSettings"
        },
        "authorizationUri": {
          "name": "authorizationUri",
          "range": "FixedUri",
          "domain": "OAuth2SecuritySchemeSettings"
        },
        "authorizationGrants": {
          "name": "authorizationGrants",
          "range": "StringType",
          "domain": "OAuth2SecuritySchemeSettings"
        },
        "scopes": {
          "name": "scopes",
          "range": "StringType",
          "domain": "OAuth2SecuritySchemeSettings"
        }
      }
    },
    "OAuth2SecurityScheme": {
      "name": "OAuth2SecurityScheme",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "AbstractSecurityScheme"
        },
        "describedBy": {
          "name": "describedBy",
          "range": "SecuritySchemePart",
          "domain": "AbstractSecurityScheme"
        },
        "settings": {
          "name": "settings",
          "range": "OAuth2SecuritySchemeSettings",
          "domain": "OAuth2SecurityScheme"
        }
      }
    },
    "OAuth1SecurityScheme": {
      "name": "OAuth1SecurityScheme",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "AbstractSecurityScheme"
        },
        "describedBy": {
          "name": "describedBy",
          "range": "SecuritySchemePart",
          "domain": "AbstractSecurityScheme"
        },
        "settings": {
          "name": "settings",
          "range": "OAuth1SecuritySchemeSettings",
          "domain": "OAuth1SecurityScheme"
        }
      }
    },
    "BasicSecurityScheme": {
      "name": "BasicSecurityScheme",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "AbstractSecurityScheme"
        },
        "describedBy": {
          "name": "describedBy",
          "range": "SecuritySchemePart",
          "domain": "AbstractSecurityScheme"
        },
        "settings": {
          "name": "settings",
          "range": "SecuritySchemeSettings",
          "domain": "AbstractSecurityScheme"
        }
      }
    },
    "DigestSecurityScheme": {
      "name": "DigestSecurityScheme",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "AbstractSecurityScheme"
        },
        "describedBy": {
          "name": "describedBy",
          "range": "SecuritySchemePart",
          "domain": "AbstractSecurityScheme"
        },
        "settings": {
          "name": "settings",
          "range": "SecuritySchemeSettings",
          "domain": "AbstractSecurityScheme"
        }
      }
    },
    "CustomSecurityScheme": {
      "name": "CustomSecurityScheme",
      "properties": {
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "type": {
          "name": "type",
          "range": "StringType",
          "domain": "AbstractSecurityScheme"
        },
        "description": {
          "name": "description",
          "range": "MarkdownString",
          "domain": "AbstractSecurityScheme"
        },
        "describedBy": {
          "name": "describedBy",
          "range": "SecuritySchemePart",
          "domain": "AbstractSecurityScheme"
        },
        "settings": {
          "name": "settings",
          "range": "SecuritySchemeSettings",
          "domain": "AbstractSecurityScheme"
        }
      }
    }
  },
  "Universe10": {
    "Library": {
      "name": "Library",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "uses": {
          "name": "uses"
        },
        "schemas": {
          "name": "schemas"
        },
        "types": {
          "name": "types"
        },
        "traits": {
          "name": "traits"
        },
        "resourceTypes": {
          "name": "resourceTypes"
        },
        "annotationTypes": {
          "name": "annotationTypes"
        },
        "securitySchemes": {
          "name": "securitySchemes"
        },
        "usage": {
          "name": "usage"
        },
        "name": {
          "name": "name"
        }
      }
    },
    "LibraryBase": {
      "name": "LibraryBase",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "uses": {
          "name": "uses"
        },
        "schemas": {
          "name": "schemas"
        },
        "types": {
          "name": "types"
        },
        "traits": {
          "name": "traits"
        },
        "resourceTypes": {
          "name": "resourceTypes"
        },
        "annotationTypes": {
          "name": "annotationTypes"
        },
        "securitySchemes": {
          "name": "securitySchemes"
        }
      }
    },
    "Api": {
      "name": "Api",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "uses": {
          "name": "uses"
        },
        "schemas": {
          "name": "schemas"
        },
        "types": {
          "name": "types"
        },
        "traits": {
          "name": "traits"
        },
        "resourceTypes": {
          "name": "resourceTypes"
        },
        "annotationTypes": {
          "name": "annotationTypes"
        },
        "securitySchemes": {
          "name": "securitySchemes"
        },
        "title": {
          "name": "title"
        },
        "description": {
          "name": "description"
        },
        "version": {
          "name": "version"
        },
        "baseUri": {
          "name": "baseUri"
        },
        "baseUriParameters": {
          "name": "baseUriParameters"
        },
        "protocols": {
          "name": "protocols"
        },
        "mediaType": {
          "name": "mediaType"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "resources": {
          "name": "resources"
        },
        "documentation": {
          "name": "documentation"
        },
        "RAMLVersion": {
          "name": "RAMLVersion",
          "range": "StringType",
          "domain": "Api"
        }
      }
    },
    "Overlay": {
      "name": "Overlay",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "uses": {
          "name": "uses"
        },
        "schemas": {
          "name": "schemas"
        },
        "types": {
          "name": "types"
        },
        "traits": {
          "name": "traits"
        },
        "resourceTypes": {
          "name": "resourceTypes"
        },
        "annotationTypes": {
          "name": "annotationTypes"
        },
        "securitySchemes": {
          "name": "securitySchemes"
        },
        "title": {
          "name": "title"
        },
        "description": {
          "name": "description"
        },
        "version": {
          "name": "version"
        },
        "baseUri": {
          "name": "baseUri"
        },
        "baseUriParameters": {
          "name": "baseUriParameters"
        },
        "protocols": {
          "name": "protocols"
        },
        "mediaType": {
          "name": "mediaType"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "resources": {
          "name": "resources"
        },
        "documentation": {
          "name": "documentation"
        },
        "usage": {
          "name": "usage"
        },
        "extends": {
          "name": "extends"
        }
      }
    },
    "Extension": {
      "name": "Extension",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "uses": {
          "name": "uses"
        },
        "schemas": {
          "name": "schemas"
        },
        "types": {
          "name": "types"
        },
        "traits": {
          "name": "traits"
        },
        "resourceTypes": {
          "name": "resourceTypes"
        },
        "annotationTypes": {
          "name": "annotationTypes"
        },
        "securitySchemes": {
          "name": "securitySchemes"
        },
        "title": {
          "name": "title"
        },
        "description": {
          "name": "description"
        },
        "version": {
          "name": "version"
        },
        "baseUri": {
          "name": "baseUri"
        },
        "baseUriParameters": {
          "name": "baseUriParameters"
        },
        "protocols": {
          "name": "protocols"
        },
        "mediaType": {
          "name": "mediaType"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "resources": {
          "name": "resources"
        },
        "documentation": {
          "name": "documentation"
        },
        "usage": {
          "name": "usage"
        },
        "extends": {
          "name": "extends"
        }
      }
    },
    "UsesDeclaration": {
      "name": "UsesDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "key": {
          "name": "key"
        },
        "value": {
          "name": "value"
        }
      }
    },
    "FragmentDeclaration": {
      "name": "FragmentDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "uses": {
          "name": "uses"
        }
      }
    },
    "DocumentationItem": {
      "name": "DocumentationItem",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "title": {
          "name": "title"
        },
        "content": {
          "name": "content"
        }
      }
    },
    "ValueType": {
      "name": "ValueType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "StringType": {
      "name": "StringType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "AnyType": {
      "name": "AnyType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "NumberType": {
      "name": "NumberType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "IntegerType": {
      "name": "IntegerType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "NullType": {
      "name": "NullType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "TimeOnlyType": {
      "name": "TimeOnlyType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "DateOnlyType": {
      "name": "DateOnlyType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "DateTimeOnlyType": {
      "name": "DateTimeOnlyType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "DateTimeType": {
      "name": "DateTimeType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "FileType": {
      "name": "FileType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "BooleanType": {
      "name": "BooleanType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "Reference": {
      "name": "Reference",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "structuredValue": {
          "name": "structuredValue",
          "range": "TypeInstance",
          "domain": "Reference"
        },
        "name": {
          "name": "name",
          "range": "StringType",
          "domain": "Reference"
        }
      }
    },
    "UriTemplate": {
      "name": "UriTemplate",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "StatusCodeString": {
      "name": "StatusCodeString",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "RelativeUriString": {
      "name": "RelativeUriString",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "FullUriTemplateString": {
      "name": "FullUriTemplateString",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "FixedUriString": {
      "name": "FixedUriString",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "ContentType": {
      "name": "ContentType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "MarkdownString": {
      "name": "MarkdownString",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "SchemaString": {
      "name": "SchemaString",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "ExampleSpec": {
      "name": "ExampleSpec",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "value": {
          "name": "value"
        },
        "strict": {
          "name": "strict"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "description": {
          "name": "description"
        },
        "structuredValue": {
          "name": "structuredValue",
          "range": "TypeInstance",
          "domain": "ExampleSpec"
        }
      }
    },
    "TypeDeclaration": {
      "name": "TypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "fixedFacets": {
          "name": "fixedFacets",
          "range": "TypeInstance",
          "domain": "TypeDeclaration"
        },
        "structuredType": {
          "name": "structuredType",
          "range": "TypeInstance",
          "domain": "TypeDeclaration"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties",
          "range": "TypeInstance",
          "domain": "TypeDeclaration"
        }
      }
    },
    "XMLFacetInfo": {
      "name": "XMLFacetInfo",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "attribute": {
          "name": "attribute"
        },
        "wrapped": {
          "name": "wrapped"
        },
        "name": {
          "name": "name"
        },
        "namespace": {
          "name": "namespace"
        },
        "prefix": {
          "name": "prefix"
        }
      }
    },
    "ArrayTypeDeclaration": {
      "name": "ArrayTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "uniqueItems": {
          "name": "uniqueItems"
        },
        "items": {
          "name": "items"
        },
        "minItems": {
          "name": "minItems"
        },
        "maxItems": {
          "name": "maxItems"
        },
        "structuredItems": {
          "name": "structuredItems",
          "range": "TypeInstance",
          "domain": "ArrayTypeDeclaration"
        }
      }
    },
    "UnionTypeDeclaration": {
      "name": "UnionTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        }
      }
    },
    "ObjectTypeDeclaration": {
      "name": "ObjectTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "properties": {
          "name": "properties"
        },
        "minProperties": {
          "name": "minProperties"
        },
        "maxProperties": {
          "name": "maxProperties"
        },
        "additionalProperties": {
          "name": "additionalProperties"
        },
        "discriminator": {
          "name": "discriminator"
        },
        "discriminatorValue": {
          "name": "discriminatorValue"
        },
        "enum": {
          "name": "enum"
        }
      }
    },
    "StringTypeDeclaration": {
      "name": "StringTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "pattern": {
          "name": "pattern"
        },
        "minLength": {
          "name": "minLength"
        },
        "maxLength": {
          "name": "maxLength"
        },
        "enum": {
          "name": "enum"
        }
      }
    },
    "BooleanTypeDeclaration": {
      "name": "BooleanTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "enum": {
          "name": "enum"
        }
      }
    },
    "NumberTypeDeclaration": {
      "name": "NumberTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "minimum": {
          "name": "minimum"
        },
        "maximum": {
          "name": "maximum"
        },
        "enum": {
          "name": "enum"
        },
        "format": {
          "name": "format"
        },
        "multipleOf": {
          "name": "multipleOf"
        }
      }
    },
    "IntegerTypeDeclaration": {
      "name": "IntegerTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "minimum": {
          "name": "minimum"
        },
        "maximum": {
          "name": "maximum"
        },
        "enum": {
          "name": "enum"
        },
        "format": {
          "name": "format"
        },
        "multipleOf": {
          "name": "multipleOf"
        }
      }
    },
    "DateOnlyTypeDeclaration": {
      "name": "DateOnlyTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        }
      }
    },
    "TimeOnlyTypeDeclaration": {
      "name": "TimeOnlyTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        }
      }
    },
    "DateTimeOnlyTypeDeclaration": {
      "name": "DateTimeOnlyTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        }
      }
    },
    "DateTimeTypeDeclaration": {
      "name": "DateTimeTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "format": {
          "name": "format"
        }
      }
    },
    "TypeInstance": {
      "name": "TypeInstance",
      "properties": {
        "properties": {
          "name": "properties"
        },
        "isScalar": {
          "name": "isScalar"
        },
        "value": {
          "name": "value"
        },
        "isArray": {
          "name": "isArray"
        },
        "items": {
          "name": "items"
        }
      }
    },
    "TypeInstanceProperty": {
      "name": "TypeInstanceProperty",
      "properties": {
        "name": {
          "name": "name"
        },
        "value": {
          "name": "value"
        },
        "values": {
          "name": "values"
        },
        "isArray": {
          "name": "isArray"
        }
      }
    },
    "ModelLocation": {
      "name": "ModelLocation",
      "properties": {}
    },
    "LocationKind": {
      "name": "LocationKind",
      "properties": {}
    },
    "MimeType": {
      "name": "MimeType",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "Response": {
      "name": "Response",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "code": {
          "name": "code"
        },
        "headers": {
          "name": "headers"
        },
        "body": {
          "name": "body"
        },
        "description": {
          "name": "description"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties",
          "range": "TypeInstance",
          "domain": "Response"
        }
      }
    },
    "Annotable": {
      "name": "Annotable",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "AnnotationRef": {
      "name": "AnnotationRef",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "annotation": {
          "name": "annotation",
          "range": "TypeDeclaration",
          "domain": "AnnotationRef"
        }
      }
    },
    "AnnotationTarget": {
      "name": "AnnotationTarget",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "TraitRef": {
      "name": "TraitRef",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "trait": {
          "name": "trait",
          "range": "Trait",
          "domain": "TraitRef"
        }
      }
    },
    "Trait": {
      "name": "Trait",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "queryParameters": {
          "name": "queryParameters"
        },
        "headers": {
          "name": "headers"
        },
        "queryString": {
          "name": "queryString"
        },
        "responses": {
          "name": "responses"
        },
        "body": {
          "name": "body"
        },
        "protocols": {
          "name": "protocols"
        },
        "is": {
          "name": "is"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "description": {
          "name": "description"
        },
        "displayName": {
          "name": "displayName"
        },
        "name": {
          "name": "name"
        },
        "usage": {
          "name": "usage"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties",
          "range": "TypeInstance",
          "domain": "Trait"
        }
      }
    },
    "MethodBase": {
      "name": "MethodBase",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "queryParameters": {
          "name": "queryParameters"
        },
        "headers": {
          "name": "headers"
        },
        "queryString": {
          "name": "queryString"
        },
        "responses": {
          "name": "responses"
        },
        "body": {
          "name": "body"
        },
        "protocols": {
          "name": "protocols"
        },
        "is": {
          "name": "is"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "description": {
          "name": "description"
        },
        "displayName": {
          "name": "displayName"
        }
      }
    },
    "Method": {
      "name": "Method",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "queryParameters": {
          "name": "queryParameters"
        },
        "headers": {
          "name": "headers"
        },
        "queryString": {
          "name": "queryString"
        },
        "responses": {
          "name": "responses"
        },
        "body": {
          "name": "body"
        },
        "protocols": {
          "name": "protocols"
        },
        "is": {
          "name": "is"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "description": {
          "name": "description"
        },
        "displayName": {
          "name": "displayName"
        },
        "method": {
          "name": "method"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties",
          "range": "TypeInstance",
          "domain": "Method"
        }
      }
    },
    "Operation": {
      "name": "Operation",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "queryParameters": {
          "name": "queryParameters"
        },
        "headers": {
          "name": "headers"
        },
        "queryString": {
          "name": "queryString"
        },
        "responses": {
          "name": "responses"
        }
      }
    },
    "SecuritySchemePart": {
      "name": "SecuritySchemePart",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "queryParameters": {
          "name": "queryParameters"
        },
        "headers": {
          "name": "headers"
        },
        "queryString": {
          "name": "queryString"
        },
        "responses": {
          "name": "responses"
        }
      }
    },
    "SecuritySchemeSettings": {
      "name": "SecuritySchemeSettings",
      "properties": {
        "annotations": {
          "name": "annotations"
        }
      }
    },
    "OAuth1SecuritySchemeSettings": {
      "name": "OAuth1SecuritySchemeSettings",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "requestTokenUri": {
          "name": "requestTokenUri"
        },
        "authorizationUri": {
          "name": "authorizationUri"
        },
        "tokenCredentialsUri": {
          "name": "tokenCredentialsUri"
        },
        "signatures": {
          "name": "signatures"
        }
      }
    },
    "OAuth2SecuritySchemeSettings": {
      "name": "OAuth2SecuritySchemeSettings",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "accessTokenUri": {
          "name": "accessTokenUri"
        },
        "authorizationUri": {
          "name": "authorizationUri"
        },
        "authorizationGrants": {
          "name": "authorizationGrants"
        },
        "scopes": {
          "name": "scopes"
        }
      }
    },
    "SecuritySchemeRef": {
      "name": "SecuritySchemeRef",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "securitySchemeName": {
          "name": "securitySchemeName",
          "range": "StringType",
          "domain": "SecuritySchemeRef"
        },
        "securityScheme": {
          "name": "securityScheme",
          "range": "AbstractSecurityScheme",
          "domain": "SecuritySchemeRef"
        }
      }
    },
    "AbstractSecurityScheme": {
      "name": "AbstractSecurityScheme",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "describedBy": {
          "name": "describedBy"
        },
        "displayName": {
          "name": "displayName"
        },
        "settings": {
          "name": "settings"
        }
      }
    },
    "OAuth2SecurityScheme": {
      "name": "OAuth2SecurityScheme",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "describedBy": {
          "name": "describedBy"
        },
        "displayName": {
          "name": "displayName"
        },
        "settings": {
          "name": "settings"
        }
      }
    },
    "OAuth1SecurityScheme": {
      "name": "OAuth1SecurityScheme",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "describedBy": {
          "name": "describedBy"
        },
        "displayName": {
          "name": "displayName"
        },
        "settings": {
          "name": "settings"
        }
      }
    },
    "PassThroughSecurityScheme": {
      "name": "PassThroughSecurityScheme",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "describedBy": {
          "name": "describedBy"
        },
        "displayName": {
          "name": "displayName"
        },
        "settings": {
          "name": "settings"
        }
      }
    },
    "BasicSecurityScheme": {
      "name": "BasicSecurityScheme",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "describedBy": {
          "name": "describedBy"
        },
        "displayName": {
          "name": "displayName"
        },
        "settings": {
          "name": "settings"
        }
      }
    },
    "DigestSecurityScheme": {
      "name": "DigestSecurityScheme",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "describedBy": {
          "name": "describedBy"
        },
        "displayName": {
          "name": "displayName"
        },
        "settings": {
          "name": "settings"
        }
      }
    },
    "CustomSecurityScheme": {
      "name": "CustomSecurityScheme",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "describedBy": {
          "name": "describedBy"
        },
        "displayName": {
          "name": "displayName"
        },
        "settings": {
          "name": "settings"
        }
      }
    },
    "ResourceTypeRef": {
      "name": "ResourceTypeRef",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "resourceType": {
          "name": "resourceType",
          "range": "ResourceType",
          "domain": "ResourceTypeRef"
        }
      }
    },
    "ResourceType": {
      "name": "ResourceType",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "methods": {
          "name": "methods"
        },
        "is": {
          "name": "is"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "uriParameters": {
          "name": "uriParameters"
        },
        "displayName": {
          "name": "displayName"
        },
        "name": {
          "name": "name"
        },
        "usage": {
          "name": "usage"
        },
        "parametrizedProperties": {
          "name": "parametrizedProperties",
          "range": "TypeInstance",
          "domain": "ResourceType"
        }
      }
    },
    "ResourceBase": {
      "name": "ResourceBase",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "methods": {
          "name": "methods"
        },
        "is": {
          "name": "is"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "uriParameters": {
          "name": "uriParameters"
        }
      }
    },
    "Resource": {
      "name": "Resource",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "methods": {
          "name": "methods"
        },
        "is": {
          "name": "is"
        },
        "type": {
          "name": "type"
        },
        "description": {
          "name": "description"
        },
        "securedBy": {
          "name": "securedBy"
        },
        "uriParameters": {
          "name": "uriParameters"
        },
        "relativeUri": {
          "name": "relativeUri"
        },
        "displayName": {
          "name": "displayName"
        },
        "resources": {
          "name": "resources"
        }
      }
    },
    "FileTypeDeclaration": {
      "name": "FileTypeDeclaration",
      "properties": {
        "annotations": {
          "name": "annotations"
        },
        "name": {
          "name": "name"
        },
        "displayName": {
          "name": "displayName"
        },
        "facets": {
          "name": "facets"
        },
        "schema": {
          "name": "schema"
        },
        "type": {
          "name": "type"
        },
        "location": {
          "name": "location"
        },
        "locationKind": {
          "name": "locationKind"
        },
        "default": {
          "name": "default"
        },
        "example": {
          "name": "example"
        },
        "examples": {
          "name": "examples"
        },
        "required": {
          "name": "required"
        },
        "description": {
          "name": "description"
        },
        "xml": {
          "name": "xml"
        },
        "allowedTargets": {
          "name": "allowedTargets"
        },
        "isAnnotation": {
          "name": "isAnnotation"
        },
        "fileTypes": {
          "name": "fileTypes"
        },
        "minLength": {
          "name": "minLength"
        },
        "maxLength": {
          "name": "maxLength"
        }
      }
    }
  }
};export=Universes