"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var validator = require('xmllint-jsparser');
var XMLValidator = /** @class */ (function () {
    function XMLValidator(schema) {
        this.schema = schema;
    }
    XMLValidator.prototype.validate = function (xml, references) {
        if (references === void 0) { references = []; }
        if (references.length === 0) {
            var result = validator.validateXML({ xml: xml, schema: this.schema });
            return (result && result.errors && result.errors.map(function (error) { return new Error(error); })) || [];
        }
        var schemas = this.remoteSchemas(references);
        schemas.push(this.schema);
        var result = validator.validateXML({ xml: xml, schema: schemas });
        return (result && result.errors && result.errors.map(function (error) {
            return new Error(error);
        })) || [];
    };
    XMLValidator.prototype.remoteSchemas = function (refs) {
        return refs.map(function (ref) { return ref.patchedContent; });
    };
    return XMLValidator;
}());
exports.XMLValidator = XMLValidator;
var XMLSchemaReference = /** @class */ (function () {
    function XMLSchemaReference(originalPath, virtualIndex, patchedContent) {
        this.originalPath = originalPath;
        this.virtualIndex = virtualIndex;
        this.patchedContent = patchedContent;
    }
    return XMLSchemaReference;
}());
exports.XMLSchemaReference = XMLSchemaReference;
//# sourceMappingURL=index.js.map