<?php

namespace Drupal\Tests\aggregator\Kernel\Migrate\d7;

use Drupal\Tests\migrate_drupal\Kernel\d7\MigrateDrupal7TestBase;

/**
 * Tests migration of Aggregator's variables to configuration.
 *
 * @group aggregator
 */
class MigrateAggregatorSettingsTest extends MigrateDrupal7TestBase {

  protected static $modules = ['aggregator'];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installConfig(static::$modules);
    $this->executeMigration('d7_aggregator_settings');
  }

  /**
   * Tests migration of Aggregator variables to configuration.
   */
  public function testMigration() {
    $config = \Drupal::config('aggregator.settings')->get();
    $this->assertIdentical('aggregator', $config['fetcher']);
    $this->assertIdentical('aggregator', $config['parser']);
    $this->assertIdentical(['aggregator'], $config['processors']);
    $this->assertIdentical('<p> <div> <a>', $config['items']['allowed_html']);
    $this->assertIdentical(500, $config['items']['teaser_length']);
    $this->assertIdentical(86400, $config['items']['expire']);
    $this->assertIdentical(6, $config['source']['list_max']);
  }

}
