/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.util.ArrayList;
import java.util.List;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class Util {
    private static final I18n i18n = I18nFactory.getI18n(Util.class);

    private Util() {
    }

    public static double calculateRatio(double start, double target, double end) {
        return (target - start) / (end - start);
    }

    public static double applyRatio(double start, double end, double ratio) {
        return start + ratio * (end - start);
    }

    public static double greatCircleDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        double lat1 = Math.toRadians(latitude1);
        double lon1 = Math.toRadians(longitude1);
        double lat2 = Math.toRadians(latitude2);
        double lon2 = Math.toRadians(longitude2);
        double deltaLon = lon2 - lon1;
        double term1 = Util.square(Math.cos(lat2) * Math.sin(deltaLon));
        double term2 = Util.square(Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon));
        double dividend = Math.sqrt(term1 + term2);
        double divisor = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        double distance = 6372795.0 * Math.atan2(dividend, divisor);
        return distance;
    }

    public static double square(double x) {
        return x * x;
    }

    public static long powerOf10(int number) {
        long result = 1L;
        int ten = 10;
        int i = 1;
        while (i <= number) {
            result *= 10L;
            ++i;
        }
        return result;
    }

    public static List<String> splitString(String stringToSplit, int maxLength) {
        String text = stringToSplit;
        ArrayList<String> lines = new ArrayList<String>();
        while (text.length() > maxLength) {
            int spaceAt = maxLength - 1;
            int i = maxLength - 1;
            while (i > 0) {
                if (Character.isWhitespace(text.charAt(i))) {
                    spaceAt = i;
                    break;
                }
                --i;
            }
            lines.add(text.substring(0, spaceAt));
            text = text.substring(spaceAt + 1);
        }
        lines.add(text);
        return lines;
    }

    public static List<String> splitHtmlString(String stringToSplit, int maxLength) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean processingHtmlTag = false;
        StringBuilder word = new StringBuilder();
        StringBuilder line = new StringBuilder();
        int index = 0;
        while (index < stringToSplit.length()) {
            char character = stringToSplit.charAt(index);
            if (processingHtmlTag) {
                word.append(character);
                switch (character) {
                    case '>': {
                        processingHtmlTag = false;
                    }
                }
            } else {
                switch (character) {
                    case '<': {
                        word.append(character);
                        processingHtmlTag = true;
                        break;
                    }
                    case ' ': {
                        if (line.length() + word.length() + 1 < maxLength) {
                            line.append(word.toString()).append(' ');
                            word = new StringBuilder();
                            break;
                        }
                        lines.add(line.toString());
                        line = new StringBuilder();
                        word.append(' ');
                        break;
                    }
                    default: {
                        word.append(character);
                    }
                }
            }
            ++index;
        }
        if (word.length() > 0) {
            line.append(word.toString());
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public static double degreesFromCardinalDirection(String direction) {
        String[] cardinalDirections = new String[]{i18n.tr("N"), i18n.tr("NNE"), i18n.tr("NE"), i18n.tr("ENE"), i18n.tr("E"), i18n.tr("ESE"), i18n.tr("SE"), i18n.tr("SSE"), i18n.tr("S"), i18n.tr("SSW"), i18n.tr("SW"), i18n.tr("WSW"), i18n.tr("W"), i18n.tr("WNW"), i18n.tr("NW"), i18n.tr("NNW")};
        int i = 0;
        while (i < cardinalDirections.length) {
            if (direction.equalsIgnoreCase(cardinalDirections[i])) {
                return 360.0 / (double)cardinalDirections.length * (double)i;
            }
            ++i;
        }
        return Double.NaN;
    }

    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (array == prefix) {
            return true;
        }
        if (array == null || prefix == null) {
            return false;
        }
        int prefixLength = prefix.length;
        if (prefix.length > array.length) {
            return false;
        }
        int i = 0;
        while (i < prefixLength) {
            if (array[i] != prefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean sameContent(String string1, String string2) {
        String notNull1 = string1 == null ? "" : string1;
        String notNull2 = string2 == null ? "" : string2;
        return notNull1.equals(notNull2);
    }
}

