/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class EditRelationAction
extends AbstractRelationAction {
    public EditRelationAction() {
        this.putValue("Name", I18n.tr("Edit", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Call relation editor for selected relation", new Object[0]));
        new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this, true);
    }

    public static Set<RelationMember> getMembersForCurrentSelection(Relation r) {
        OsmDataLayer editLayer;
        if (MainApplication.isDisplayingMapView() && (editLayer = MainApplication.getLayerManager().getEditLayer()) != null && editLayer.data != null) {
            Collection selection = editLayer.data.getSelected();
            return r.getMembers().stream().filter(m -> selection.contains(m.getMember())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static void launchEditor(Relation toEdit) {
        if (toEdit == null || toEdit.isDeleted() || !MainApplication.isDisplayingMapView()) {
            return;
        }
        RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), toEdit, EditRelationAction.getMembersForCurrentSelection(toEdit)).setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SubclassFilteredCollection filteredRelations = Utils.filteredCollection(this.relations, Relation.class);
        if (!this.isEnabled() || filteredRelations.isEmpty()) {
            return;
        }
        if (filteredRelations.size() > Config.getPref().getInt("warn.open.maxrelations", 5) && 0 != JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), "<html>" + I18n.trn("You are about to open <b>{0}</b> different relation editor simultaneously.<br/>Do you want to continue?", "You are about to open <b>{0}</b> different relation editors simultaneously.<br/>Do you want to continue?", filteredRelations.size(), filteredRelations.size()) + "</html>", I18n.tr("Confirmation", new Object[0]), 2, 2)) {
            return;
        }
        for (Relation r : filteredRelations) {
            EditRelationAction.launchEditor(r);
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.canModify());
    }
}

