/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.parser.m2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.License;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.plugins.parser.m2.MavenVersionRangeParser;
import org.jetbrains.kotlin.org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.org.apache.ivy.util.XMLHelper;
import org.jetbrains.kotlin.org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Element projectElement;
    private final Element parentElement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomReader(URL descriptorURL, Resource res2) throws IOException, SAXException {
        AddDTDFilterInputStream stream = new AddDTDFilterInputStream(URLHandlerRegistry.getDefault().openStream(descriptorURL));
        InputSource source = new InputSource(stream);
        source.setSystemId(XMLHelper.toSystemId(descriptorURL));
        try {
            Document pomDomDoc = XMLHelper.parseToDom(source, new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.endsWith("m2-entities.ent")) {
                        return new InputSource(PomReader.class.getResourceAsStream("m2-entities.ent"));
                    }
                    return null;
                }
            });
            this.projectElement = pomDomDoc.getDocumentElement();
            if (!"project".equals(this.projectElement.getNodeName()) && !"model".equals(this.projectElement.getNodeName())) {
                throw new SAXParseException("project must be the root tag", res2.getName(), res2.getName(), 0, 0);
            }
            this.parentElement = PomReader.getFirstChildElement(this.projectElement, "parent");
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException pomDomDoc) {}
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            this.setProperty("env." + (String)entry.getKey(), (String)entry.getValue());
        }
        Properties sysProps = System.getProperties();
        for (String sysProp : sysProps.stringPropertyNames()) {
            this.setProperty(sysProp, sysProps.getProperty(sysProp));
        }
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String prop, String val) {
        if (!this.properties.containsKey(prop) && val != null) {
            this.properties.put(prop, val);
        }
    }

    public String getGroupId() {
        String groupId = PomReader.getFirstChildText(this.projectElement, "groupId");
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.parentElement, "groupId");
        }
        return this.replaceProps(groupId);
    }

    public String getParentGroupId() {
        String groupId = PomReader.getFirstChildText(this.parentElement, "groupId");
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.projectElement, "groupId");
        }
        return this.replaceProps(groupId);
    }

    public String getArtifactId() {
        String val = PomReader.getFirstChildText(this.projectElement, "artifactId");
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, "artifactId");
        }
        return this.replaceProps(val);
    }

    public String getParentArtifactId() {
        String val = PomReader.getFirstChildText(this.parentElement, "artifactId");
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, "artifactId");
        }
        return this.replaceProps(val);
    }

    public String getVersion() {
        String val = PomReader.getFirstChildText(this.projectElement, "version");
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, "version");
        }
        return this.replaceProps(val);
    }

    public String getParentVersion() {
        String val = PomReader.getFirstChildText(this.parentElement, "version");
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, "version");
        }
        return this.replaceProps(val);
    }

    public String getPackaging() {
        String val = PomReader.getFirstChildText(this.projectElement, "packaging");
        if (val == null) {
            return "jar";
        }
        return this.replaceProps(val);
    }

    public String getHomePage() {
        String val = PomReader.getFirstChildText(this.projectElement, "url");
        if (val == null) {
            val = "";
        }
        return val;
    }

    public String getDescription() {
        String val = PomReader.getFirstChildText(this.projectElement, "description");
        if (val == null) {
            val = "";
        }
        return val.trim();
    }

    public License[] getLicenses() {
        Element licenses = PomReader.getFirstChildElement(this.projectElement, "licenses");
        if (licenses == null) {
            return new License[0];
        }
        licenses.normalize();
        ArrayList<License> lics = new ArrayList<License>();
        for (Element license : PomReader.getAllChilds(licenses)) {
            if (!"license".equals(license.getNodeName())) continue;
            String name = PomReader.getFirstChildText(license, "name");
            String url = PomReader.getFirstChildText(license, "url");
            if (name == null && url == null) continue;
            if (name == null) {
                name = "Unknown License";
            }
            lics.add(new License(name, url));
        }
        return lics.toArray(new License[lics.size()]);
    }

    public ModuleRevisionId getRelocation() {
        String relocVersion;
        String relocArtId;
        Element distrMgt = PomReader.getFirstChildElement(this.projectElement, "distributionManagement");
        Element relocation = PomReader.getFirstChildElement(distrMgt, "relocation");
        if (relocation == null) {
            return null;
        }
        String relocGroupId = PomReader.getFirstChildText(relocation, "groupId");
        if (relocGroupId == null) {
            relocGroupId = this.getGroupId();
        }
        if ((relocArtId = PomReader.getFirstChildText(relocation, "artifactId")) == null) {
            relocArtId = this.getArtifactId();
        }
        if ((relocVersion = PomReader.getFirstChildText(relocation, "version")) == null) {
            relocVersion = this.getVersion();
        }
        return ModuleRevisionId.newInstance(relocGroupId, relocArtId, relocVersion);
    }

    public List<PomDependencyData> getDependencies() {
        return this.getDependencies(this.projectElement);
    }

    private List<PomDependencyData> getDependencies(Element parent) {
        Element dependenciesElement = PomReader.getFirstChildElement(parent, "dependencies");
        if (dependenciesElement == null) {
            return Collections.emptyList();
        }
        LinkedList<PomDependencyData> dependencies = new LinkedList<PomDependencyData>();
        NodeList children = dependenciesElement.getChildNodes();
        int sz = children.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
            dependencies.add(new PomDependencyData((Element)node));
        }
        return dependencies;
    }

    public List<PomDependencyMgt> getDependencyMgt() {
        return this.getDependencyMgt(this.projectElement);
    }

    private List<PomDependencyMgt> getDependencyMgt(Element parent) {
        Element dependenciesElement = PomReader.getFirstChildElement(PomReader.getFirstChildElement(parent, "dependencyManagement"), "dependencies");
        if (dependenciesElement == null) {
            return Collections.emptyList();
        }
        LinkedList<PomDependencyMgt> dependencies = new LinkedList<PomDependencyMgt>();
        NodeList children = dependenciesElement.getChildNodes();
        int sz = children.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
            dependencies.add(new PomDependencyMgtElement((Element)node));
        }
        return dependencies;
    }

    public List<PomProfileElement> getProfiles() {
        Element profilesElement = PomReader.getFirstChildElement(this.projectElement, "profiles");
        if (profilesElement == null) {
            return Collections.emptyList();
        }
        LinkedList<PomProfileElement> result = new LinkedList<PomProfileElement>();
        NodeList children = profilesElement.getChildNodes();
        int sz = children.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !"profile".equals(node.getNodeName())) continue;
            result.add(new PomProfileElement((Element)node));
        }
        return result;
    }

    public List<PomPluginElement> getPlugins() {
        return this.getPlugins(this.projectElement);
    }

    private List<PomPluginElement> getPlugins(Element parent) {
        Element buildElement = PomReader.getFirstChildElement(parent, "build");
        Element pluginsElement = PomReader.getFirstChildElement(buildElement, "plugins");
        if (pluginsElement == null) {
            return Collections.emptyList();
        }
        NodeList children = pluginsElement.getChildNodes();
        LinkedList<PomPluginElement> plugins = new LinkedList<PomPluginElement>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !"plugin".equals(node.getNodeName())) continue;
            plugins.add(new PomPluginElement((Element)node));
        }
        return plugins;
    }

    private static Map<String, String> getProperties(Element parent) {
        Element propsEl = PomReader.getFirstChildElement(parent, "properties");
        if (propsEl == null) {
            return Collections.emptyMap();
        }
        propsEl.normalize();
        HashMap<String, String> props = new HashMap<String, String>();
        for (Element prop : PomReader.getAllChilds(propsEl)) {
            props.put(prop.getNodeName(), PomReader.getTextContent(prop));
        }
        return props;
    }

    public Map<String, String> getPomProperties() {
        return new HashMap<String, String>(PomReader.getProperties(this.projectElement));
    }

    private String replaceProps(String val) {
        if (val == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(val, this.properties).trim();
    }

    private static String getTextContent(Element element) {
        StringBuilder result = new StringBuilder();
        NodeList childNodes = element.getChildNodes();
        block3: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    result.append(child.getNodeValue());
                    continue block3;
                }
            }
        }
        return result.toString();
    }

    private static String getFirstChildText(Element parentElem, String name) {
        Element node = PomReader.getFirstChildElement(parentElem, name);
        if (node != null) {
            return PomReader.getTextContent(node);
        }
        return null;
    }

    private static Element getFirstChildElement(Element parentElem, String name) {
        if (parentElem == null) {
            return null;
        }
        NodeList childs = parentElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element) || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List<Element> getAllChilds(Element parent) {
        LinkedList<Element> r = new LinkedList<Element>();
        if (parent != null) {
            NodeList childs = parent.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element)) continue;
                r.add((Element)node);
            }
        }
        return r;
    }

    private static final class AddDTDFilterInputStream
    extends FilterInputStream {
        private int count;
        private byte[] prefix = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n".getBytes();

        private AddDTDFilterInputStream(InputStream in) throws IOException {
            super(new BufferedInputStream(in));
            this.in.mark(10000);
            int byte1 = this.in.read();
            int byte2 = this.in.read();
            int byte3 = this.in.read();
            if (byte1 == 239 && byte2 == 187 && byte3 == 191) {
                this.in.mark(10000);
            } else {
                this.in.reset();
            }
            int bytesToSkip = 0;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.in, StandardCharsets.UTF_8), 100);
            String firstLine = reader.readLine();
            if (firstLine != null) {
                String trimmed = firstLine.trim();
                if (trimmed.startsWith("<?xml ")) {
                    int endIndex = trimmed.indexOf("?>");
                    String xmlDecl = trimmed.substring(0, endIndex + 2);
                    this.prefix = (xmlDecl + "\n" + "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n").getBytes();
                    bytesToSkip = xmlDecl.getBytes().length;
                }
            } else {
                this.prefix = new byte[0];
            }
            this.in.reset();
            for (int i = 0; i < bytesToSkip; ++i) {
                this.in.read();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.count < this.prefix.length) {
                return this.prefix[this.count++];
            }
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int nbrBytesCopied = 0;
            if (this.count < this.prefix.length) {
                int nbrBytesFromPrefix = Math.min(this.prefix.length - this.count, len);
                System.arraycopy(this.prefix, this.count, b, off, nbrBytesFromPrefix);
                nbrBytesCopied = nbrBytesFromPrefix;
            }
            if (nbrBytesCopied < len) {
                nbrBytesCopied += this.in.read(b, off + nbrBytesCopied, len - nbrBytesCopied);
            }
            this.count += nbrBytesCopied;
            return nbrBytesCopied;
        }
    }

    public class PomProfileElement {
        private final Element profileElement;

        PomProfileElement(Element profileElement) {
            this.profileElement = profileElement;
        }

        public boolean isActive() {
            return this.isActiveByDefault() || this.isActivatedByProperty() || this.isActiveByOS() || this.isActiveByJDK() || this.isActiveByFile();
        }

        public boolean isActiveByDefault() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, "activation");
            return Boolean.parseBoolean(PomReader.getFirstChildText(activation, "activeByDefault"));
        }

        public boolean isActiveByOS() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, "activation");
            if (activation == null) {
                return false;
            }
            Element osActivation = PomReader.getFirstChildElement(activation, "os");
            if (osActivation == null) {
                return false;
            }
            String actualOS = System.getProperty("os.name");
            String expectedOSName = PomReader.getFirstChildText(osActivation, "name");
            if (expectedOSName != null && !actualOS.equals(expectedOSName.trim())) {
                return false;
            }
            String expectedOSFamily = PomReader.getFirstChildText(osActivation, "family");
            if (expectedOSFamily != null && !actualOS.contains(expectedOSFamily.trim())) {
                return false;
            }
            String expectedOSArch = PomReader.getFirstChildText(osActivation, "arch");
            if (expectedOSArch != null && !System.getProperty("os.arch").equals(expectedOSArch.trim())) {
                return false;
            }
            String expectedOSVersion = PomReader.getFirstChildText(osActivation, "version");
            if (expectedOSVersion != null && !System.getProperty("os.version").equals(expectedOSVersion.trim())) {
                return false;
            }
            return expectedOSName != null || expectedOSFamily != null || expectedOSArch != null || expectedOSVersion != null;
        }

        public boolean isActiveByJDK() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, "activation");
            if (activation == null) {
                return false;
            }
            String expectedJDKRange = PomReader.getFirstChildText(activation, "jdk");
            if (expectedJDKRange == null) {
                return false;
            }
            boolean negate = expectedJDKRange.trim().startsWith("!");
            String nonNegatedRange = negate ? expectedJDKRange.substring(1).trim() : expectedJDKRange.trim();
            boolean javaVersionInRange = MavenVersionRangeParser.currentJavaVersionInRange(nonNegatedRange);
            return javaVersionInRange ^ negate;
        }

        public boolean isActiveByFile() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, "activation");
            if (activation == null) {
                return false;
            }
            Element fileActivation = PomReader.getFirstChildElement(activation, "file");
            if (fileActivation == null) {
                return false;
            }
            String expectedMissing = PomReader.getFirstChildText(fileActivation, "missing");
            if (expectedMissing != null && new File(expectedMissing.trim()).exists()) {
                return false;
            }
            String expectedExists = PomReader.getFirstChildText(fileActivation, "exists");
            if (expectedExists != null && !new File(expectedExists.trim()).exists()) {
                return false;
            }
            return expectedMissing != null || expectedExists != null;
        }

        public boolean isActivatedByProperty() {
            boolean negate;
            Element activation = PomReader.getFirstChildElement(this.profileElement, "activation");
            Element propertyActivation = PomReader.getFirstChildElement(activation, "property");
            String propertyName = PomReader.getFirstChildText(propertyActivation, "name");
            if (propertyName == null || "".equals(propertyName)) {
                return false;
            }
            boolean bl = negate = propertyName.charAt(0) == '!';
            if (negate) {
                propertyName = propertyName.substring(1);
            }
            if ("".equals(propertyName)) {
                return false;
            }
            String propertyValue = PomReader.getFirstChildText(propertyActivation, "value");
            boolean matched = propertyValue == null || "".equals(propertyValue) ? PomReader.this.properties.containsKey(propertyName) : propertyValue.equals(PomReader.this.properties.get(propertyName));
            return matched ^ negate;
        }

        public List<PomDependencyData> getDependencies() {
            return PomReader.this.getDependencies(this.profileElement);
        }

        public List<PomDependencyMgt> getDependencyMgt() {
            return PomReader.this.getDependencyMgt(this.profileElement);
        }

        public List<PomPluginElement> getPlugins() {
            return PomReader.this.getPlugins(this.profileElement);
        }

        public Map<String, String> getProfileProperties() {
            return PomReader.getProperties(this.profileElement);
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        public PomDependencyData(PomDependencyData copyFrom) {
            this(copyFrom.depElement);
        }

        PomDependencyData(Element depElement) {
            super(depElement);
            this.depElement = depElement;
        }

        @Override
        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, "scope");
            return this.emptyIsNull(PomReader.this.replaceProps(val));
        }

        public String getClassifier() {
            String val = PomReader.getFirstChildText(this.depElement, "classifier");
            return this.emptyIsNull(PomReader.this.replaceProps(val));
        }

        public String getType() {
            String val = PomReader.getFirstChildText(this.depElement, "type");
            return this.emptyIsNull(PomReader.this.replaceProps(val));
        }

        public boolean isOptional() {
            return Boolean.parseBoolean(PomReader.getFirstChildText(this.depElement, "optional"));
        }

        private String emptyIsNull(String val) {
            if (val == null) {
                return null;
            }
            return val.equals("") ? null : val;
        }
    }

    public class PomPluginElement
    implements PomDependencyMgt {
        private Element pluginElement;

        PomPluginElement(Element pluginElement) {
            this.pluginElement = pluginElement;
        }

        @Override
        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.pluginElement, "groupId");
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.pluginElement, "artifactId");
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomReader.getFirstChildText(this.pluginElement, "version");
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List<ModuleId> getExcludedModules() {
            return Collections.emptyList();
        }
    }

    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        public PomDependencyMgtElement(PomDependencyMgtElement copyFrom) {
            this(copyFrom.depElement);
        }

        PomDependencyMgtElement(Element depElement) {
            this.depElement = depElement;
        }

        @Override
        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.depElement, "groupId");
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.depElement, "artifactId");
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomReader.getFirstChildText(this.depElement, "version");
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, "scope");
            return PomReader.this.replaceProps(val);
        }

        @Override
        public List<ModuleId> getExcludedModules() {
            Element exclusionsElement = PomReader.getFirstChildElement(this.depElement, "exclusions");
            if (exclusionsElement == null) {
                return Collections.emptyList();
            }
            LinkedList<ModuleId> exclusions = new LinkedList<ModuleId>();
            NodeList children = exclusionsElement.getChildNodes();
            int sz = children.getLength();
            for (int i = 0; i < sz; ++i) {
                Node node = children.item(i);
                if (!(node instanceof Element) || !"exclusion".equals(node.getNodeName())) continue;
                String groupId = PomReader.getFirstChildText((Element)node, "groupId");
                String artifactId = PomReader.getFirstChildText((Element)node, "artifactId");
                if (groupId == null || artifactId == null) continue;
                exclusions.add(ModuleId.newInstance(groupId, artifactId));
            }
            return exclusions;
        }
    }
}

