/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.rosetta;

public enum WikiLanguage {
    DOKUWIKI,
    MARKDOWN,
    ASCIIDOC,
    MEDIAWIKI,
    CREOLE,
    UNICODE,
    HTML_DEBUG;

    private static final MyChar START;
    private static final MyChar END;
    private static final MyChar SEMICOLON;
    private static final MyChar EQUALS;
    private static final MyChar EOB;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static String toHtmlDebug(String s) {
        s = START.toHtmlDebug(s);
        s = END.toHtmlDebug(s);
        s = SEMICOLON.toHtmlDebug(s);
        s = EQUALS.toHtmlDebug(s);
        s = EOB.toHtmlDebug(s);
        return s;
    }

    public static String hideCharsF7(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (char ch : s.toCharArray()) {
            sb.append(WikiLanguage.toF7(ch));
        }
        return sb.toString();
    }

    public static String restoreAllCharsF7AndDoEscapeForBackSlash(String s) {
        return WikiLanguage.restoreAllCharsF7(s);
    }

    public static String restoreAllCharsF7(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (char ch : s.toCharArray()) {
            if (ch >= '\uf700' && ch <= '\uf7ff') {
                ch = (char)(ch - 63232);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static char toF7(char ch) {
        if (ch < '\u007f') {
            return (char)(63232 + ch);
        }
        return ch;
    }

    public String slashTag(String tagName) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(END.toRightSyntax(this));
        tmp.append(tagName);
        tmp.append(SEMICOLON.toRightSyntax(this));
        tmp.append(EOB.toRightSyntax(this));
        return tmp.toString();
    }

    public String tag(String tagName) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(START.toRightSyntax(this));
        tmp.append(tagName);
        tmp.append(SEMICOLON.toRightSyntax(this));
        tmp.append(EOB.toRightSyntax(this));
        return tmp.toString();
    }

    public String tag(String tagName, String name, String value) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(START.toRightSyntax(this));
        tmp.append(tagName);
        tmp.append(SEMICOLON.toRightSyntax(this));
        tmp.append(name);
        tmp.append(EQUALS.toRightSyntax(this));
        tmp.append(value);
        tmp.append(SEMICOLON.toRightSyntax(this));
        tmp.append(EOB.toRightSyntax(this));
        return tmp.toString();
    }

    static {
        START = new MyChar("\uf800", "<<{{");
        END = new MyChar("\uf802", "<</{{");
        SEMICOLON = new MyChar("\uf810", ";;;");
        EQUALS = new MyChar("\uf811", "===");
        EOB = new MyChar("\uf899", "}}>>");
    }

    static class MyChar {
        final String unicode;
        final String htmlDebug;

        MyChar(String unicode, String htmlDebug) {
            this.unicode = unicode;
            this.htmlDebug = htmlDebug;
        }

        String toRightSyntax(WikiLanguage lg) {
            if (lg == UNICODE) {
                return "" + this.unicode;
            }
            if (lg == HTML_DEBUG) {
                return "" + this.htmlDebug;
            }
            throw new UnsupportedOperationException();
        }

        public String toHtmlDebug(String s) {
            return s.replace(this.unicode, this.htmlDebug);
        }
    }
}

