/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class NoteTile
extends AbstractTile
implements Tile {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Note note;

    @Override
    public Event getEvent() {
        return this.note;
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getPreferredHeight(stringBounder) / 2.0;
    }

    public NoteTile(LivingSpace livingSpace1, LivingSpace livingSpace2, Note note, Rose skin, ISkinParam skinParam) {
        this.livingSpace1 = livingSpace1;
        this.livingSpace2 = livingSpace2;
        this.note = note;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(this.note.getUsedStyles(), this.getNoteComponentType(this.note.getNoteStyle()), null, this.note.getSkinParamBackcolored(this.skinParam), this.note.getStrings());
        return comp;
    }

    private ComponentType getNoteComponentType(NoteStyle noteStyle) {
        if (noteStyle == NoteStyle.HEXAGONAL) {
            return ComponentType.NOTE_HEXAGONAL;
        }
        if (noteStyle == NoteStyle.BOX) {
            return ComponentType.NOTE_BOX;
        }
        return ComponentType.NOTE;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double x = this.getX(stringBounder).getCurrentValue();
        Area area = new Area(this.getUsedWidth(stringBounder), dim.getHeight());
        ug = ug.apply(UTranslate.dx(x));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    private double getUsedWidth(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            double x1 = this.livingSpace1.getPosB().getCurrentValue();
            double x2 = this.livingSpace2.getPosD(stringBounder).getCurrentValue();
            double w = x2 - x1;
            if (width < w) {
                return w;
            }
        }
        return width;
    }

    private Real getX(StringBounder stringBounder) {
        NotePosition position = this.note.getPosition();
        double width = this.getUsedWidth(stringBounder);
        if (position == NotePosition.LEFT) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-width);
        }
        if (position == NotePosition.RIGHT) {
            int level = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            double dx = (double)level * 5.0;
            return this.livingSpace1.getPosC(stringBounder).addFixed(dx);
        }
        if (position == NotePosition.OVER_SEVERAL) {
            Real x1 = this.livingSpace1.getPosC(stringBounder);
            Real x2 = this.livingSpace2.getPosC(stringBounder);
            return RealUtils.middle(x1, x2).addFixed(-width / 2.0);
        }
        if (position == NotePosition.OVER) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-width / 2.0);
        }
        throw new UnsupportedOperationException(position.toString());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getHeight();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        Real result = this.getX(stringBounder);
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            Real x1 = this.livingSpace1.getPosB();
            return RealUtils.min(result, x1);
        }
        return result;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        Real result = this.getX(stringBounder).addFixed(this.getUsedWidth(stringBounder));
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            Real x2 = this.livingSpace2.getPosD(stringBounder);
            return RealUtils.max(result, x2);
        }
        return result;
    }
}

