/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

public class GraphvizCrash
extends AbstractTextBlock
implements IEntityImage {
    private final TextBlock text1;
    private final BufferedImage flashCode;
    private final String text;
    private final boolean graphviz244onWindows;

    public GraphvizCrash(String text, boolean graphviz244onWindows) {
        this.text = text;
        this.graphviz244onWindows = graphviz244onWindows;
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        this.flashCode = utils.exportFlashcode(text, Color.BLACK, Color.WHITE);
        this.text1 = GraphicStrings.createBlackOnWhite(this.init(), IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    public static List<String> anErrorHasOccured(Throwable exception, String text) {
        ArrayList<String> strings = new ArrayList<String>();
        if (exception == null) {
            strings.add("An error has occured!");
        } else {
            strings.add("An error has occured : " + exception);
        }
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        strings.add("Diagram size: " + GraphvizCrash.lines(text) + " lines / " + text.length() + " characters.");
        strings.add(" ");
        return strings;
    }

    private static int lines(String text) {
        int result = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    public static void checkOldVersionWarning(List<String> strings) {
        long days = (System.currentTimeMillis() - Version.compileTime()) / 1000L / 3600L / 24L;
        if (days >= 90L) {
            strings.add("This version of PlantUML is " + days + " days old, so you should");
            strings.add("  consider upgrading from https://plantuml.com/download");
        }
    }

    public static void pleaseGoTo(List<String> strings) {
        strings.add(" ");
        strings.add("Please go to https://plantuml.com/graphviz-dot to check your GraphViz version.");
        strings.add(" ");
    }

    public static void youShouldSendThisDiagram(List<String> strings) {
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>https://plantuml.com/qa</b> to solve this issue.");
        strings.add("You can try to turn arround this issue by simplifing your diagram.");
    }

    public static void thisMayBeCaused(List<String> strings) {
        strings.add("This may be caused by :");
        strings.add(" - a bug in PlantUML");
        strings.add(" - a problem in GraphViz");
    }

    private List<String> init() {
        List<String> strings = GraphvizCrash.anErrorHasOccured(null, this.text);
        strings.add("For some reason, dot/GraphViz has crashed.");
        strings.add("This has been generated with PlantUML (" + Version.versionString() + ").");
        GraphvizCrash.checkOldVersionWarning(strings);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        try {
            String dotVersion = GraphvizUtils.dotVersion();
            strings.add("Default dot version: " + dotVersion);
        }
        catch (Throwable e) {
            strings.add("Cannot determine dot version: " + e.toString());
        }
        GraphvizCrash.pleaseGoTo(strings);
        GraphvizCrash.youShouldSendThisDiagram(strings);
        if (this.flashCode != null) {
            GraphvizCrash.addDecodeHint(strings);
        }
        return strings;
    }

    private List<String> getText2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>It looks like you are running GraphViz 2.44 under Windows.");
        strings.add("If you have just installed GraphViz, you <i>may</i> have to execute");
        strings.add("the post-install command <b>dot -c</b> like in the following example:");
        return strings;
    }

    public static void addDecodeHint(List<String> strings) {
        strings.add(" ");
        strings.add(" Diagram source: (Use http://zxing.org/w/decode.jspx to decode the qrcode)");
    }

    public static void addProperties(List<String> strings) {
        strings.addAll(OptionPrint.interestingProperties());
        strings.addAll(OptionPrint.interestingValues());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public HColor getBackcolor() {
        return HColorUtils.WHITE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getMain().calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getMain().drawU(ug);
    }

    private TextBlock getMain() {
        TextBlock result = this.text1;
        if (this.flashCode != null) {
            UImage flash = new UImage(new PixelImage(this.flashCode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(3.0);
            result = TextBlockUtils.mergeTB(result, flash, HorizontalAlignment.LEFT);
        }
        if (this.graphviz244onWindows) {
            TextBlockBackcolored text2 = GraphicStrings.createBlackOnWhite(this.getText2());
            result = TextBlockUtils.mergeTB(result, text2, HorizontalAlignment.LEFT);
            UImage dotc = new UImage(new PixelImage(PSystemVersion.getDotc(), AffineTransformType.TYPE_BILINEAR));
            result = TextBlockUtils.mergeTB(result, dotc, HorizontalAlignment.LEFT);
        }
        return result;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

