# -*- coding: utf-8 -*-
info = {
    "name": "id",
    "date_order": "DMY",
    "january": [
        "januari",
        "jan"
    ],
    "february": [
        "februari",
        "feb"
    ],
    "march": [
        "maret",
        "mar"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "juni",
        "jun"
    ],
    "july": [
        "juli",
        "jul"
    ],
    "august": [
        "agustus",
        "agt",
        "Agu"
    ],
    "september": [
        "september",
        "sep",
        "Sept"
    ],
    "october": [
        "oktober",
        "okt"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "desember",
        "des"
    ],
    "monday": [
        "senin",
        "sen"
    ],
    "tuesday": [
        "selasa",
        "sel"
    ],
    "wednesday": [
        "rabu",
        "rab"
    ],
    "thursday": [
        "kamis",
        "kam"
    ],
    "friday": [
        "jumat",
        "jum"
    ],
    "saturday": [
        "sabtu",
        "sab"
    ],
    "sunday": [
        "minggu",
        "min",
        "Ahad"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "tahun",
        "thn"
    ],
    "month": [
        "bulan",
        "bln"
    ],
    "week": [
        "minggu",
        "mgg"
    ],
    "day": [
        "hari",
        "h"
    ],
    "hour": [
        "jam",
        "j"
    ],
    "minute": [
        "menit",
        "mnt",
        "m"
    ],
    "second": [
        "detik",
        "dtk",
        "d"
    ],
    "relative-type": {
        "1 year ago": [
            "tahun lalu"
        ],
        "0 year ago": [
            "tahun ini"
        ],
        "in 1 year": [
            "tahun depan"
        ],
        "1 month ago": [
            "bulan lalu"
        ],
        "0 month ago": [
            "bulan ini"
        ],
        "in 1 month": [
            "bulan berikutnya"
        ],
        "1 week ago": [
            "minggu lalu"
        ],
        "0 week ago": [
            "minggu ini"
        ],
        "in 1 week": [
            "minggu depan"
        ],
        "1 day ago": [
            "kemarin"
        ],
        "0 day ago": [
            "hari ini"
        ],
        "in 1 day": [
            "besok"
        ],
        "0 hour ago": [
            "jam ini"
        ],
        "0 minute ago": [
            "menit ini"
        ],
        "0 second ago": [
            "sekarang",
            "baru saja"
        ],
        "1 year": [
            "setahun"
        ],
        "1 month": [
            "sebulan"
        ],
        "1 week": [
            "seminggu"
        ],
        "2 day ago": [
            "kemarin lusa"
        ],
        "1 day": [
            "sehari"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "dalam (\\d+) tahun",
            "dlm (\\d+) thn"
        ],
        "\\1 year ago": [
            "(\\d+) tahun yang lalu",
            "(\\d+) thn lalu"
        ],
        "in \\1 month": [
            "dalam (\\d+) bulan",
            "dlm (\\d+) bln"
        ],
        "\\1 month ago": [
            "(\\d+) bulan yang lalu",
            "(\\d+) bln lalu"
        ],
        "in \\1 week": [
            "dalam (\\d+) minggu",
            "dlm (\\d+) mgg"
        ],
        "\\1 week ago": [
            "(\\d+) minggu yang lalu",
            "(\\d+) mgg lalu"
        ],
        "in \\1 day": [
            "dalam (\\d+) hari",
            "dalam (\\d+) h"
        ],
        "\\1 day ago": [
            "(\\d+) hari yang lalu",
            "(\\d+) h lalu"
        ],
        "in \\1 hour": [
            "dalam (\\d+) jam"
        ],
        "\\1 hour ago": [
            "(\\d+) jam yang lalu",
            "(\\d+) jam lalu"
        ],
        "in \\1 minute": [
            "dalam (\\d+) menit",
            "dlm (\\d+) mnt"
        ],
        "\\1 minute ago": [
            "(\\d+) menit yang lalu",
            "(\\d+) mnt lalu"
        ],
        "in \\1 second": [
            "dalam (\\d+) detik",
            "dlm (\\d+) dtk"
        ],
        "\\1 second ago": [
            "(\\d+) detik yang lalu",
            "(\\d+) dtk lalu"
        ]
    },
    "locale_specific": {},
    "skip": [
        "tanggal",
        "pukul",
        "yang",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "lalu"
    ],
    "in": [
        "dalam"
    ]
}
