# -*- coding: utf-8 -*-
info = {
    "name": "sv",
    "date_order": "YMD",
    "january": [
        "januari",
        "jan"
    ],
    "february": [
        "februari",
        "feb"
    ],
    "march": [
        "mars"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "maj"
    ],
    "june": [
        "juni",
        "Jun"
    ],
    "july": [
        "juli",
        "Jul"
    ],
    "august": [
        "augusti",
        "aug"
    ],
    "september": [
        "september",
        "sep",
        "Sept"
    ],
    "october": [
        "oktober",
        "okt"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "december",
        "dec"
    ],
    "monday": [
        "måndag",
        "mån",
        "Månd"
    ],
    "tuesday": [
        "tisdag",
        "tis",
        "Tisd"
    ],
    "wednesday": [
        "onsdag",
        "ons",
        "Onsd"
    ],
    "thursday": [
        "torsdag",
        "tors",
        "Torsd"
    ],
    "friday": [
        "fredag",
        "fre",
        "Fred"
    ],
    "saturday": [
        "lördag",
        "lör",
        "Lörd"
    ],
    "sunday": [
        "söndag",
        "sön",
        "Sönd"
    ],
    "am": [
        "förmiddag",
        "fm"
    ],
    "pm": [
        "eftermiddag",
        "em"
    ],
    "year": [
        "år",
        "året"
    ],
    "month": [
        "månad",
        "m",
        "mån",
        "månader",
        "månaden"
    ],
    "week": [
        "vecka",
        "v",
        "veckor"
    ],
    "day": [
        "dag",
        "dagar"
    ],
    "hour": [
        "timme",
        "tim",
        "h",
        "timmar",
        "t"
    ],
    "minute": [
        "minut",
        "min",
        "m",
        "minuter"
    ],
    "second": [
        "sekund",
        "sek",
        "s",
        "sekunder"
    ],
    "relative-type": {
        "1 year ago": [
            "i fjol",
            "förra året"
        ],
        "0 year ago": [
            "i år"
        ],
        "in 1 year": [
            "nästa år"
        ],
        "1 month ago": [
            "förra månaden",
            "förra mån"
        ],
        "0 month ago": [
            "denna månad",
            "denna mån"
        ],
        "in 1 month": [
            "nästa månad",
            "nästa mån"
        ],
        "1 week ago": [
            "förra veckan",
            "förra v"
        ],
        "0 week ago": [
            "denna vecka",
            "denna v"
        ],
        "in 1 week": [
            "nästa vecka",
            "nästa v"
        ],
        "1 day ago": [
            "i går",
            "igår"
        ],
        "0 day ago": [
            "i dag",
            "idag"
        ],
        "in 1 day": [
            "i morgon",
            "imorgon"
        ],
        "0 hour ago": [
            "denna timme"
        ],
        "0 minute ago": [
            "denna minut"
        ],
        "0 second ago": [
            "nu"
        ],
        "2 day ago": [
            "förrgår"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "om (\\d+) år"
        ],
        "\\1 year ago": [
            "för (\\d+) år sedan",
            "−(\\d+) år"
        ],
        "in \\1 month": [
            "om (\\d+) månad",
            "om (\\d+) månader",
            "om (\\d+) mån"
        ],
        "\\1 month ago": [
            "för (\\d+) månad sedan",
            "för (\\d+) månader sedan",
            "för (\\d+) mån sedan",
            "−(\\d+) mån"
        ],
        "in \\1 week": [
            "om (\\d+) vecka",
            "om (\\d+) veckor",
            "om (\\d+) v"
        ],
        "\\1 week ago": [
            "för (\\d+) vecka sedan",
            "för (\\d+) veckor sedan",
            "för (\\d+) v sedan",
            "−(\\d+) v"
        ],
        "in \\1 day": [
            "om (\\d+) dag",
            "om (\\d+) dagar",
            "om (\\d+) d"
        ],
        "\\1 day ago": [
            "för (\\d+) dag sedan",
            "för (\\d+) dagar sedan",
            "för (\\d+) d sedan",
            "−(\\d+) d"
        ],
        "in \\1 hour": [
            "om (\\d+) timme",
            "om (\\d+) timmar",
            "om (\\d+) tim"
        ],
        "\\1 hour ago": [
            "för (\\d+) timme sedan",
            "för (\\d+) timmar sedan",
            "för (\\d+) tim sedan",
            "−(\\d+) h"
        ],
        "in \\1 minute": [
            "om (\\d+) minut",
            "om (\\d+) minuter",
            "om (\\d+) min"
        ],
        "\\1 minute ago": [
            "för (\\d+) minut sedan",
            "för (\\d+) minuter sedan",
            "för (\\d+) min sedan",
            "−(\\d+) min"
        ],
        "in \\1 second": [
            "om (\\d+) sekund",
            "om (\\d+) sekunder",
            "om (\\d+) sek"
        ],
        "\\1 second ago": [
            "för (\\d+) sekund sedan",
            "för (\\d+) sekunder sedan",
            "för (\\d+) sek sedan",
            "−(\\d+) s"
        ]
    },
    "locale_specific": {
        "sv-AX": {
            "name": "sv-AX"
        },
        "sv-FI": {
            "name": "sv-FI",
            "date_order": "DMY"
        }
    },
    "skip": [
        "på",
        "den",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "sedan"
    ],
    "in": [
        "om",
        "från nu"
    ],
    "simplifications": [
        {
            "en": "1"
        },
        {
            "två": "2"
        }
    ]
}
