/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;

public class NullableSpinner
extends AutoCommitSpinner {
    public NullableSpinner() {
        this(new NullableSpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    }

    public NullableSpinner(NullableSpinnerNumberModel nullableSpinnerNumberModel) {
        super(nullableSpinnerNumberModel, nullableSpinnerNumberModel.getFormat());
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        final JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
        jFormattedTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return new NumberFormatter(){

                    @Override
                    public Format getFormat() {
                        if (abstractFormatter instanceof NumberFormatter) {
                            return ((NumberFormatter)abstractFormatter).getFormat();
                        }
                        return super.getFormat();
                    }

                    @Override
                    public boolean getCommitsOnValidEdit() {
                        if (abstractFormatter instanceof NumberFormatter) {
                            return ((NumberFormatter)abstractFormatter).getCommitsOnValidEdit();
                        }
                        return super.getCommitsOnValidEdit();
                    }

                    public Comparable getMaximum() {
                        if (abstractFormatter instanceof NumberFormatter) {
                            return ((NumberFormatter)abstractFormatter).getMaximum();
                        }
                        return super.getMaximum();
                    }

                    public Comparable getMinimum() {
                        if (abstractFormatter instanceof NumberFormatter) {
                            return ((NumberFormatter)abstractFormatter).getMinimum();
                        }
                        return super.getMinimum();
                    }

                    public void setMaximum(Comparable comparable) {
                        if (abstractFormatter instanceof NumberFormatter) {
                            ((NumberFormatter)abstractFormatter).setMaximum(comparable);
                        } else {
                            super.setMaximum(comparable);
                        }
                    }

                    public void setMinimum(Comparable comparable) {
                        if (abstractFormatter instanceof NumberFormatter) {
                            ((NumberFormatter)abstractFormatter).setMinimum(comparable);
                        } else {
                            super.setMinimum(comparable);
                        }
                    }

                    @Override
                    public Object stringToValue(String string) throws ParseException {
                        if (string.length() == 0 && ((NullableSpinnerNumberModel)NullableSpinner.this.getModel()).isNullable()) {
                            return null;
                        }
                        return abstractFormatter.stringToValue(string);
                    }

                    @Override
                    public String valueToString(Object object) throws ParseException {
                        if (object == null && ((NullableSpinnerNumberModel)NullableSpinner.this.getModel()).isNullable()) {
                            return "";
                        }
                        return abstractFormatter.valueToString(object);
                    }
                };
            }
        });
    }

    public static class NullableSpinnerNumberModel
    extends SpinnerNumberModel {
        private boolean isNull;
        private boolean nullable;

        public NullableSpinnerNumberModel(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public NullableSpinnerNumberModel(float f, float f2, float f3, float f4) {
            super(new Float(f), new Float(f2), new Float(f3), new Float(f4));
        }

        public NullableSpinnerNumberModel(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4) {
            super(bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4);
        }

        @Override
        public Object getNextValue() {
            if (this.isNull) {
                return super.getValue();
            }
            if (this.getMaximum() instanceof BigDecimal) {
                BigDecimal bigDecimal = ((BigDecimal)super.getValue()).add((BigDecimal)this.getStepSize());
                if (bigDecimal.compareTo((BigDecimal)this.getMaximum()) > 0) {
                    bigDecimal = (BigDecimal)this.getMaximum();
                }
                return bigDecimal;
            }
            Object object = super.getNextValue();
            if (object == null) {
                return this.getMaximum();
            }
            return object;
        }

        @Override
        public Object getPreviousValue() {
            if (this.isNull) {
                return super.getValue();
            }
            if (this.getMinimum() instanceof BigDecimal) {
                BigDecimal bigDecimal = ((BigDecimal)super.getValue()).subtract((BigDecimal)this.getStepSize());
                if (bigDecimal.compareTo((BigDecimal)this.getMinimum()) < 0) {
                    bigDecimal = (BigDecimal)this.getMinimum();
                }
                return bigDecimal;
            }
            Object object = super.getPreviousValue();
            if (object == null) {
                return this.getMinimum();
            }
            return object;
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return super.getValue();
        }

        @Override
        public void setValue(Object object) {
            if (object == null && this.isNullable()) {
                if (!this.isNull) {
                    this.isNull = true;
                    this.fireStateChanged();
                }
            } else if (this.isNull && object != null && object.equals(super.getValue())) {
                this.isNull = false;
                this.fireStateChanged();
            } else {
                this.isNull = false;
                super.setValue(object);
            }
        }

        @Override
        public Number getNumber() {
            return (Number)this.getValue();
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public void setNullable(boolean bl) {
            this.nullable = bl;
            if (!bl && this.getValue() == null) {
                this.setValue(this.getMinimum());
            }
        }

        Format getFormat() {
            return NumberFormat.getNumberInstance();
        }
    }

    public static class NullableSpinnerLengthModel
    extends NullableSpinnerNumberModel {
        private final UserPreferences preferences;

        public NullableSpinnerLengthModel(UserPreferences userPreferences, float f, float f2) {
            this(userPreferences, f, f, f2);
        }

        public NullableSpinnerLengthModel(UserPreferences userPreferences, float f, float f2, float f3) {
            super(f, f2, f3, userPreferences.getLengthUnit() == LengthUnit.INCH || userPreferences.getLengthUnit() == LengthUnit.INCH_DECIMALS ? LengthUnit.inchToCentimeter(0.125f) : 0.5f);
            this.preferences = userPreferences;
        }

        public Float getLength() {
            if (this.getValue() == null) {
                return null;
            }
            return Float.valueOf(((Number)this.getValue()).floatValue());
        }

        public void setLength(Float f) {
            this.setValue(f);
        }

        public void setMinimumLength(float f) {
            this.setMinimum(Float.valueOf(f));
        }

        @Override
        Format getFormat() {
            return this.getLengthUnit().getFormat();
        }

        LengthUnit getLengthUnit() {
            return this.preferences.getLengthUnit();
        }
    }

    public static class NullableSpinnerModuloNumberModel
    extends NullableSpinnerNumberModel {
        private Class numberClass;

        public NullableSpinnerModuloNumberModel(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.numberClass = Integer.TYPE;
        }

        public NullableSpinnerModuloNumberModel(float f, float f2, float f3, float f4) {
            super(f, f2, f3, f4);
            this.numberClass = Float.TYPE;
        }

        @Override
        public Object getNextValue() {
            if (this.numberClass == Integer.TYPE) {
                if (this.getValue() == null || this.getNumber().intValue() + this.getStepSize().intValue() < ((Number)((Object)this.getMaximum())).intValue()) {
                    return ((Number)super.getNextValue()).intValue();
                }
                return this.getNumber().intValue() + this.getStepSize().intValue() - ((Number)((Object)this.getMaximum())).intValue() + ((Number)((Object)this.getMinimum())).intValue();
            }
            if (this.getValue() == null || this.getNumber().floatValue() + this.getStepSize().floatValue() < ((Number)((Object)this.getMaximum())).floatValue()) {
                return Float.valueOf(((Number)super.getNextValue()).floatValue());
            }
            return Float.valueOf(this.getNumber().floatValue() + this.getStepSize().floatValue() - ((Number)((Object)this.getMaximum())).floatValue() + ((Number)((Object)this.getMinimum())).floatValue());
        }

        @Override
        public Object getPreviousValue() {
            if (this.numberClass == Integer.TYPE) {
                if (this.getValue() == null || this.getNumber().intValue() - this.getStepSize().intValue() >= ((Number)((Object)this.getMinimum())).intValue()) {
                    return ((Number)super.getPreviousValue()).intValue();
                }
                return this.getNumber().intValue() - this.getStepSize().intValue() - ((Number)((Object)this.getMinimum())).intValue() + ((Number)((Object)this.getMaximum())).intValue();
            }
            if (this.getValue() == null || this.getNumber().floatValue() - this.getStepSize().floatValue() >= ((Number)((Object)this.getMinimum())).floatValue()) {
                return Float.valueOf(((Number)super.getPreviousValue()).floatValue());
            }
            return Float.valueOf(this.getNumber().floatValue() - this.getStepSize().floatValue() - ((Number)((Object)this.getMinimum())).floatValue() + ((Number)((Object)this.getMaximum())).floatValue());
        }

        @Override
        Format getFormat() {
            return this.numberClass == Integer.TYPE ? NumberFormat.getIntegerInstance() : new DecimalFormat("0.#");
        }
    }

    public static class NullableSpinnerDateModel
    extends SpinnerDateModel {
        private boolean isNull;
        private boolean nullable;

        @Override
        public Object getNextValue() {
            if (this.isNull) {
                return super.getValue();
            }
            return super.getNextValue();
        }

        @Override
        public Object getPreviousValue() {
            if (this.isNull) {
                return super.getValue();
            }
            return super.getPreviousValue();
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return super.getValue();
        }

        @Override
        public void setValue(Object object) {
            if (object == null && this.isNullable()) {
                if (!this.isNull) {
                    this.isNull = true;
                    this.fireStateChanged();
                }
            } else if (this.isNull && object != null && object.equals(super.getValue())) {
                this.isNull = false;
                this.fireStateChanged();
            } else {
                this.isNull = false;
                super.setValue(object);
            }
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public void setNullable(boolean bl) {
            this.nullable = bl;
            if (!bl && this.getValue() == null) {
                this.setValue(new Date());
            }
        }
    }
}

