/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.ClassReferencePointer;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final ClassReferencePointer myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(0);
        }
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull PsiAnnotation[] annotations2) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(1);
        }
        if (annotations2 == null) {
            PsiClassReferenceType.$$$reportNull$$$0(2);
        }
        super(level, annotations2);
        this.myReference = ClassReferencePointer.constant(reference);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(4);
        }
        this(ClassReferencePointer.constant(reference), level, provider);
    }

    PsiClassReferenceType(@NotNull ClassReferencePointer reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(6);
        }
        super(level, provider);
        this.myReference = reference;
    }

    @NotNull
    private static PsiAnnotation[] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        SmartList<PsiAnnotation> result2 = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiAnnotation>();
            }
            result2.add((PsiAnnotation)child);
        }
        PsiAnnotation[] psiAnnotationArray = result2 == null ? PsiAnnotation.EMPTY_ARRAY : result2.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(7);
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean isValid() {
        PsiJavaCodeReferenceElement reference = this.myReference.retrieveReference();
        if (reference != null && reference.isValid()) {
            for (PsiAnnotation annotation2 : this.getAnnotations(false)) {
                if (annotation2.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsToText(@NotNull String text2) {
        PsiJavaCodeReferenceElement reference;
        String name;
        if (text2 == null) {
            PsiClassReferenceType.$$$reportNull$$$0(8);
        }
        return ((name = (reference = this.getReference()).getReferenceName()) == null || text2.contains(name)) && Comparing.equal(text2, this.getCanonicalText());
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getReference().getResolveScope();
        if (globalSearchScope == null) {
            PsiClassReferenceType.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations(true);
        if (psiAnnotationArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(10);
        }
        return psiAnnotationArray;
    }

    private PsiAnnotation[] getAnnotations(boolean merge) {
        PsiJavaCodeReferenceElement reference;
        PsiAnnotation[] annotations2 = super.getAnnotations();
        if (merge && (reference = this.myReference.retrieveReference()) != null && reference.isValid() && reference.isQualified()) {
            PsiAnnotation[] embedded = PsiClassReferenceType.collectAnnotations(reference);
            if (annotations2.length > 0 && embedded.length > 0) {
                LinkedHashSet set = new LinkedHashSet();
                ContainerUtil.addAll(set, annotations2);
                ContainerUtil.addAll(set, embedded);
                annotations2 = set.toArray(PsiAnnotation.EMPTY_ARRAY);
            } else {
                annotations2 = ArrayUtil.mergeArrays(annotations2, embedded);
            }
        }
        return annotations2;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                PsiClassReferenceType.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(this.getReference());
        if (languageLevel == null) {
            PsiClassReferenceType.$$$reportNull$$$0(12);
        }
        return languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiClassReferenceType.$$$reportNull$$$0(13);
        }
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            PsiClassReferenceType psiClassReferenceType = this;
            if (psiClassReferenceType == null) {
                PsiClassReferenceType.$$$reportNull$$$0(14);
            }
            return psiClassReferenceType;
        }
        return new PsiClassReferenceType(this.getReference(), languageLevel, this.getAnnotationProvider());
    }

    @Override
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (!reference.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)reference, this.myReference.toString() + "; augmenters=" + PsiAugmentProvider.EP_NAME.getExtensionList());
        }
        JavaResolveResult result2 = reference.advancedResolve(false);
        return result2.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result2);
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass2 = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable(aClass2).iterator().hasNext()) {
                PsiClassReferenceType psiClassReferenceType = this;
                if (psiClassReferenceType == null) {
                    PsiClassReferenceType.$$$reportNull$$$0(15);
                }
                return psiClassReferenceType;
            }
            PsiManager manager = reference.getManager();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
            PsiSubstitutor rawSubstitutor = factory2.createRawSubstitutor(aClass2);
            return new PsiImmediateClassType(aClass2, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider());
        }
        String qualifiedName = reference.getQualifiedName();
        String name = reference.getReferenceName();
        if (name == null) {
            name = "";
        }
        LightClassReference lightReference = new LightClassReference(reference.getManager(), name, qualifiedName, reference.getResolveScope());
        return new PsiClassReferenceType((PsiJavaCodeReferenceElement)lightReference, null, this.getAnnotationProvider());
    }

    @Override
    public String getClassName() {
        return this.getReference().getReferenceName();
    }

    @Override
    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.getReference().getTypeParameters();
        if (psiTypeArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(16);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        PsiAnnotation[] annotations2;
        String presentableText = PsiNameHelper.getPresentableText(this.getReference());
        PsiAnnotation[] psiAnnotationArray = annotations2 = annotated ? this.getAnnotations(false) : PsiAnnotation.EMPTY_ARRAY;
        if (annotations2.length == 0) {
            String string2 = presentableText;
            if (string2 == null) {
                PsiClassReferenceType.$$$reportNull$$$0(17);
            }
            return string2;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations2, false);
        sb.append(presentableText);
        String string3 = sb.toString();
        if (string3 == null) {
            PsiClassReferenceType.$$$reportNull$$$0(18);
        }
        return string3;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string2 = this.getText(annotated);
        if (string2 == null) {
            PsiClassReferenceType.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string2 = this.getCanonicalText(true);
        if (string2 == null) {
            PsiClassReferenceType.$$$reportNull$$$0(20);
        }
        return string2;
    }

    private String getText(boolean annotated) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiAnnotatedJavaCodeReferenceElement ref = (PsiAnnotatedJavaCodeReferenceElement)reference;
            PsiAnnotation[] annotations2 = annotated ? this.getAnnotations(false) : PsiAnnotation.EMPTY_ARRAY;
            return ref.getCanonicalText(annotated, annotations2.length == 0 ? null : annotations2);
        }
        return reference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.myReference.retrieveNonNullReference();
        if (psiJavaCodeReferenceElement == null) {
            PsiClassReferenceType.$$$reportNull$$$0(21);
        }
        return psiJavaCodeReferenceElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiClassReferenceType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiClassReferenceType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAnnotations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setLanguageLevel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "rawType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            if (delegate == null) {
                DelegatingClassResolveResult.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.myDelegate.getSubstitutor();
            if (psiSubstitutor == null) {
                DelegatingClassResolveResult.$$$reportNull$$$0(1);
            }
            return psiSubstitutor;
        }

        @Override
        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        @Override
        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        @Override
        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        @Override
        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        @Override
        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

