/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker$WhenMappings;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0018\u001a\u00020\u0011*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0019\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0015H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker;", "", "()V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkAsTopLevelTypeReference", "topLevelTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isReceiver", "", "checkDeclaration", "checkIfDelegatedProperty", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfHasBackingField", "checkIfMutableProperty", "checkIfProperty", "checkTypeReference", "useSiteDescription", "", "frontend"})
public final class AnnotationUseSiteTargetChecker {
    public static final AnnotationUseSiteTargetChecker INSTANCE;

    public final void check(@NotNull KtAnnotated annotated, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(annotated, "annotated");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.checkDeclaration(trace, annotated, descriptor2);
        if (annotated instanceof KtCallableDeclaration) {
            KtTypeReference it;
            boolean bl;
            boolean bl2;
            KtTypeReference ktTypeReference;
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)annotated).getReceiverTypeReference();
            if (ktTypeReference2 != null) {
                ktTypeReference = ktTypeReference2;
                bl2 = false;
                bl = false;
                it = ktTypeReference;
                boolean bl3 = false;
                KtTypeReference ktTypeReference3 = it;
                Intrinsics.checkNotNullExpressionValue(ktTypeReference3, "it");
                INSTANCE.checkTypeReference(trace, ktTypeReference3, languageVersionSettings, true);
            }
            KtTypeReference ktTypeReference4 = ((KtCallableDeclaration)annotated).getTypeReference();
            if (ktTypeReference4 != null) {
                ktTypeReference = ktTypeReference4;
                bl2 = false;
                bl = false;
                it = ktTypeReference;
                boolean bl4 = false;
                KtTypeReference ktTypeReference5 = it;
                Intrinsics.checkNotNullExpressionValue(ktTypeReference5, "it");
                INSTANCE.checkTypeReference(trace, ktTypeReference5, languageVersionSettings, false);
            }
        }
        if (annotated instanceof KtFunction) {
            for (KtParameter parameter : ((KtFunction)annotated).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                if (parameter.hasValOrVar()) continue;
                if ((VariableDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(parameterDescriptor, "trace.bindingContext[Bin\u2026R, parameter] ?: continue");
                KtParameter ktParameter = parameter;
                Intrinsics.checkNotNullExpressionValue(ktParameter, "parameter");
                this.checkDeclaration(trace, ktParameter, parameterDescriptor);
                if (parameter.getTypeReference() != null) {
                    KtTypeReference ktTypeReference;
                    boolean bl = false;
                    boolean bl5 = false;
                    KtTypeReference it = ktTypeReference;
                    boolean bl6 = false;
                    KtTypeReference ktTypeReference6 = it;
                    Intrinsics.checkNotNullExpressionValue(ktTypeReference6, "it");
                    INSTANCE.checkTypeReference(trace, ktTypeReference6, languageVersionSettings, false);
                }
            }
        }
    }

    private final void checkTypeReference(BindingTrace $this$checkTypeReference, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        this.checkAsTopLevelTypeReference($this$checkTypeReference, topLevelTypeReference, languageVersionSettings, isReceiver);
        topLevelTypeReference.acceptChildren(VisitorWrappersKt.typeReferenceRecursiveVisitor((Function1<? super KtTypeReference, Unit>)new Function1<KtTypeReference, Unit>($this$checkTypeReference, languageVersionSettings){
            final /* synthetic */ BindingTrace $this_checkTypeReference;
            final /* synthetic */ LanguageVersionSettings $languageVersionSettings;

            public final void invoke(@NotNull KtTypeReference typeReference) {
                Intrinsics.checkNotNullParameter(typeReference, "typeReference");
                AnnotationUseSiteTargetChecker.access$checkAsTopLevelTypeReference(AnnotationUseSiteTargetChecker.INSTANCE, this.$this_checkTypeReference, typeReference, this.$languageVersionSettings, false);
            }
            {
                this.$this_checkTypeReference = bindingTrace;
                this.$languageVersionSettings = languageVersionSettings;
                super(1);
            }
        }));
    }

    private final void checkAsTopLevelTypeReference(BindingTrace $this$checkAsTopLevelTypeReference, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        for (KtAnnotationEntry annotationEntry : topLevelTypeReference.getAnnotationEntries()) {
            ParametrizedDiagnostic<KtAnnotationEntry> diagnostic;
            Object object = annotationEntry.getUseSiteTarget();
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) {
                continue;
            }
            Object target = object;
            if (target == AnnotationUseSiteTarget.RECEIVER && isReceiver) continue;
            Intrinsics.checkNotNullExpressionValue(languageVersionSettings.supportsFeature(LanguageFeature.RestrictionOfWrongAnnotationsWithUseSiteTargetsOnTypes) ? Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotationEntry), "undefined target", ((AnnotationUseSiteTarget)((Object)target)).getRenderName()) : Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET_ON_TYPE.on((KtAnnotationEntry)((PsiElement)annotationEntry), ((AnnotationUseSiteTarget)((Object)target)).getRenderName()), "if (languageVersionSetti\u2026Entry, target.renderName)");
            diagnostic = diagnostic;
            DiagnosticUtilsKt.reportDiagnosticOnce($this$checkAsTopLevelTypeReference, diagnostic);
        }
    }

    private final void checkDeclaration(BindingTrace $this$checkDeclaration, KtAnnotated annotated, DeclarationDescriptor descriptor2) {
        Iterator<KtAnnotationEntry> iterator2 = annotated.getAnnotationEntries().iterator();
        block10: while (iterator2.hasNext()) {
            KtAnnotationEntry annotation2;
            KtAnnotationEntry ktAnnotationEntry = annotation2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(ktAnnotationEntry, "annotation");
            KtAnnotationUseSiteTarget useSiteTarget = ktAnnotationEntry.getUseSiteTarget();
            Object object = useSiteTarget;
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) {
                continue;
            }
            Object target = object;
            switch (AnnotationUseSiteTargetChecker$WhenMappings.$EnumSwitchMapping$0[((Enum)target).ordinal()]) {
                case 1: {
                    this.checkIfHasBackingField($this$checkDeclaration, annotated, descriptor2, annotation2);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    this.checkIfDelegatedProperty($this$checkDeclaration, annotated, annotation2);
                    break;
                }
                case 5: {
                    this.checkIfMutableProperty($this$checkDeclaration, annotated, annotation2);
                    break;
                }
                case 6: {
                    DeclarationDescriptor containingDeclaration;
                    if (!(annotated instanceof KtParameter)) {
                        $this$checkDeclaration.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    VariableDescriptor variableDescriptor = (VariableDescriptor)$this$checkDeclaration.getBindingContext().get(BindingContext.VALUE_PARAMETER, annotated);
                    DeclarationDescriptor declarationDescriptor = containingDeclaration = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                    if (!(containingDeclaration instanceof ConstructorDescriptor) || !((ConstructorDescriptor)containingDeclaration).isPrimary()) {
                        $this$checkDeclaration.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    if (((KtParameter)annotated).hasValOrVar()) continue block10;
                    $this$checkDeclaration.report(Errors.REDUNDANT_ANNOTATION_TARGET.on(annotation2, ((AnnotationUseSiteTarget)((Object)target)).getRenderName()));
                    break;
                }
                case 7: {
                    this.checkIfMutableProperty($this$checkDeclaration, annotated, annotation2);
                    break;
                }
                case 8: {
                    SimpleDiagnostic<KtAnnotationUseSiteTarget> simpleDiagnostic = Errors.INAPPLICABLE_FILE_TARGET.on((KtAnnotationUseSiteTarget)((PsiElement)useSiteTarget));
                    Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "INAPPLICABLE_FILE_TARGET.on(useSiteTarget)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($this$checkDeclaration, simpleDiagnostic);
                    break;
                }
                case 9: {
                    ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotation2), "declaration", ((AnnotationUseSiteTarget)((Object)target)).getRenderName());
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "WRONG_ANNOTATION_TARGET_\u2026tion\", target.renderName)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($this$checkDeclaration, parametrizedDiagnostic);
                    break;
                }
            }
        }
    }

    private final void checkIfDelegatedProperty(BindingTrace $this$checkIfDelegatedProperty, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && !((KtProperty)annotated).hasDelegate() || annotated instanceof KtParameter && ((KtParameter)annotated).hasValOrVar()) {
            $this$checkIfDelegatedProperty.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE.on(annotation2));
        }
    }

    private final void checkIfHasBackingField(BindingTrace $this$checkIfHasBackingField, KtAnnotated annotated, DeclarationDescriptor descriptor2, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && ((KtProperty)annotated).hasDelegate() && descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Boolean)$this$checkIfHasBackingField.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2), true) ^ true) {
            $this$checkIfHasBackingField.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD.on(annotation2));
        }
    }

    private final String useSiteDescription(KtAnnotationEntry $this$useSiteDescription) {
        Object object = $this$useSiteDescription.getUseSiteTarget();
        if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (object = ((AnnotationUseSiteTarget)((Object)object)).getRenderName()) == null) {
            object = "unknown target";
        }
        return object;
    }

    private final void checkIfMutableProperty(BindingTrace $this$checkIfMutableProperty, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isMutable;
        if (!this.checkIfProperty($this$checkIfMutableProperty, annotated, annotation2)) {
            return;
        }
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? ((KtProperty)annotated).isVar() : (isMutable = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).isMutable() : false);
        if (!isMutable) {
            $this$checkIfMutableProperty.report(Errors.INAPPLICABLE_TARGET_PROPERTY_IMMUTABLE.on(annotation2, this.useSiteDescription(annotation2)));
        }
    }

    private final boolean checkIfProperty(BindingTrace $this$checkIfProperty, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isProperty;
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? !((KtProperty)annotated).isLocal() : (isProperty = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).hasValOrVar() : false);
        if (!isProperty) {
            $this$checkIfProperty.report(Errors.INAPPLICABLE_TARGET_ON_PROPERTY.on(annotation2, this.useSiteDescription(annotation2)));
        }
        return isProperty;
    }

    private AnnotationUseSiteTargetChecker() {
    }

    static {
        AnnotationUseSiteTargetChecker annotationUseSiteTargetChecker;
        INSTANCE = annotationUseSiteTargetChecker = new AnnotationUseSiteTargetChecker();
    }

    public static final /* synthetic */ void access$checkAsTopLevelTypeReference(AnnotationUseSiteTargetChecker $this, BindingTrace $this$access_u24checkAsTopLevelTypeReference, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        $this.checkAsTopLevelTypeReference($this$access_u24checkAsTopLevelTypeReference, topLevelTypeReference, languageVersionSettings, isReceiver);
    }
}

