/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.protege.editor.core.ui.workspace.WorkspaceTabPlugin;
import org.protege.editor.core.ui.workspace.WorkspaceViewsTab;

public class CustomWorkspaceTabsManager {
    private List<String> customTabs;
    private static final String CUSTOM_TABS_PREFERENCES_KEY = "custom_tabs";
    private Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences("custom_tabs");

    public CustomWorkspaceTabsManager() {
        this.customTabs = this.prefs.getStringList(CUSTOM_TABS_PREFERENCES_KEY, new ArrayList<String>());
    }

    public List<String> getCustomTabs() {
        return Collections.unmodifiableList(this.customTabs);
    }

    public List<WorkspaceTabPlugin> getCustomTabPlugins(TabbedWorkspace workspace) {
        ArrayList<WorkspaceTabPlugin> tabPlugins = new ArrayList<WorkspaceTabPlugin>();
        for (String tab : this.customTabs) {
            tabPlugins.add(this.getPluginForTabName(tab, workspace));
        }
        return tabPlugins;
    }

    private void save() {
        this.prefs.putStringList(CUSTOM_TABS_PREFERENCES_KEY, this.customTabs);
    }

    public final WorkspaceTabPlugin getPluginForTabName(String name, TabbedWorkspace workspace) {
        if (!this.customTabs.contains(name)) {
            this.customTabs.add(name);
            this.save();
        }
        return this.createPlugin(name, workspace);
    }

    protected WorkspaceTabPlugin createPlugin(String name, TabbedWorkspace workspace) {
        return new CustomTabPlugin(name, workspace);
    }

    public void deleteCustomTab(String id) {
        this.customTabs.remove(id);
        this.save();
    }

    public boolean isCustomTab(String id) {
        return this.customTabs.contains(id);
    }

    protected class CustomTabPlugin
    implements WorkspaceTabPlugin {
        private TabbedWorkspace workspace;
        private String name;

        public CustomTabPlugin(String name, TabbedWorkspace workspace) {
            this.name = name;
            this.workspace = workspace;
        }

        @Override
        public URL getDefaultViewConfigFile() {
            return null;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getIndex() {
            return "Z";
        }

        @Override
        public String getLabel() {
            return this.name;
        }

        @Override
        public TabbedWorkspace getWorkspace() {
            return this.workspace;
        }

        @Override
        public String getDocumentation() {
            return "Custom tab: " + this.getLabel();
        }

        @Override
        public String getId() {
            return this.name;
        }

        @Override
        public WorkspaceTab newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            WorkspaceViewsTab tab = this.createCustomTab(this.name);
            tab.setup(this);
            return tab;
        }

        protected WorkspaceViewsTab createCustomTab(String label) {
            return new CustomTab(label);
        }

        private class CustomTab
        extends WorkspaceViewsTab {
            private static final long serialVersionUID = -4411850900268388198L;
            private String label;

            public CustomTab(String label) {
                this.label = label;
                this.setToolTipText("Drop views from the Views menu to create a custom view layout");
            }

            @Override
            public String getLabel() {
                return this.label;
            }

            @Override
            public String getId() {
                return this.label;
            }
        }
    }
}

