/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.io;

import com.mysql.cj.api.WarningListener;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.DataReadException;
import com.mysql.cj.core.io.DefaultValueFactory;
import java.time.LocalDate;

public class JdbcLocalDateValueFactory
extends DefaultValueFactory<LocalDate> {
    private WarningListener warningListener;

    public JdbcLocalDateValueFactory() {
    }

    public JdbcLocalDateValueFactory(WarningListener warningListener) {
        this();
        this.warningListener = warningListener;
    }

    @Override
    public LocalDate createFromDate(int year, int month, int day) {
        if (year == 0 && month == 0 && day == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDate.of(year, month, day);
    }

    @Override
    public LocalDate createFromTimestamp(int year, int month, int day, int hours, int minutes, int seconds, int nanos) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return this.createFromDate(year, month, day);
    }

    @Override
    public String getTargetTypeName() {
        return LocalDate.class.getName();
    }
}

