/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface BeanProperty<B, T>
extends AnnotatedElement,
AnnotationMetadataDelegate {
    @Nonnull
    public BeanIntrospection<B> getDeclaringBean();

    @Nullable
    public T get(@Nonnull B var1);

    @Nonnull
    default public <T2> Optional<T2> get(@Nonnull B bean, @Nonnull Class<T2> type) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", type);
        Argument<T2> argument = Argument.of(type);
        return this.get(bean, argument);
    }

    default public <T2> Optional<T2> get(@Nonnull B bean, @Nonnull Argument<T2> argument) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", argument);
        ArgumentConversionContext<T2> conversionContext = ConversionContext.of(argument);
        return this.get(bean, conversionContext);
    }

    default public <T2> Optional<T2> get(@Nonnull B bean, @Nonnull ArgumentConversionContext<T2> conversionContext) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("conversionContext", conversionContext);
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, conversionContext);
    }

    @Nullable
    default public <T2> T2 get(@Nonnull B bean, @Nonnull Class<T2> type, @Nullable T2 defaultValue) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (type == null) {
            return defaultValue;
        }
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, type).orElse(defaultValue);
    }

    default public void set(@Nonnull B bean, @Nullable T value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot write read-only property: " + this.getName());
        }
        throw new UnsupportedOperationException("Write method unimplemented for property: " + this.getName());
    }

    default public void convertAndSet(@Nonnull B bean, @Nullable Object value) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (value != null) {
            Argument<T> argument = this.asArgument();
            ArgumentConversionContext<T> context = ConversionContext.of(argument);
            T converted = ConversionService.SHARED.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + value + "] cannot be converted to type : " + this.getType()))));
            this.set(bean, converted);
        } else {
            this.set(bean, value);
        }
    }

    @Nonnull
    public Class<T> getType();

    default public Argument<T> asArgument() {
        return Argument.of(this.getType());
    }

    default public boolean isReadOnly() {
        return false;
    }

    default public boolean isWriteOnly() {
        return false;
    }

    default public boolean isReadWrite() {
        return !this.isReadOnly() && !this.isWriteOnly();
    }

    default public Class<B> getDeclaringType() {
        return this.getDeclaringBean().getBeanType();
    }
}

