/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.transaction;

import com.zaxxer.sansorm.transaction.TxDataSource;
import com.zaxxer.sansorm.transaction.TxThreadContext;
import com.zaxxer.sansorm.transaction.TxTransaction;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class TxTransactionManager
implements TransactionManager,
UserTransaction {
    private final DataSource dataSource;

    public TxTransactionManager(DataSource dataSource) {
        this.dataSource = TxDataSource.getWrappedDataSource(dataSource);
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        TxThreadContext context = TxThreadContext.getThreadContext();
        if (context.getTransaction() != null) {
            throw new NotSupportedException("Nested transactions not supported");
        }
        TxTransaction newTransaction = new TxTransaction();
        newTransaction.setActive();
        context.setTransaction(newTransaction);
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TxThreadContext threadContext = TxThreadContext.getThreadContext();
        TxTransaction currentTx = threadContext.getTransaction();
        if (currentTx == null) {
            throw new IllegalStateException("TransactionManager.commit() called from a thread that never joined a transaction");
        }
        threadContext.clearTransaction();
        currentTx.commit();
    }

    @Override
    public int getStatus() throws SystemException {
        TxTransaction transaction = TxThreadContext.getThreadContext().getTransaction();
        return transaction != null ? transaction.getStatus() : 6;
    }

    @Override
    public Transaction getTransaction() throws SystemException {
        return TxThreadContext.getThreadContext().getTransaction();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TxThreadContext threadContext = TxThreadContext.getThreadContext();
        TxTransaction currentTx = threadContext.getTransaction();
        if (currentTx == null) {
            throw new IllegalStateException("TransactionManager.rollback() called from a thread that never joined a transaction");
        }
        threadContext.clearTransaction();
        currentTx.rollback();
    }

    @Override
    public Transaction suspend() throws SystemException {
        throw new SystemException("suspend() operation is not supported");
    }

    @Override
    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        throw new SystemException("resume() operation is not supported");
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        throw new SystemException("setRollbackOnly() operation is not supported");
    }

    @Override
    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("setTransactionTimeout() operation is not supported");
    }

    public DataSource getTxDataSource() {
        return this.dataSource;
    }
}

