# -*- coding: utf-8 -*-
info = {
    "name": "te",
    "date_order": "DMY",
    "january": [
        "జనవరి",
        "జన"
    ],
    "february": [
        "ఫిబ్రవరి",
        "ఫిబ్ర"
    ],
    "march": [
        "మార్చి"
    ],
    "april": [
        "ఏప్రిల్",
        "ఏప్రి"
    ],
    "may": [
        "మే"
    ],
    "june": [
        "జూన్"
    ],
    "july": [
        "జులై"
    ],
    "august": [
        "ఆగస్టు",
        "ఆగ"
    ],
    "september": [
        "సెప్టెంబర్",
        "సెప్టెం"
    ],
    "october": [
        "అక్టోబర్",
        "అక్టో"
    ],
    "november": [
        "నవంబర్",
        "నవం"
    ],
    "december": [
        "డిసెంబర్",
        "డిసెం"
    ],
    "monday": [
        "సోమవారం",
        "సోమ"
    ],
    "tuesday": [
        "మంగళవారం",
        "మంగళ"
    ],
    "wednesday": [
        "బుధవారం",
        "బుధ"
    ],
    "thursday": [
        "గురువారం",
        "గురు"
    ],
    "friday": [
        "శుక్రవారం",
        "శుక్ర"
    ],
    "saturday": [
        "శనివారం",
        "శని"
    ],
    "sunday": [
        "ఆదివారం",
        "ఆది"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "సంవత్సరం",
        "సం"
    ],
    "month": [
        "నెల",
        "నె"
    ],
    "week": [
        "వారము",
        "వా"
    ],
    "day": [
        "దినం",
        "ది"
    ],
    "hour": [
        "గంట",
        "గం"
    ],
    "minute": [
        "నిమిషము",
        "నిమి",
        "ని"
    ],
    "second": [
        "సెకను",
        "సెక"
    ],
    "relative-type": {
        "1 year ago": [
            "గత సంవత్సరం"
        ],
        "0 year ago": [
            "ఈ సంవత్సరం"
        ],
        "in 1 year": [
            "తదుపరి సంవత్సరం"
        ],
        "1 month ago": [
            "గత నెల"
        ],
        "0 month ago": [
            "ఈ నెల"
        ],
        "in 1 month": [
            "తదుపరి నెల"
        ],
        "1 week ago": [
            "గత వారం"
        ],
        "0 week ago": [
            "ఈ వారం"
        ],
        "in 1 week": [
            "తదుపరి వారం"
        ],
        "1 day ago": [
            "నిన్న"
        ],
        "0 day ago": [
            "ఈ రోజు"
        ],
        "in 1 day": [
            "రేపు"
        ],
        "0 hour ago": [
            "ఈ గంట"
        ],
        "0 minute ago": [
            "ఈ నిమిషం"
        ],
        "0 second ago": [
            "ప్రస్తుతం"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) సంవత్సరంలో",
            "(\\d+) సంవత్సరాల్లో",
            "(\\d+) సంలో"
        ],
        "\\1 year ago": [
            "(\\d+) సంవత్సరం క్రితం",
            "(\\d+) సంవత్సరాల క్రితం",
            "(\\d+) సం క్రితం"
        ],
        "in \\1 month": [
            "(\\d+) నెలలో",
            "(\\d+) నెలల్లో"
        ],
        "\\1 month ago": [
            "(\\d+) నెల క్రితం",
            "(\\d+) నెలల క్రితం"
        ],
        "in \\1 week": [
            "(\\d+) వారంలో",
            "(\\d+) వారాల్లో"
        ],
        "\\1 week ago": [
            "(\\d+) వారం క్రితం",
            "(\\d+) వారాల క్రితం"
        ],
        "in \\1 day": [
            "(\\d+) రోజులో",
            "(\\d+) రోజుల్లో"
        ],
        "\\1 day ago": [
            "(\\d+) రోజు క్రితం",
            "(\\d+) రోజుల క్రితం"
        ],
        "in \\1 hour": [
            "(\\d+) గంటలో",
            "(\\d+) గంటల్లో",
            "(\\d+) గంలో"
        ],
        "\\1 hour ago": [
            "(\\d+) గంట క్రితం",
            "(\\d+) గంటల క్రితం",
            "(\\d+) గం క్రితం"
        ],
        "in \\1 minute": [
            "(\\d+) నిమిషంలో",
            "(\\d+) నిమిషాల్లో",
            "(\\d+) నిమిలో"
        ],
        "\\1 minute ago": [
            "(\\d+) నిమిషం క్రితం",
            "(\\d+) నిమిషాల క్రితం",
            "(\\d+) నిమి క్రితం"
        ],
        "in \\1 second": [
            "(\\d+) సెకనులో",
            "(\\d+) సెకన్లలో",
            "(\\d+) సెక లో"
        ],
        "\\1 second ago": [
            "(\\d+) సెకను క్రితం",
            "(\\d+) సెకన్ల క్రితం",
            "(\\d+) సెక క్రితం"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
