/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.JarFactory;
import org.apache.tomcat.util.scan.StandardJarScanFilter;

public class StandardJarScanner
implements JarScanner {
    private final Log log = LogFactory.getLog(StandardJarScanner.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");
    private static final Set<ClassLoader> CLASSLOADER_HIERARCHY;
    private boolean scanClassPath = true;
    private boolean scanManifest = true;
    private boolean scanAllFiles = false;
    private boolean scanAllDirectories = true;
    private boolean scanBootstrapClassPath = false;
    private JarScanFilter jarScanFilter = new StandardJarScanFilter();

    public boolean isScanClassPath() {
        return this.scanClassPath;
    }

    public void setScanClassPath(boolean bl) {
        this.scanClassPath = bl;
    }

    public boolean isScanManifest() {
        return this.scanManifest;
    }

    public void setScanManifest(boolean bl) {
        this.scanManifest = bl;
    }

    public boolean isScanAllFiles() {
        return this.scanAllFiles;
    }

    public void setScanAllFiles(boolean bl) {
        this.scanAllFiles = bl;
    }

    public boolean isScanAllDirectories() {
        return this.scanAllDirectories;
    }

    public void setScanAllDirectories(boolean bl) {
        this.scanAllDirectories = bl;
    }

    public boolean isScanBootstrapClassPath() {
        return this.scanBootstrapClassPath;
    }

    public void setScanBootstrapClassPath(boolean bl) {
        this.scanBootstrapClassPath = bl;
    }

    public JarScanFilter getJarScanFilter() {
        return this.jarScanFilter;
    }

    public void setJarScanFilter(JarScanFilter jarScanFilter) {
        this.jarScanFilter = jarScanFilter;
    }

    public void scan(JarScanType jarScanType, ServletContext servletContext, JarScannerCallback jarScannerCallback) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.webinflibStart"));
        }
        if (this.jarScanFilter instanceof StandardJarScanFilter && ((StandardJarScanFilter)this.jarScanFilter).isSkipAll()) {
            return;
        }
        HashSet<URL> hashSet = new HashSet<URL>();
        Set set = servletContext.getResourcePaths("/WEB-INF/lib/");
        if (set != null) {
            for (Object object : set) {
                if (((String)object).endsWith(".jar") && this.getJarScanFilter().check(jarScanType, ((String)object).substring(((String)object).lastIndexOf(47) + 1))) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sm.getString("jarScan.webinflibJarScan", new Object[]{object}));
                    }
                    URL uRL = null;
                    try {
                        uRL = servletContext.getResource((String)object);
                        hashSet.add(uRL);
                        this.process(jarScanType, jarScannerCallback, uRL, (String)object, true, null);
                    }
                    catch (IOException iOException) {
                        this.log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{uRL}), (Throwable)iOException);
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", new Object[]{object}));
            }
        }
        try {
            URL uRL = servletContext.getResource("/WEB-INF/classes");
            if (uRL != null) {
                Object object;
                hashSet.add(uRL);
                if (this.isScanAllDirectories() && (object = servletContext.getResource("/WEB-INF/classes/META-INF")) != null) {
                    try {
                        jarScannerCallback.scanWebInfClasses();
                    }
                    catch (IOException iOException) {
                        this.log.warn((Object)sm.getString("jarScan.webinfclassesFail"), (Throwable)iOException);
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.isScanClassPath()) {
            this.doScanClassPath(jarScanType, servletContext, jarScannerCallback, hashSet);
        }
    }

    protected void doScanClassPath(JarScanType jarScanType, ServletContext servletContext, JarScannerCallback jarScannerCallback, Set<URL> set) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.classloaderStart"));
        }
        ClassLoader classLoader = null;
        if (!this.isScanBootstrapClassPath()) {
            classLoader = ClassLoader.getSystemClassLoader().getParent();
        }
        boolean bl = true;
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (ClassLoader classLoader2 = servletContext.getClassLoader(); classLoader2 != null && classLoader2 != classLoader; classLoader2 = classLoader2.getParent()) {
            if (!(classLoader2 instanceof URLClassLoader)) continue;
            if (bl) {
                bl = StandardJarScanner.isWebappClassLoader(classLoader2);
            }
            linkedList.addAll(Arrays.asList(((URLClassLoader)classLoader2).getURLs()));
            this.processURLs(jarScanType, jarScannerCallback, set, bl, linkedList);
        }
        if (JreCompat.isJre9Available()) {
            this.addClassPath(linkedList);
            JreCompat.getInstance().addBootModulePath(linkedList);
            this.processURLs(jarScanType, jarScannerCallback, set, false, linkedList);
        }
    }

    protected void processURLs(JarScanType jarScanType, JarScannerCallback jarScannerCallback, Set<URL> set, boolean bl, Deque<URL> deque) {
        if (this.jarScanFilter instanceof StandardJarScanFilter && ((StandardJarScanFilter)this.jarScanFilter).isSkipAll()) {
            return;
        }
        while (!deque.isEmpty()) {
            URL uRL = deque.pop();
            if (set.contains(uRL)) continue;
            ClassPathEntry classPathEntry = new ClassPathEntry(uRL);
            if ((classPathEntry.isJar() || jarScanType == JarScanType.PLUGGABILITY || this.isScanAllDirectories()) && this.getJarScanFilter().check(jarScanType, classPathEntry.getName())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("jarScan.classloaderJarScan", new Object[]{uRL}));
                }
                try {
                    set.add(uRL);
                    this.process(jarScanType, jarScannerCallback, uRL, null, bl, deque);
                }
                catch (IOException iOException) {
                    this.log.warn((Object)sm.getString("jarScan.classloaderFail", new Object[]{uRL}), (Throwable)iOException);
                }
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)sm.getString("jarScan.classloaderJarNoScan", new Object[]{uRL}));
        }
    }

    protected void addClassPath(Deque<URL> deque) {
        String[] stringArray;
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return;
        }
        for (String string2 : stringArray = string.split(File.pathSeparator)) {
            File file = new File(string2);
            try {
                deque.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.log.warn((Object)sm.getString("jarScan.classPath.badEntry", new Object[]{string2}), (Throwable)malformedURLException);
            }
        }
    }

    private static boolean isWebappClassLoader(ClassLoader classLoader) {
        return !CLASSLOADER_HIERARCHY.contains(classLoader);
    }

    protected void process(JarScanType jarScanType, JarScannerCallback jarScannerCallback, URL uRL, String string, boolean bl, Deque<URL> deque) throws IOException {
        block36: {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)sm.getString("jarScan.jarUrlStart", new Object[]{uRL}));
            }
            if ("jar".equals(uRL.getProtocol()) || uRL.getPath().endsWith(".jar")) {
                try (Jar jar = JarFactory.newInstance(uRL);){
                    if (this.isScanManifest()) {
                        this.processManifest(jar, bl, deque);
                    }
                    jarScannerCallback.scan(jar, string, bl);
                }
            }
            if ("file".equals(uRL.getProtocol())) {
                try {
                    File file = new File(uRL.toURI());
                    if (file.isFile() && this.isScanAllFiles()) {
                        URL uRL2 = UriUtil.buildJarUrl((File)file);
                        try (Jar jar = JarFactory.newInstance(uRL2);){
                            if (this.isScanManifest()) {
                                this.processManifest(jar, bl, deque);
                            }
                            jarScannerCallback.scan(jar, string, bl);
                            break block36;
                        }
                    }
                    if (file.isDirectory()) {
                        if (jarScanType == JarScanType.PLUGGABILITY) {
                            jarScannerCallback.scan(file, string, bl);
                        } else {
                            File file2 = new File(file.getAbsoluteFile() + File.separator + "META-INF");
                            if (file2.isDirectory()) {
                                jarScannerCallback.scan(file, string, bl);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    IOException iOException = new IOException();
                    iOException.initCause(throwable);
                    throw iOException;
                }
            }
        }
    }

    private void processManifest(Jar jar, boolean bl, Deque<URL> deque) throws IOException {
        if (bl || deque == null) {
            return;
        }
        Manifest manifest = jar.getManifest();
        if (manifest != null) {
            String[] stringArray;
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue("Class-Path");
            if (string == null) {
                return;
            }
            for (String string2 : stringArray = string.split(" ")) {
                URL uRL;
                if ((string2 = string2.trim()).length() == 0) continue;
                URL uRL2 = jar.getJarFileURL();
                try {
                    URI uRI = uRL2.toURI();
                    URI uRI2 = uRI.resolve(string2);
                    uRL = uRI2.toURL();
                }
                catch (Exception exception) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)sm.getString("jarScan.invalidUri", new Object[]{uRL2}), (Throwable)exception);
                    continue;
                }
                deque.add(uRL);
            }
        }
    }

    static {
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>();
        for (ClassLoader classLoader = StandardJarScanner.class.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            hashSet.add(classLoader);
        }
        CLASSLOADER_HIERARCHY = Collections.unmodifiableSet(hashSet);
    }

    private static class ClassPathEntry {
        private final boolean jar;
        private final String name;

        public ClassPathEntry(URL uRL) {
            String string = uRL.getPath();
            int n = string.lastIndexOf(".jar");
            if (n != -1) {
                this.jar = true;
                int n2 = string.lastIndexOf(47, n);
                this.name = string.substring(n2 + 1, n + 4);
            } else {
                this.jar = false;
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                int n3 = string.lastIndexOf(47);
                this.name = string.substring(n3 + 1);
            }
        }

        public boolean isJar() {
            return this.jar;
        }

        public String getName() {
            return this.name;
        }
    }
}

