/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.catalina.ssi.SSIConditionalState;
import org.apache.catalina.ssi.SSIExternalResolver;
import org.apache.catalina.util.Strftime;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.http.HttpMessages;

public class SSIMediator {
    protected static final String ENCODING_NONE = "none";
    protected static final String ENCODING_ENTITY = "entity";
    protected static final String ENCODING_URL = "url";
    protected static final String DEFAULT_CONFIG_ERR_MSG = "[an error occurred while processing this directive]";
    protected static final String DEFAULT_CONFIG_TIME_FMT = "%A, %d-%b-%Y %T %Z";
    protected static final String DEFAULT_CONFIG_SIZE_FMT = "abbrev";
    protected String configErrMsg = "[an error occurred while processing this directive]";
    protected String configTimeFmt = "%A, %d-%b-%Y %T %Z";
    protected String configSizeFmt = "abbrev";
    protected String className = this.getClass().getName();
    protected SSIExternalResolver ssiExternalResolver;
    protected long lastModifiedDate;
    protected int debug;
    protected Strftime strftime;
    protected SSIConditionalState conditionalState = new SSIConditionalState();

    public SSIMediator(SSIExternalResolver sSIExternalResolver, long l, int n) {
        this.ssiExternalResolver = sSIExternalResolver;
        this.lastModifiedDate = l;
        this.debug = n;
        this.setConfigTimeFmt(DEFAULT_CONFIG_TIME_FMT, true);
    }

    public void setConfigErrMsg(String string) {
        this.configErrMsg = string;
    }

    public void setConfigTimeFmt(String string) {
        this.setConfigTimeFmt(string, false);
    }

    public void setConfigTimeFmt(String string, boolean bl) {
        this.configTimeFmt = string;
        this.strftime = new Strftime(string, Locale.US);
        this.setDateVariables(bl);
    }

    public void setConfigSizeFmt(String string) {
        this.configSizeFmt = string;
    }

    public String getConfigErrMsg() {
        return this.configErrMsg;
    }

    public String getConfigTimeFmt() {
        return this.configTimeFmt;
    }

    public String getConfigSizeFmt() {
        return this.configSizeFmt;
    }

    public SSIConditionalState getConditionalState() {
        return this.conditionalState;
    }

    public Collection<String> getVariableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("DATE_GMT");
        hashSet.add("DATE_LOCAL");
        hashSet.add("LAST_MODIFIED");
        this.ssiExternalResolver.addVariableNames(hashSet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.isNameReserved(string)) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public long getFileSize(String string, boolean bl) throws IOException {
        return this.ssiExternalResolver.getFileSize(string, bl);
    }

    public long getFileLastModified(String string, boolean bl) throws IOException {
        return this.ssiExternalResolver.getFileLastModified(string, bl);
    }

    public String getFileText(String string, boolean bl) throws IOException {
        return this.ssiExternalResolver.getFileText(string, bl);
    }

    protected boolean isNameReserved(String string) {
        return string.startsWith(this.className + ".");
    }

    public String getVariableValue(String string) {
        return this.getVariableValue(string, ENCODING_NONE);
    }

    public void setVariableValue(String string, String string2) {
        if (!this.isNameReserved(string)) {
            this.ssiExternalResolver.setVariableValue(string, string2);
        }
    }

    public String getVariableValue(String string, String string2) {
        String string3 = string.toLowerCase(Locale.ENGLISH);
        String string4 = null;
        if (!this.isNameReserved(string3)) {
            string4 = this.ssiExternalResolver.getVariableValue(string);
            if (string4 == null) {
                string = string.toUpperCase(Locale.ENGLISH);
                string4 = this.ssiExternalResolver.getVariableValue(this.className + "." + string);
            }
            if (string4 != null) {
                string4 = this.encode(string4, string2);
            }
        }
        return string4;
    }

    public String substituteVariables(String string) {
        int n;
        int n2;
        if (string.indexOf(36) < 0 && string.indexOf(38) < 0) {
            return string;
        }
        string = string.replace("&lt;", "<");
        string = string.replace("&gt;", ">");
        string = string.replace("&quot;", "\"");
        string = string.replace("&amp;", "&");
        StringBuilder stringBuilder = new StringBuilder(string);
        int n3 = stringBuilder.indexOf("&#");
        while (n3 > -1 && (n2 = stringBuilder.indexOf(";", n3)) > -1) {
            n = Integer.parseInt(stringBuilder.substring(n3 + 2, n2));
            stringBuilder.delete(n3, n2 + 1);
            stringBuilder.insert(n3, (char)n);
            n3 = stringBuilder.indexOf("&#");
        }
        n2 = 0;
        while (n2 < stringBuilder.length()) {
            String string2;
            String string3;
            while (n2 < stringBuilder.length()) {
                if (stringBuilder.charAt(n2) == '$') {
                    ++n2;
                    break;
                }
                ++n2;
            }
            if (n2 == stringBuilder.length()) break;
            if (n2 > 1 && stringBuilder.charAt(n2 - 2) == '\\') {
                stringBuilder.deleteCharAt(n2 - 2);
                --n2;
                continue;
            }
            n = n2;
            int n4 = n2 - 1;
            int n5 = -1;
            int n6 = -1;
            char c = ' ';
            if (stringBuilder.charAt(n2) == '{') {
                ++n;
                c = '}';
            }
            while (n2 < stringBuilder.length() && stringBuilder.charAt(n2) != c) {
                ++n2;
            }
            n5 = n2;
            n6 = n5++;
            if (c == '}') {
                // empty if block
            }
            if ((string3 = this.getVariableValue(string2 = stringBuilder.substring(n, n6))) == null) {
                string3 = "";
            }
            stringBuilder.replace(n4, n5, string3);
            n2 = n4 + string3.length();
        }
        return stringBuilder.toString();
    }

    protected String formatDate(Date date, TimeZone timeZone) {
        String string;
        if (timeZone != null) {
            TimeZone timeZone2 = this.strftime.getTimeZone();
            this.strftime.setTimeZone(timeZone);
            string = this.strftime.format(date);
            this.strftime.setTimeZone(timeZone2);
        } else {
            string = this.strftime.format(date);
        }
        return string;
    }

    protected String encode(String string, String string2) {
        String string3 = null;
        if (string2.equalsIgnoreCase(ENCODING_URL)) {
            string3 = URLEncoder.DEFAULT.encode(string, "UTF-8");
        } else if (string2.equalsIgnoreCase(ENCODING_NONE)) {
            string3 = string;
        } else if (string2.equalsIgnoreCase(ENCODING_ENTITY)) {
            string3 = HttpMessages.filter((String)string);
        } else {
            throw new IllegalArgumentException("Unknown encoding: " + string2);
        }
        return string3;
    }

    public void log(String string) {
        this.ssiExternalResolver.log(string, null);
    }

    public void log(String string, Throwable throwable) {
        this.ssiExternalResolver.log(string, throwable);
    }

    protected void setDateVariables(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.ssiExternalResolver.getVariableValue(this.className + ".alreadyset") != null;
        if (!bl || !bl2) {
            this.ssiExternalResolver.setVariableValue(this.className + ".alreadyset", "true");
            Date date = new Date();
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            String string = this.formatDate(date, timeZone);
            this.setVariableValue("DATE_GMT", null);
            this.ssiExternalResolver.setVariableValue(this.className + ".DATE_GMT", string);
            string = this.formatDate(date, null);
            this.setVariableValue("DATE_LOCAL", null);
            this.ssiExternalResolver.setVariableValue(this.className + ".DATE_LOCAL", string);
            string = this.formatDate(new Date(this.lastModifiedDate), null);
            this.setVariableValue("LAST_MODIFIED", null);
            this.ssiExternalResolver.setVariableValue(this.className + ".LAST_MODIFIED", string);
        }
    }
}

