/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Deque;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.jar.JarFile;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Resource;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import org.apache.tomcat.util.compat.Jre7Compat;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final int RUNTIME_MAJOR_VERSION = 6;
    private static final JreCompat instance;
    private static StringManager sm;
    private static final boolean jre9Available;
    private static final boolean jre8Available;
    private static final boolean jre7Available;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isJre7Available() {
        return jre7Available;
    }

    public Locale forLanguageTag(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(45);
        if (n < 0) {
            string2 = string;
            string3 = "";
            string4 = "";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            int n2 = string3.indexOf(45);
            if (n2 > 0) {
                String string5 = string3.substring(0, n2);
                string4 = string3.substring(n2 + 1);
                string3 = string5;
            } else {
                string4 = "";
            }
        }
        if (!(JreCompat.isAlpha(string2) && JreCompat.isAlpha(string3) && JreCompat.isAlpha(string4))) {
            return null;
        }
        return new Locale(string2, string3, string4);
    }

    private static final boolean isAlpha(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public GZIPOutputStream getFlushableGZipOutputStream(OutputStream outputStream) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noFlushableGzipOutputStream"));
    }

    public <T> T getObject(CallableStatement callableStatement, int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public <T> T getObject(CallableStatement callableStatement, String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setSchema(Connection connection, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getSchema(Connection connection) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void abort(Connection connection, Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNetworkTimeout(Connection connection, Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public int getNetworkTimeout(Connection connection) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public ResultSet getPseudoColumns(DatabaseMetaData databaseMetaData, String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean generatedKeyAlwaysReturned(DatabaseMetaData databaseMetaData) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public <T> T getObject(ResultSet resultSet, int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public <T> T getObject(ResultSet resultSet, String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void closeOnCompletion(Statement statement) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean isCloseOnCompletion(Statement statement) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public InetAddress getLoopbackAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress == null) {
            try {
                inetAddress = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return inetAddress;
    }

    public static boolean isJre8Available() {
        return jre8Available;
    }

    public void setUseServerCipherSuitesOrder(SSLServerSocket sSLServerSocket, boolean bl) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public void setUseServerCipherSuitesOrder(SSLEngine sSLEngine, boolean bl) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public static boolean isJre9Available() {
        return jre9Available;
    }

    public boolean isInstanceOfInaccessibleObjectException(Throwable throwable) {
        return false;
    }

    public void disableCachingForJarUrlConnections() throws IOException {
        URL uRL = new URL("jar:file://dummy.jar!/");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDefaultUseCaches(false);
    }

    public void addBootModulePath(Deque<URL> deque) {
    }

    public JarFile jarFileNewInstance(File file) throws IOException {
        return new JarFile(file);
    }

    public boolean jarFileIsMultiRelease(JarFile jarFile) {
        return false;
    }

    public int jarFileRuntimeMajorVersion() {
        return 6;
    }

    public boolean isCommonsAnnotations1_1Available() {
        Method[] methodArray;
        Class<Resource> clazz = Resource.class;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            if (!method.getName().equals("lookup")) continue;
            return true;
        }
        return false;
    }

    public boolean canAcccess(Object object, AccessibleObject accessibleObject) {
        return true;
    }

    public boolean isExported(Class<?> clazz) {
        return true;
    }

    static {
        sm = StringManager.getManager(JreCompat.class.getPackage().getName());
        if (Jre9Compat.isSupported()) {
            instance = new Jre9Compat();
            jre9Available = true;
            jre8Available = true;
            jre7Available = true;
        } else if (Jre8Compat.isSupported()) {
            instance = new Jre8Compat();
            jre9Available = false;
            jre8Available = true;
            jre7Available = true;
        } else if (Jre7Compat.isSupported()) {
            instance = new Jre7Compat();
            jre9Available = false;
            jre8Available = false;
            jre7Available = true;
        } else {
            instance = new JreCompat();
            jre9Available = false;
            jre8Available = false;
            jre7Available = false;
        }
    }
}

