/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.property;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.OWLObjectPropertyHierarchyProvider;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferredObjectPropertyHierarchyProvider
extends OWLObjectPropertyHierarchyProvider {
    private final OWLModelManagerListener listener;
    private OWLModelManager mngr;
    private static final Logger logger = LoggerFactory.getLogger(InferredObjectPropertyHierarchyProvider.class);
    public static final String ID = "inferredObjectPropertyHierarchyProvider";

    public InferredObjectPropertyHierarchyProvider(OWLModelManager mngr) {
        super(mngr.getOWLOntologyManager());
        this.mngr = mngr;
        this.listener = e -> {
            if (e.isType(EventType.REASONER_CHANGED) || e.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || e.isType(EventType.ONTOLOGY_CLASSIFIED) || e.isType(EventType.ONTOLOGY_RELOADED)) {
                this.fireHierarchyChanged();
            }
        };
        mngr.addListener(this.listener);
    }

    protected OWLReasoner getReasoner() {
        return this.mngr.getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public Set<OWLObjectProperty> getUnfilteredChildren(OWLObjectProperty objectProperty) {
        try {
            if (!this.getReasoner().isConsistent()) {
                return Collections.emptySet();
            }
            Set subs = this.getReasoner().getSubObjectProperties((OWLObjectPropertyExpression)objectProperty, true).getFlattened();
            subs.remove(objectProperty);
            subs.remove(this.mngr.getOWLDataFactory().getOWLBottomObjectProperty());
            HashSet<OWLObjectProperty> children = new HashSet<OWLObjectProperty>();
            for (OWLObjectPropertyExpression p : subs) {
                if (!(p instanceof OWLObjectProperty)) continue;
                children.add((OWLObjectProperty)p);
            }
            return children;
        }
        catch (Exception e) {
            logger.error("An error occurred whilst asking the reasoner for the sub-properties of an object property: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<OWLObjectProperty> getParents(OWLObjectProperty objectProperty) {
        try {
            if (!this.getReasoner().isConsistent()) {
                return Collections.emptySet();
            }
            Set supers = this.getReasoner().getSuperObjectProperties((OWLObjectPropertyExpression)objectProperty, true).getFlattened();
            supers.remove(objectProperty);
            HashSet<OWLObjectProperty> parents = new HashSet<OWLObjectProperty>();
            for (OWLObjectPropertyExpression p : supers) {
                if (!(p instanceof OWLObjectProperty)) continue;
                parents.add((OWLObjectProperty)p);
            }
            return parents;
        }
        catch (Exception e) {
            logger.error("An error occurred whilst asking the reasoner for the super-properties of an object property: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<OWLObjectProperty> getEquivalents(OWLObjectProperty objectProperty) {
        try {
            if (!this.getReasoner().isConsistent()) {
                return Collections.emptySet();
            }
            Set equivs = this.getReasoner().getEquivalentObjectProperties((OWLObjectPropertyExpression)objectProperty).getEntities();
            equivs.remove(objectProperty);
            HashSet<OWLObjectProperty> ret = new HashSet<OWLObjectProperty>();
            for (OWLObjectPropertyExpression p : equivs) {
                if (!(p instanceof OWLObjectProperty)) continue;
                ret.add((OWLObjectProperty)p);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("An error occurred whilst asking the reasoner for the equivalent-properties of an object property: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptySet();
        }
    }

    @Override
    public void dispose() {
        this.mngr.removeListener(this.listener);
        super.dispose();
    }
}

