/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.ConfigRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class OpenSshConfig
implements ConfigRepository {
    static final int SSH_PORT = 22;
    private final File home;
    private final File configFile;
    private long lastModified;
    private State state;

    public static OpenSshConfig get(FS fs) {
        File home = fs.userHome();
        if (home == null) {
            home = new File(".").getAbsoluteFile();
        }
        File config = new File(new File(home, ".ssh"), "config");
        OpenSshConfig osc = new OpenSshConfig(home, config);
        osc.refresh();
        return osc;
    }

    OpenSshConfig(File h2, File cfg) {
        this.home = h2;
        this.configFile = cfg;
        this.state = new State();
    }

    public Host lookup(String hostName) {
        State cache = this.refresh();
        Host h2 = cache.hosts.get(hostName);
        if (h2 != null) {
            return h2;
        }
        HostEntry fullConfig = new HostEntry();
        fullConfig.merge(cache.entries.get(""));
        for (Map.Entry<String, HostEntry> e2 : cache.entries.entrySet()) {
            String key2 = e2.getKey();
            if (!OpenSshConfig.isHostMatch(key2, hostName)) continue;
            fullConfig.merge(e2.getValue());
        }
        fullConfig.substitute(hostName, this.home);
        h2 = new Host(fullConfig, hostName, this.home);
        cache.hosts.put(hostName, h2);
        return h2;
    }

    private synchronized State refresh() {
        long mtime = this.configFile.lastModified();
        if (mtime != this.lastModified) {
            State newState = new State();
            try (FileInputStream in = new FileInputStream(this.configFile);){
                newState.entries = this.parse(in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lastModified = mtime;
            this.state = newState;
        }
        return this.state;
    }

    private Map<String, HostEntry> parse(InputStream in) throws IOException {
        String line;
        LinkedHashMap<String, HostEntry> m3 = new LinkedHashMap<String, HostEntry>();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ArrayList<HostEntry> current = new ArrayList<HostEntry>(4);
        HostEntry defaults = new HostEntry();
        current.add(defaults);
        m3.put("", defaults);
        while ((line = br.readLine()) != null) {
            String argValue;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split("[ \t]*[= \t]", 2);
            String keyword2 = OpenSshConfig.dequote(parts[0].trim());
            String string2 = argValue = parts.length > 1 ? parts[1].trim() : "";
            if (StringUtils.equalsIgnoreCase("Host", keyword2)) {
                current.clear();
                for (String string3 : HostEntry.parseList(argValue)) {
                    if (string3 == null || string3.isEmpty()) continue;
                    HostEntry c = (HostEntry)m3.get(string3);
                    if (c == null) {
                        c = new HostEntry();
                        m3.put(string3, c);
                    }
                    current.add(c);
                }
                continue;
            }
            if (current.isEmpty()) continue;
            if (HostEntry.isListKey(keyword2)) {
                List<String> args = HostEntry.parseList(argValue);
                for (HostEntry entry : current) {
                    entry.setValue(keyword2, args);
                }
                continue;
            }
            if (argValue.isEmpty()) continue;
            argValue = OpenSshConfig.dequote(argValue);
            for (HostEntry hostEntry : current) {
                hostEntry.setValue(keyword2, argValue);
            }
        }
        return m3;
    }

    private static boolean isHostMatch(String pattern, String name2) {
        if (pattern.startsWith("!")) {
            return !OpenSshConfig.patternMatchesHost(pattern.substring(1), name2);
        }
        return OpenSshConfig.patternMatchesHost(pattern, name2);
    }

    private static boolean patternMatchesHost(String pattern, String name2) {
        if (pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0) {
            FileNameMatcher fn2;
            try {
                fn2 = new FileNameMatcher(pattern, null);
            }
            catch (InvalidPatternException e2) {
                return false;
            }
            fn2.append(name2);
            return fn2.isMatch();
        }
        return pattern.equals(name2);
    }

    private static String dequote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static String nows(String value) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isSpaceChar(value.charAt(i))) continue;
            b.append(value.charAt(i));
        }
        return b.toString();
    }

    private static Boolean yesno(String value) {
        if (StringUtils.equalsIgnoreCase("yes", value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static File toFile(String path2, File home) {
        if (path2.startsWith("~/")) {
            return new File(home, path2.substring(2));
        }
        File ret = new File(path2);
        if (ret.isAbsolute()) {
            return ret;
        }
        return new File(home, path2);
    }

    private static int positive(String value) {
        if (value != null) {
            try {
                return Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    static String userName() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SystemReader.getInstance().getProperty("user.name");
            }
        });
    }

    @Override
    public ConfigRepository.Config getConfig(String hostName) {
        Host host = this.lookup(hostName);
        return new JschBugFixingConfig(host.getConfig());
    }

    public String toString() {
        return "OpenSshConfig [home=" + this.home + ", configFile=" + this.configFile + ", lastModified=" + this.lastModified + ", state=" + this.state + "]";
    }

    public static class Host {
        String hostName;
        int port;
        File identityFile;
        String user;
        String preferredAuthentications;
        Boolean batchMode;
        String strictHostKeyChecking;
        int connectionAttempts;
        private ConfigRepository.Config config;

        public Host() {
        }

        Host(ConfigRepository.Config config, String hostName, File homeDir) {
            this.config = config;
            this.complete(hostName, homeDir);
        }

        public String getStrictHostKeyChecking() {
            return this.strictHostKeyChecking;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public File getIdentityFile() {
            return this.identityFile;
        }

        public String getUser() {
            return this.user;
        }

        public String getPreferredAuthentications() {
            return this.preferredAuthentications;
        }

        public boolean isBatchMode() {
            return this.batchMode != null && this.batchMode != false;
        }

        public int getConnectionAttempts() {
            return this.connectionAttempts;
        }

        private void complete(String initialHostName, File homeDir) {
            String[] identityFiles;
            this.hostName = this.config.getHostname();
            this.user = this.config.getUser();
            this.port = this.config.getPort();
            this.connectionAttempts = OpenSshConfig.positive(this.config.getValue("ConnectionAttempts"));
            this.strictHostKeyChecking = this.config.getValue("StrictHostKeyChecking");
            String value = this.config.getValue("BatchMode");
            if (value != null) {
                this.batchMode = OpenSshConfig.yesno(value);
            }
            if ((value = this.config.getValue("PreferredAuthentications")) != null) {
                this.preferredAuthentications = OpenSshConfig.nows(value);
            }
            if (this.hostName == null) {
                this.hostName = initialHostName;
            }
            if (this.user == null) {
                this.user = OpenSshConfig.userName();
            }
            if (this.port <= 0) {
                this.port = 22;
            }
            if (this.connectionAttempts <= 0) {
                this.connectionAttempts = 1;
            }
            if ((identityFiles = this.config.getValues("IdentityFile")) != null && identityFiles.length > 0) {
                this.identityFile = OpenSshConfig.toFile(identityFiles[0], homeDir);
            }
        }

        ConfigRepository.Config getConfig() {
            return this.config;
        }

        public String toString() {
            return "Host [hostName=" + this.hostName + ", port=" + this.port + ", identityFile=" + this.identityFile + ", user=" + this.user + ", preferredAuthentications=" + this.preferredAuthentications + ", batchMode=" + this.batchMode + ", strictHostKeyChecking=" + this.strictHostKeyChecking + ", connectionAttempts=" + this.connectionAttempts + ", config=" + this.config + "]";
        }
    }

    private static class HostEntry
    implements ConfigRepository.Config {
        public static final String DEFAULT_NAME = "";
        private static final Map<String, String> KEY_MAP = new HashMap<String, String>();
        private static final Set<String> MULTI_KEYS;
        private static final Set<String> LIST_KEYS;
        private Map<String, String> options;
        private Map<String, List<String>> multiOptions;
        private Map<String, List<String>> listOptions;

        private HostEntry() {
        }

        @Override
        public String getHostname() {
            return this.getValue("HOSTNAME");
        }

        @Override
        public String getUser() {
            return this.getValue("USER");
        }

        @Override
        public int getPort() {
            return OpenSshConfig.positive(this.getValue("PORT"));
        }

        private static String mapKey(String key2) {
            String k = KEY_MAP.get(key2);
            if (k == null) {
                k = key2;
            }
            return k.toUpperCase(Locale.ROOT);
        }

        private String findValue(String key2) {
            String result;
            String k = HostEntry.mapKey(key2);
            String string2 = result = this.options != null ? this.options.get(k) : null;
            if (result == null) {
                List<String> values;
                List<String> list = values = this.listOptions != null ? this.listOptions.get(k) : null;
                if (values == null) {
                    List<String> list2 = values = this.multiOptions != null ? this.multiOptions.get(k) : null;
                }
                if (values != null && !values.isEmpty()) {
                    result = values.get(0);
                }
            }
            return result;
        }

        @Override
        public String getValue(String key2) {
            if (key2.equals("compression.s2c") || key2.equals("compression.c2s")) {
                String foo = this.findValue(key2);
                if (foo == null || foo.equals("no")) {
                    return "none,zlib@openssh.com,zlib";
                }
                return "zlib@openssh.com,zlib,none";
            }
            return this.findValue(key2);
        }

        @Override
        public String[] getValues(String key2) {
            List<String> values;
            String k = HostEntry.mapKey(key2);
            List<String> list = values = this.listOptions != null ? this.listOptions.get(k) : null;
            if (values == null) {
                List<String> list2 = values = this.multiOptions != null ? this.multiOptions.get(k) : null;
            }
            if (values == null || values.isEmpty()) {
                return new String[0];
            }
            return values.toArray(new String[values.size()]);
        }

        public void setValue(String key2, String value) {
            String k = key2.toUpperCase(Locale.ROOT);
            if (MULTI_KEYS.contains(k)) {
                List<String> values;
                if (this.multiOptions == null) {
                    this.multiOptions = new HashMap<String, List<String>>();
                }
                if ((values = this.multiOptions.get(k)) == null) {
                    values = new ArrayList<String>(4);
                    this.multiOptions.put(k, values);
                }
                values.add(value);
            } else {
                if (this.options == null) {
                    this.options = new HashMap<String, String>();
                }
                if (!this.options.containsKey(k)) {
                    this.options.put(k, value);
                }
            }
        }

        public void setValue(String key2, List<String> values) {
            if (values.isEmpty()) {
                return;
            }
            String k = key2.toUpperCase(Locale.ROOT);
            if (MULTI_KEYS.contains(k)) {
                List<String> items;
                if (this.multiOptions == null) {
                    this.multiOptions = new HashMap<String, List<String>>(2 * MULTI_KEYS.size());
                }
                if ((items = this.multiOptions.get(k)) == null) {
                    items = new ArrayList<String>(values);
                    this.multiOptions.put(k, items);
                } else {
                    items.addAll(values);
                }
            } else {
                if (this.listOptions == null) {
                    this.listOptions = new HashMap<String, List<String>>(2 * LIST_KEYS.size());
                }
                if (!this.listOptions.containsKey(k)) {
                    this.listOptions.put(k, values);
                }
            }
        }

        public static boolean isListKey(String key2) {
            return LIST_KEYS.contains(key2.toUpperCase(Locale.ROOT));
        }

        public static List<String> parseList(String argument) {
            ArrayList<String> result = new ArrayList<String>(4);
            int start = 0;
            int length = argument.length();
            while (start < length) {
                int stop;
                if (Character.isSpaceChar(argument.charAt(start))) {
                    ++start;
                    continue;
                }
                if (argument.charAt(start) == '\"') {
                    if ((stop = argument.indexOf(34, ++start)) < start) break;
                    result.add(argument.substring(start, stop));
                    start = stop + 1;
                    continue;
                }
                for (stop = start + 1; stop < length && !Character.isSpaceChar(argument.charAt(stop)); ++stop) {
                }
                result.add(argument.substring(start, stop));
                start = stop + 1;
            }
            return result;
        }

        protected void merge(HostEntry entry) {
            if (entry == null) {
                return;
            }
            if (entry.options != null) {
                if (this.options == null) {
                    this.options = new HashMap<String, String>();
                }
                for (Map.Entry<String, Object> entry2 : entry.options.entrySet()) {
                    if (this.options.containsKey(entry2.getKey())) continue;
                    this.options.put(entry2.getKey(), (String)entry2.getValue());
                }
            }
            if (entry.listOptions != null) {
                if (this.listOptions == null) {
                    this.listOptions = new HashMap<String, List<String>>(2 * LIST_KEYS.size());
                }
                for (Map.Entry<String, Object> entry3 : entry.listOptions.entrySet()) {
                    if (this.listOptions.containsKey(entry3.getKey())) continue;
                    this.listOptions.put(entry3.getKey(), (List)entry3.getValue());
                }
            }
            if (entry.multiOptions != null) {
                if (this.multiOptions == null) {
                    this.multiOptions = new HashMap<String, List<String>>(2 * MULTI_KEYS.size());
                }
                for (Map.Entry<String, Object> entry4 : entry.multiOptions.entrySet()) {
                    List<String> values = this.multiOptions.get(entry4.getKey());
                    if (values == null) {
                        values = new ArrayList<String>((Collection)entry4.getValue());
                        this.multiOptions.put(entry4.getKey(), values);
                        continue;
                    }
                    values.addAll((Collection)entry4.getValue());
                }
            }
        }

        private List<String> substitute(List<String> values, String allowed, Replacer r) {
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (String value : values) {
                result.add(r.substitute(value, allowed));
            }
            return result;
        }

        private List<String> replaceTilde(List<String> values, File home) {
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (String value : values) {
                result.add(OpenSshConfig.toFile(value, home).getPath());
            }
            return result;
        }

        protected void substitute(String originalHostName, File home) {
            String value;
            List<String> values;
            Replacer r = new Replacer(originalHostName, home);
            if (this.multiOptions != null) {
                values = this.multiOptions.get("IDENTITYFILE");
                if (values != null) {
                    values = this.substitute(values, "dhlru", r);
                    values = this.replaceTilde(values, home);
                    this.multiOptions.put("IDENTITYFILE", values);
                }
                if ((values = this.multiOptions.get("CERTIFICATEFILE")) != null) {
                    values = this.substitute(values, "dhlru", r);
                    values = this.replaceTilde(values, home);
                    this.multiOptions.put("CERTIFICATEFILE", values);
                }
            }
            if (this.listOptions != null) {
                values = this.listOptions.get("GLOBALKNOWNHOSTSFILE");
                if (values != null) {
                    values = this.replaceTilde(values, home);
                    this.listOptions.put("GLOBALKNOWNHOSTSFILE", values);
                }
                if ((values = this.listOptions.get("USERKNOWNHOSTSFILE")) != null) {
                    values = this.replaceTilde(values, home);
                    this.listOptions.put("USERKNOWNHOSTSFILE", values);
                }
            }
            if (this.options != null && (value = this.options.get("IDENTITYAGENT")) != null) {
                value = r.substitute(value, "dhlru");
                value = OpenSshConfig.toFile(value, home).getPath();
                this.options.put("IDENTITYAGENT", value);
            }
        }

        public String toString() {
            return "HostEntry [options=" + this.options + ", multiOptions=" + this.multiOptions + ", listOptions=" + this.listOptions + "]";
        }

        static {
            KEY_MAP.put("kex", "KexAlgorithms");
            KEY_MAP.put("server_host_key", "HostKeyAlgorithms");
            KEY_MAP.put("cipher.c2s", "Ciphers");
            KEY_MAP.put("cipher.s2c", "Ciphers");
            KEY_MAP.put("mac.c2s", "Macs");
            KEY_MAP.put("mac.s2c", "Macs");
            KEY_MAP.put("compression.s2c", "Compression");
            KEY_MAP.put("compression.c2s", "Compression");
            KEY_MAP.put("compression_level", "CompressionLevel");
            KEY_MAP.put("MaxAuthTries", "NumberOfPasswordPrompts");
            MULTI_KEYS = new HashSet<String>();
            MULTI_KEYS.add("CERTIFICATEFILE");
            MULTI_KEYS.add("IDENTITYFILE");
            MULTI_KEYS.add("LOCALFORWARD");
            MULTI_KEYS.add("REMOTEFORWARD");
            MULTI_KEYS.add("SENDENV");
            LIST_KEYS = new HashSet<String>();
            LIST_KEYS.add("CANONICALDOMAINS");
            LIST_KEYS.add("GLOBALKNOWNHOSTSFILE");
            LIST_KEYS.add("SENDENV");
            LIST_KEYS.add("USERKNOWNHOSTSFILE");
        }

        private class Replacer {
            private final Map<Character, String> replacements = new HashMap<Character, String>();

            public Replacer(String originalHostName, File home) {
                this.replacements.put(Character.valueOf('%'), "%");
                this.replacements.put(Character.valueOf('d'), home.getPath());
                String host = HostEntry.this.getValue("HOSTNAME");
                this.replacements.put(Character.valueOf('h'), originalHostName);
                if (host != null && host.indexOf(37) >= 0) {
                    host = this.substitute(host, "h");
                    HostEntry.this.options.put("HOSTNAME", host);
                }
                if (host != null) {
                    this.replacements.put(Character.valueOf('h'), host);
                }
                String localhost = SystemReader.getInstance().getHostname();
                this.replacements.put(Character.valueOf('l'), localhost);
                int period = localhost.indexOf(46);
                if (period > 0) {
                    localhost = localhost.substring(0, period);
                }
                this.replacements.put(Character.valueOf('L'), localhost);
                this.replacements.put(Character.valueOf('n'), originalHostName);
                this.replacements.put(Character.valueOf('p'), HostEntry.this.getValue("PORT"));
                this.replacements.put(Character.valueOf('r'), HostEntry.this.getValue("USER"));
                this.replacements.put(Character.valueOf('u'), OpenSshConfig.userName());
                this.replacements.put(Character.valueOf('C'), this.substitute("%l%h%p%r", "hlpr"));
            }

            public String substitute(String input, String allowed) {
                if (input == null || input.length() <= 1 || input.indexOf(37) < 0) {
                    return input;
                }
                StringBuilder builder = new StringBuilder();
                int start = 0;
                int length = input.length();
                while (start < length) {
                    int percent = input.indexOf(37, start);
                    if (percent < 0 || percent + 1 >= length) {
                        builder.append(input.substring(start));
                        break;
                    }
                    String replacement = null;
                    char ch = input.charAt(percent + 1);
                    if (ch == '%' || allowed.indexOf(ch) >= 0) {
                        replacement = this.replacements.get(Character.valueOf(ch));
                    }
                    if (replacement == null) {
                        builder.append(input.substring(start, percent + 2));
                    } else {
                        builder.append(input.substring(start, percent)).append(replacement);
                    }
                    start = percent + 2;
                }
                return builder.toString();
            }
        }
    }

    private static class JschBugFixingConfig
    implements ConfigRepository.Config {
        private final ConfigRepository.Config real;

        public JschBugFixingConfig(ConfigRepository.Config delegate) {
            this.real = delegate;
        }

        @Override
        public String getHostname() {
            return this.real.getHostname();
        }

        @Override
        public String getUser() {
            return this.real.getUser();
        }

        @Override
        public int getPort() {
            return this.real.getPort();
        }

        @Override
        public String getValue(String key2) {
            String k;
            String result = this.real.getValue(key2);
            if (result != null && ("SERVERALIVEINTERVAL".equals(k = key2.toUpperCase(Locale.ROOT)) || "CONNECTTIMEOUT".equals(k))) {
                try {
                    int timeout = Integer.parseInt(result);
                    result = Long.toString(TimeUnit.SECONDS.toMillis(timeout));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public String[] getValues(String key2) {
            return this.real.getValues(key2);
        }
    }

    private static class State {
        Map<String, HostEntry> entries = new LinkedHashMap<String, HostEntry>();
        Map<String, Host> hosts = new HashMap<String, Host>();

        private State() {
        }

        public String toString() {
            return "State [entries=" + this.entries + ", hosts=" + this.hosts + "]";
        }
    }
}

