/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.util.CollectionFactory;

public class WeakCache<K>
implements Serializable {
    private static final long serialVersionUID = 40000L;
    private transient Map<K, WeakReference<K>> prefixCache = CollectionFactory.createSyncWeakMap();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.prefixCache = CollectionFactory.createSyncWeakMap();
    }

    @Nonnull
    public K cache(@Nonnull K s) {
        Object toReturn;
        WeakReference<K> w = this.prefixCache.get(s);
        if (w != null && (toReturn = w.get()) != null) {
            return (K)toReturn;
        }
        this.prefixCache.put(s, new WeakReference<K>(s));
        return s;
    }

    public boolean contains(K k) {
        Object toReturn;
        WeakReference<K> w = this.prefixCache.get(k);
        return w != null && (toReturn = w.get()) != null;
    }

    public void clear() {
        this.prefixCache.clear();
    }
}

