# -*- coding: utf-8 -*-
info = {
    "name": "fa",
    "date_order": "YMD",
    "january": [
        "ژانویه",
        "ژانویهٔ",
        "جنوری"
    ],
    "february": [
        "فوریه",
        "فوریهٔ",
        "فبروری"
    ],
    "march": [
        "مارس",
        "مارچ"
    ],
    "april": [
        "آوریل",
        "اپریل"
    ],
    "may": [
        "مه",
        "مهٔ",
        "می"
    ],
    "june": [
        "ژوئن",
        "جون"
    ],
    "july": [
        "ژوئیه",
        "ژوئیهٔ",
        "جولای"
    ],
    "august": [
        "اوت",
        "آگست"
    ],
    "september": [
        "سپتامبر",
        "سپتمبر"
    ],
    "october": [
        "اکتبر",
        "اکتوبر"
    ],
    "november": [
        "نوامبر",
        "نومبر"
    ],
    "december": [
        "دسامبر",
        "دسمبر"
    ],
    "monday": [
        "دوشنبه"
    ],
    "tuesday": [
        "سه‌شنبه",
        "سهشنبه"
    ],
    "wednesday": [
        "چهارشنبه",
        "چهار شنبه"
    ],
    "thursday": [
        "پنجشنبه",
        "پنج شنبه"
    ],
    "friday": [
        "جمعه"
    ],
    "saturday": [
        "شنبه",
        "روز شنبه",
        "دو شنبه",
        "د"
    ],
    "sunday": [
        "یکشنبه"
    ],
    "am": [
        "قبل‌ازظهر",
        "قظ"
    ],
    "pm": [
        "بعدازظهر",
        "بظ"
    ],
    "year": [
        "سال"
    ],
    "month": [
        "ماه"
    ],
    "week": [
        "هفته"
    ],
    "day": [
        "روز"
    ],
    "hour": [
        "ساعت"
    ],
    "minute": [
        "دقیقه"
    ],
    "second": [
        "ثانیه",
        "دوم"
    ],
    "relative-type": {
        "1 year ago": [
            "سال گذشته"
        ],
        "0 year ago": [
            "امسال"
        ],
        "in 1 year": [
            "سال آینده"
        ],
        "1 month ago": [
            "ماه گذشته",
            "ماه پیش"
        ],
        "0 month ago": [
            "این ماه"
        ],
        "in 1 month": [
            "ماه آینده"
        ],
        "1 week ago": [
            "هفتهٔ گذشته"
        ],
        "0 week ago": [
            "این هفته"
        ],
        "in 1 week": [
            "هفتهٔ آینده"
        ],
        "1 day ago": [
            "دیروز"
        ],
        "0 day ago": [
            "امروز"
        ],
        "in 1 day": [
            "فردا"
        ],
        "0 hour ago": [
            "همین ساعت"
        ],
        "0 minute ago": [
            "همین دقیقه"
        ],
        "0 second ago": [
            "اکنون"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) سال بعد"
        ],
        "\\1 year ago": [
            "(\\d+) سال پیش"
        ],
        "in \\1 month": [
            "(\\d+) ماه بعد"
        ],
        "\\1 month ago": [
            "(\\d+) ماه پیش"
        ],
        "in \\1 week": [
            "(\\d+) هفته بعد"
        ],
        "\\1 week ago": [
            "(\\d+) هفته پیش"
        ],
        "in \\1 day": [
            "(\\d+) روز بعد"
        ],
        "\\1 day ago": [
            "(\\d+) روز پیش"
        ],
        "in \\1 hour": [
            "(\\d+) ساعت بعد"
        ],
        "\\1 hour ago": [
            "(\\d+) ساعت پیش"
        ],
        "in \\1 minute": [
            "(\\d+) دقیقه بعد"
        ],
        "\\1 minute ago": [
            "(\\d+) دقیقه پیش"
        ],
        "in \\1 second": [
            "(\\d+) ثانیه بعد"
        ],
        "\\1 second ago": [
            "(\\d+) ثانیه پیش"
        ]
    },
    "locale_specific": {
        "fa-AF": {
            "name": "fa-AF",
            "january": [
                "جنوری",
                "جنو"
            ],
            "february": [
                "فبروری"
            ],
            "march": [
                "مارچ"
            ],
            "april": [
                "اپریل"
            ],
            "may": [
                "می"
            ],
            "june": [
                "جون"
            ],
            "july": [
                "جول",
                "جولای"
            ],
            "august": [
                "اگست"
            ],
            "september": [
                "سپتمبر"
            ],
            "october": [
                "اکتوبر"
            ],
            "november": [
                "نومبر"
            ],
            "december": [
                "دسمبر",
                "دسم"
            ]
        }
    },
    "sentence_splitter_group": 6,
    "ago": [
        "پیش"
    ],
    "in": [
        "در"
    ],
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
