/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.PBKDF2Core;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.spec.PBE2ParameterSpec;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBES2Core
extends CipherSpi {
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 4096;
    private final CipherCore cipher;
    private final int keyLength;
    private final int blkSize;
    private final PBKDF2Core kdf;
    private final String pbeAlgo;
    private final String cipherAlgo;
    private int iCount = 4096;
    private byte[] salt = null;
    private IvParameterSpec ivSpec = null;

    PBES2Core(String kdfAlgo, String cipherAlgo, int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipherAlgo = cipherAlgo;
        this.keyLength = keySize * 8;
        this.pbeAlgo = "PBEWith" + kdfAlgo + "And" + cipherAlgo + "_" + this.keyLength;
        if (cipherAlgo.equals("AES")) {
            this.blkSize = 16;
            this.cipher = new CipherCore(new AESCrypt(), this.blkSize);
            switch (kdfAlgo) {
                case "HmacSHA1": {
                    this.kdf = new PBKDF2Core.HmacSHA1();
                    break;
                }
                case "HmacSHA224": {
                    this.kdf = new PBKDF2Core.HmacSHA224();
                    break;
                }
                case "HmacSHA256": {
                    this.kdf = new PBKDF2Core.HmacSHA256();
                    break;
                }
                case "HmacSHA384": {
                    this.kdf = new PBKDF2Core.HmacSHA384();
                    break;
                }
                case "HmacSHA512": {
                    this.kdf = new PBKDF2Core.HmacSHA512();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("No Cipher implementation for " + kdfAlgo);
                }
            }
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.pbeAlgo);
        }
        this.cipher.setMode("CBC");
        this.cipher.setPadding("PKCS5Padding");
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + paddingScheme);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blkSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipher.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            SunJCE.RANDOM.nextBytes(this.salt);
            this.iCount = 4096;
        }
        if (this.ivSpec == null) {
            byte[] ivBytes = new byte[this.blkSize];
            SunJCE.RANDOM.nextBytes(ivBytes);
            this.ivSpec = new IvParameterSpec(ivBytes);
        }
        PBE2ParameterSpec pbeSpec = new PBE2ParameterSpec(this.salt, this.iCount, this.ivSpec);
        try {
            params = AlgorithmParameters.getInstance(this.pbeAlgo, "SunJCE");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        catch (NoSuchProviderException nspe) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        try {
            params.init(pbeSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException ie) {
            InvalidKeyException ike = new InvalidKeyException("requires PBE parameters");
            ike.initCause(ie);
            throw ike;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEKeySpec pbeSpec;
        byte[] passwdBytes;
        block25: {
            if (key == null) {
                throw new InvalidKeyException("Null key");
            }
            passwdBytes = key.getEncoded();
            char[] passwdChars = null;
            try {
                if (passwdBytes == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                    throw new InvalidKeyException("Missing password");
                }
                if (key instanceof PBEKey) {
                    this.salt = ((PBEKey)key).getSalt();
                    if (this.salt != null && this.salt.length < 8) {
                        throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
                    }
                    this.iCount = ((PBEKey)key).getIterationCount();
                    if (this.iCount == 0) {
                        this.iCount = 4096;
                    } else if (this.iCount < 0) {
                        throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
                    }
                }
                if (params == null) {
                    if (this.salt == null) {
                        this.salt = new byte[20];
                        random.nextBytes(this.salt);
                        this.iCount = 4096;
                    }
                    if (opmode == 1 || opmode == 3) {
                        byte[] ivBytes = new byte[this.blkSize];
                        random.nextBytes(ivBytes);
                        this.ivSpec = new IvParameterSpec(ivBytes);
                    }
                } else {
                    AlgorithmParameterSpec specParams;
                    if (!(params instanceof PBEParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
                    }
                    byte[] specSalt = ((PBEParameterSpec)params).getSalt();
                    if (specSalt != null && specSalt.length < 8) {
                        throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
                    }
                    this.salt = specSalt;
                    int specICount = ((PBEParameterSpec)params).getIterationCount();
                    if (specICount == 0) {
                        specICount = 4096;
                    } else if (specICount < 0) {
                        throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
                    }
                    this.iCount = specICount;
                    if (params instanceof PBE2ParameterSpec && (specParams = ((PBE2ParameterSpec)params).getParameterSpec()) != null) {
                        if (!(specParams instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                        this.ivSpec = (IvParameterSpec)specParams;
                    } else {
                        if (opmode != 1 && opmode != 3) throw new InvalidAlgorithmParameterException("Missing parameter type: IV expected");
                        byte[] ivBytes = new byte[this.blkSize];
                        random.nextBytes(ivBytes);
                        this.ivSpec = new IvParameterSpec(ivBytes);
                    }
                }
                passwdChars = new char[passwdBytes.length];
                for (int i = 0; i < passwdChars.length; ++i) {
                    passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                }
                pbeSpec = new PBEKeySpec(passwdChars, this.salt, this.iCount, this.keyLength);
                if (passwdChars == null) break block25;
            }
            catch (Throwable throwable) {
                if (passwdChars != null) {
                    Arrays.fill(passwdChars, '\u0000');
                }
                if (passwdBytes == null) throw throwable;
                Arrays.fill(passwdBytes, (byte)0);
                throw throwable;
            }
            Arrays.fill(passwdChars, '\u0000');
        }
        if (passwdBytes != null) {
            Arrays.fill(passwdBytes, (byte)0);
        }
        SecretKey s = null;
        try {
            s = this.kdf.engineGenerateSecret(pbeSpec);
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct PBE key");
            ike.initCause(ikse);
            throw ike;
        }
        byte[] derivedKey = s.getEncoded();
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, this.cipherAlgo);
        this.cipher.init(opmode, (Key)cipherKey, this.ivSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pbeSpec = null;
        if (params != null) {
            try {
                pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.engineInit(opmode, key, pbeSpec, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.keyLength;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final class HmacSHA512AndAES_256
    extends PBES2Core {
        public HmacSHA512AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA512", "AES", 32);
        }
    }

    public static final class HmacSHA384AndAES_256
    extends PBES2Core {
        public HmacSHA384AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA384", "AES", 32);
        }
    }

    public static final class HmacSHA256AndAES_256
    extends PBES2Core {
        public HmacSHA256AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA256", "AES", 32);
        }
    }

    public static final class HmacSHA224AndAES_256
    extends PBES2Core {
        public HmacSHA224AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA224", "AES", 32);
        }
    }

    public static final class HmacSHA1AndAES_256
    extends PBES2Core {
        public HmacSHA1AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA1", "AES", 32);
        }
    }

    public static final class HmacSHA512AndAES_128
    extends PBES2Core {
        public HmacSHA512AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA512", "AES", 16);
        }
    }

    public static final class HmacSHA384AndAES_128
    extends PBES2Core {
        public HmacSHA384AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA384", "AES", 16);
        }
    }

    public static final class HmacSHA256AndAES_128
    extends PBES2Core {
        public HmacSHA256AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA256", "AES", 16);
        }
    }

    public static final class HmacSHA224AndAES_128
    extends PBES2Core {
        public HmacSHA224AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA224", "AES", 16);
        }
    }

    public static final class HmacSHA1AndAES_128
    extends PBES2Core {
        public HmacSHA1AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA1", "AES", 16);
        }
    }
}

