/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;

public class AbstractCharsetProvider
extends CharsetProvider {
    private Map<String, String> classMap = new TreeMap<String, String>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map<String, String> aliasMap = new TreeMap<String, String>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map<String, String[]> aliasNameMap = new TreeMap<String, String[]>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map<String, SoftReference<Charset>> cache = new TreeMap<String, SoftReference<Charset>>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private String packagePrefix;

    protected AbstractCharsetProvider() {
        this.packagePrefix = "sun.nio.cs";
    }

    protected AbstractCharsetProvider(String pkgPrefixName) {
        this.packagePrefix = pkgPrefixName;
    }

    private static <K, V> void put(Map<K, V> m, K name, V value) {
        if (!m.containsKey(name)) {
            m.put(name, value);
        }
    }

    private static <K, V> void remove(Map<K, V> m, K name) {
        V x = m.remove(name);
        assert (x != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void charset(String name, String className, String[] aliases) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            AbstractCharsetProvider.put(this.classMap, name, className);
            for (int i = 0; i < aliases.length; ++i) {
                AbstractCharsetProvider.put(this.aliasMap, aliases[i], name);
            }
            AbstractCharsetProvider.put(this.aliasNameMap, name, aliases);
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCharset(String name, String[] aliases) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            AbstractCharsetProvider.remove(this.classMap, name);
            for (int i = 0; i < aliases.length; ++i) {
                AbstractCharsetProvider.remove(this.aliasMap, aliases[i]);
            }
            AbstractCharsetProvider.remove(this.aliasNameMap, name);
            this.cache.clear();
        }
    }

    protected void init() {
    }

    private String canonicalize(String charsetName) {
        String acn = this.aliasMap.get(charsetName);
        return acn != null ? acn : charsetName;
    }

    private Charset lookup(String csn) {
        Charset cs;
        SoftReference<Charset> sr = this.cache.get(csn);
        if (sr != null && (cs = sr.get()) != null) {
            return cs;
        }
        String cln = this.classMap.get(csn);
        if (cln == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(this.packagePrefix + "." + cln, true, this.getClass().getClassLoader());
            Charset cs2 = (Charset)c.newInstance();
            this.cache.put(csn, new SoftReference<Charset>(cs2));
            return cs2;
        }
        catch (ClassNotFoundException x) {
            return null;
        }
        catch (IllegalAccessException x) {
            return null;
        }
        catch (InstantiationException x) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Charset charsetForName(String charsetName) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            this.init();
            return this.lookup(this.canonicalize(charsetName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<Charset> charsets() {
        ArrayList<String> ks;
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            this.init();
            ks = new ArrayList<String>(this.classMap.keySet());
        }
        return new Iterator<Charset>(){
            Iterator<String> i;
            {
                this.i = ks.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Charset next() {
                String csn = this.i.next();
                AbstractCharsetProvider abstractCharsetProvider = AbstractCharsetProvider.this;
                synchronized (abstractCharsetProvider) {
                    return AbstractCharsetProvider.this.lookup(csn);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] aliases(String charsetName) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            this.init();
            return this.aliasNameMap.get(charsetName);
        }
    }
}

