/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

public final class CookieSupport {
    public static final boolean STRICT_SERVLET_COMPLIANCE;
    public static final boolean ALLOW_EQUALS_IN_VALUE;
    public static final boolean ALLOW_HTTP_SEPARATORS_IN_V0;
    public static final boolean ALWAYS_ADD_EXPIRES;
    public static final boolean FWD_SLASH_IS_SEPARATOR;
    public static final boolean ALLOW_NAME_ONLY;
    public static final boolean PRESERVE_COOKIE_HEADER;
    private static final char[] V0_SEPARATORS;
    private static final boolean[] V0_SEPARATOR_FLAGS;
    private static final char[] HTTP_SEPARATORS;
    private static final boolean[] HTTP_SEPARATOR_FLAGS;

    public static final boolean isV0Separator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw new IllegalArgumentException("Control character in cookie value or attribute.");
        }
        return V0_SEPARATOR_FLAGS[c];
    }

    public static boolean isV0Token(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        if (CookieSupport.alreadyQuoted(string)) {
            ++n;
            --n2;
        }
        while (n < n2) {
            char c = string.charAt(n);
            if (CookieSupport.isV0Separator(c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isHttpSeparator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw new IllegalArgumentException("Control character in cookie value or attribute.");
        }
        return HTTP_SEPARATOR_FLAGS[c];
    }

    public static boolean isHttpToken(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        if (CookieSupport.alreadyQuoted(string)) {
            ++n;
            --n2;
        }
        while (n < n2) {
            char c = string.charAt(n);
            if (CookieSupport.isHttpSeparator(c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean alreadyQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    private CookieSupport() {
    }

    static {
        int n;
        V0_SEPARATORS = new char[]{',', ';', ' ', '\t'};
        V0_SEPARATOR_FLAGS = new boolean[128];
        HTTP_SEPARATOR_FLAGS = new boolean[128];
        STRICT_SERVLET_COMPLIANCE = Boolean.parseBoolean(System.getProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE", "false"));
        ALLOW_EQUALS_IN_VALUE = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_EQUALS_IN_VALUE", "false"));
        ALLOW_HTTP_SEPARATORS_IN_V0 = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0", "false"));
        String string = System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALWAYS_ADD_EXPIRES");
        ALWAYS_ADD_EXPIRES = string == null ? !STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string);
        String string2 = System.getProperty("org.apache.tomcat.util.http.ServerCookie.PRESERVE_COOKIE_HEADER");
        PRESERVE_COOKIE_HEADER = string2 == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string2);
        String string3 = System.getProperty("org.apache.tomcat.util.http.ServerCookie.FWD_SLASH_IS_SEPARATOR");
        FWD_SLASH_IS_SEPARATOR = string3 == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string3);
        ALLOW_NAME_ONLY = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_NAME_ONLY", "false"));
        HTTP_SEPARATORS = FWD_SLASH_IS_SEPARATOR ? new char[]{'\t', ' ', '\"', '(', ')', ',', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'} : new char[]{'\t', ' ', '\"', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        for (n = 0; n < 128; ++n) {
            CookieSupport.V0_SEPARATOR_FLAGS[n] = false;
            CookieSupport.HTTP_SEPARATOR_FLAGS[n] = false;
        }
        for (n = 0; n < V0_SEPARATORS.length; ++n) {
            CookieSupport.V0_SEPARATOR_FLAGS[CookieSupport.V0_SEPARATORS[n]] = true;
        }
        for (n = 0; n < HTTP_SEPARATORS.length; ++n) {
            CookieSupport.HTTP_SEPARATOR_FLAGS[CookieSupport.HTTP_SEPARATORS[n]] = true;
        }
    }
}

