/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Arrays;
import org.apache.catalina.AccessLog;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class AccessLogAdapter
implements AccessLog {
    private AccessLog[] logs;

    public AccessLogAdapter(AccessLog accessLog) {
        if (accessLog == null) {
            throw new NullPointerException();
        }
        this.logs = new AccessLog[]{accessLog};
    }

    public void add(AccessLog accessLog) {
        if (accessLog == null) {
            throw new NullPointerException();
        }
        AccessLog[] accessLogArray = Arrays.copyOf(this.logs, this.logs.length + 1);
        accessLogArray[accessLogArray.length - 1] = accessLog;
        this.logs = accessLogArray;
    }

    @Override
    public void log(Request request, Response response, long l) {
        for (AccessLog accessLog : this.logs) {
            accessLog.log(request, response, l);
        }
    }

    @Override
    public void setRequestAttributesEnabled(boolean bl) {
    }

    @Override
    public boolean getRequestAttributesEnabled() {
        return false;
    }
}

