/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;

public final class InstanceSupport {
    private InstanceListener[] listeners = new InstanceListener[0];
    private final Object listenersLock = new Object();
    private Wrapper wrapper = null;

    public InstanceSupport(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener instanceListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            InstanceListener[] instanceListenerArray = new InstanceListener[this.listeners.length + 1];
            for (int i = 0; i < this.listeners.length; ++i) {
                instanceListenerArray[i] = this.listeners[i];
            }
            instanceListenerArray[this.listeners.length] = instanceListener;
            this.listeners = instanceListenerArray;
        }
    }

    public void fireInstanceEvent(String string, Filter filter) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, filter, string);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    public void fireInstanceEvent(String string, Filter filter, Throwable throwable) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, filter, string, throwable);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    public void fireInstanceEvent(String string, Filter filter, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, filter, string, servletRequest, servletResponse);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    public void fireInstanceEvent(String string, Filter filter, ServletRequest servletRequest, ServletResponse servletResponse, Throwable throwable) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, filter, string, servletRequest, servletResponse, throwable);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    public void fireInstanceEvent(String string, Servlet servlet) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, servlet, string);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    public void fireInstanceEvent(String string, Servlet servlet, Throwable throwable) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, servlet, string, throwable);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    public void fireInstanceEvent(String string, Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, servlet, string, servletRequest, servletResponse);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    public void fireInstanceEvent(String string, Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, Throwable throwable) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent instanceEvent = new InstanceEvent(this.wrapper, servlet, string, servletRequest, servletResponse, throwable);
        InstanceListener[] instanceListenerArray = this.listeners;
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            instanceListenerArray[i].instanceEvent(instanceEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener instanceListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != instanceListener) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            InstanceListener[] instanceListenerArray = new InstanceListener[this.listeners.length - 1];
            int n2 = 0;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (i == n) continue;
                instanceListenerArray[n2++] = this.listeners[i];
            }
            this.listeners = instanceListenerArray;
        }
    }
}

