/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExportDataDumper {
    public static final int BUFFER_SIZE = 32000;
    OutputStreamWriter osw;
    BufferedOutputStream bos;
    IOException caughtEx;
    int numExceptions = 0;

    public ExportDataDumper(FileOutputStream fileOutputStream) {
        this.bos = new BufferedOutputStream(fileOutputStream, 32000);
        try {
            this.osw = new OutputStreamWriter((OutputStream)this.bos, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ++this.numExceptions;
            Logger.getLogger(ExportDataDumper.class.getName()).log(Level.SEVERE, null, unsupportedEncodingException);
        }
    }

    public IOException getCaughtException() {
        return this.caughtEx;
    }

    public int getNumExceptions() {
        return this.numExceptions;
    }

    public void dumpByte(byte by) {
        if (this.caughtEx != null) {
            return;
        }
        try {
            this.bos.write(by);
        }
        catch (IOException iOException) {
            this.caughtEx = iOException;
            System.out.println(by);
            ++this.numExceptions;
            System.err.println(iOException.getMessage());
        }
    }

    public void dumpData(CharSequence charSequence) {
        if (this.caughtEx != null) {
            return;
        }
        try {
            if (charSequence != null) {
                this.osw.append(charSequence);
            }
        }
        catch (IOException iOException) {
            this.caughtEx = iOException;
            System.out.println(charSequence);
            ++this.numExceptions;
            System.err.println(iOException.getMessage());
        }
    }

    public void close() {
        try {
            this.osw.close();
            this.bos.close();
        }
        catch (IOException iOException) {
            this.caughtEx = iOException;
            System.err.println(iOException.getMessage());
        }
    }

    public void dumpDataAndClose(StringBuffer stringBuffer) {
        this.dumpData(stringBuffer);
        this.close();
    }

    public BufferedOutputStream getOutputStream() {
        return this.bos;
    }
}

