/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.results.cpu.cct.CCTFlattener;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;

public class FlatProfileBuilder
implements FlatProfileProvider,
CPUCCTProvider.Listener {
    private static final Logger LOGGER = Logger.getLogger(FlatProfileBuilder.class.getName());
    private CCTFlattener flattener;
    private FlatProfileContainer lastFlatProfile = null;
    private ProfilerClient client;
    private SimpleCPUCCTNode appNode;
    private TimeCollector collector = null;
    private CCTResultsFilter filter = null;

    public void setContext(ProfilerClient profilerClient, TimeCollector timeCollector, CCTResultsFilter cCTResultsFilter) {
        if (this.client != null) {
            this.collector = null;
            this.filter = null;
            this.client.registerFlatProfileProvider(null);
        }
        if (profilerClient != null) {
            this.collector = timeCollector;
            this.filter = cCTResultsFilter;
            this.flattener = new CCTFlattener(profilerClient, cCTResultsFilter);
            profilerClient.registerFlatProfileProvider(this);
        } else {
            this.flattener = null;
        }
        this.client = profilerClient;
        this.appNode = null;
    }

    @Override
    public synchronized void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean bl) {
        if (bl) {
            return;
        }
        this.appNode = runtimeCCTNode instanceof SimpleCPUCCTNode ? (SimpleCPUCCTNode)runtimeCCTNode : null;
    }

    @Override
    public synchronized void cctReset() {
        this.appNode = null;
    }

    @Override
    public synchronized FlatProfileContainer createFlatProfile() {
        if (this.appNode == null) {
            return null;
        }
        this.client.getStatus().beginTrans(false);
        try {
            RuntimeCCTNodeProcessor.process(this.appNode, this.filter, this.flattener, this.collector);
            this.lastFlatProfile = this.flattener.getFlatProfile();
        }
        finally {
            this.client.getStatus().endTrans();
        }
        return this.lastFlatProfile;
    }
}

