/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public abstract class MemoryResultsSnapshot
extends ResultsSnapshot {
    private JMethodIdTable table;
    String[] classNames;
    long[] objectsSizePerClass;
    private RuntimeMemoryCCTNode[] stacksForClasses;
    int nProfiledClasses;

    public MemoryResultsSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryResultsSnapshot(long l, long l2, MemoryCCTProvider memoryCCTProvider, ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        super(l, l2);
        ProfilingSessionStatus profilingSessionStatus = profilerClient.getStatus();
        profilingSessionStatus.beginTrans(false);
        try {
            this.performInit(profilerClient, memoryCCTProvider);
        }
        finally {
            profilingSessionStatus.endTrans();
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.debugValues();
            }
        }
    }

    public String getClassName(int n) {
        return this.classNames[n];
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public JMethodIdTable getJMethodIdTable() {
        return this.table;
    }

    public int getNProfiledClasses() {
        return this.nProfiledClasses;
    }

    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    public boolean containsStacks() {
        return this.stacksForClasses != null;
    }

    public abstract MemoryResultsSnapshot createDiff(MemoryResultsSnapshot var1);

    public void filterReverse(String string, int n, int n2, boolean bl, PresoObjAllocCCTNode presoObjAllocCCTNode, int n3, boolean bl2) {
        PresoObjAllocCCTNode presoObjAllocCCTNode2 = this.createPresentationCCT(n3, bl2);
        this.filter(string, n, presoObjAllocCCTNode2);
        presoObjAllocCCTNode.children = presoObjAllocCCTNode2.children;
        if (presoObjAllocCCTNode.children != null) {
            for (PresoObjAllocCCTNode presoObjAllocCCTNode3 : presoObjAllocCCTNode.children) {
                presoObjAllocCCTNode3.parent = presoObjAllocCCTNode;
            }
            presoObjAllocCCTNode.sortChildren(n2, bl);
        }
        if (!FilterSortSupport.passesFilter(string, n, presoObjAllocCCTNode.getNodeName())) {
            // empty if block
        }
    }

    private void filter(String string, int n, PresoObjAllocCCTNode presoObjAllocCCTNode) {
        if (presoObjAllocCCTNode.children != null) {
            PresoObjAllocCCTNode presoObjAllocCCTNode2 = null;
            ArrayList<PresoObjAllocCCTNode> arrayList = new ArrayList<PresoObjAllocCCTNode>();
            for (PresoObjAllocCCTNode presoObjAllocCCTNode3 : presoObjAllocCCTNode.children) {
                PresoObjAllocCCTNode presoObjAllocCCTNode4 = presoObjAllocCCTNode3;
                if (FilterSortSupport.passesFilter(string, n, presoObjAllocCCTNode4.getNodeName())) {
                    int n2 = arrayList.indexOf(presoObjAllocCCTNode4);
                    if (n2 == -1) {
                        arrayList.add(presoObjAllocCCTNode4);
                        continue;
                    }
                    ((PresoObjAllocCCTNode)arrayList.get(n2)).merge(presoObjAllocCCTNode4);
                    continue;
                }
                if (presoObjAllocCCTNode2 == null) {
                    presoObjAllocCCTNode2 = presoObjAllocCCTNode4;
                    arrayList.add(presoObjAllocCCTNode4);
                    continue;
                }
                presoObjAllocCCTNode2.merge(presoObjAllocCCTNode4);
            }
            if (arrayList.isEmpty()) {
                presoObjAllocCCTNode.children = null;
            } else if (presoObjAllocCCTNode.isFiltered() && presoObjAllocCCTNode2 != null && arrayList.size() == 1) {
                PresoObjAllocCCTNode presoObjAllocCCTNode5 = (PresoObjAllocCCTNode)arrayList.get(0);
                this.filter(string, n, presoObjAllocCCTNode5);
                presoObjAllocCCTNode.children = presoObjAllocCCTNode5.children;
            } else {
                presoObjAllocCCTNode.children = arrayList.toArray(new PresoObjAllocCCTNode[0]);
            }
            if (presoObjAllocCCTNode.children != null) {
                for (PresoObjAllocCCTNode presoObjAllocCCTNode3 : presoObjAllocCCTNode.children) {
                    this.filter(string, n, presoObjAllocCCTNode3);
                }
            }
        }
    }

    public PresoObjAllocCCTNode createPresentationCCT(int n, boolean bl) {
        if (this.stacksForClasses == null) {
            return null;
        }
        RuntimeMemoryCCTNode runtimeMemoryCCTNode = this.stacksForClasses[n];
        if (runtimeMemoryCCTNode == null) {
            return null;
        }
        return this.createPresentationCCT(runtimeMemoryCCTNode, n, bl);
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        super.readFromStream(dataInputStream);
        this.nProfiledClasses = dataInputStream.readInt();
        this.classNames = new String[this.nProfiledClasses];
        this.objectsSizePerClass = new long[this.nProfiledClasses];
        for (n = 0; n < this.nProfiledClasses; ++n) {
            this.classNames[n] = dataInputStream.readUTF();
            this.objectsSizePerClass[n] = dataInputStream.readLong();
        }
        if (dataInputStream.readBoolean()) {
            n = dataInputStream.readInt();
            this.stacksForClasses = new RuntimeMemoryCCTNode[n];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readInt();
                if (n2 == 0) continue;
                this.stacksForClasses[i] = RuntimeMemoryCCTNode.create(n2);
                this.stacksForClasses[i].readFromStream(dataInputStream);
            }
            if (dataInputStream.readBoolean()) {
                this.table = new JMethodIdTable();
                this.table.readFromStream(dataInputStream);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        int n;
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.nProfiledClasses);
        for (n = 0; n < this.nProfiledClasses; ++n) {
            dataOutputStream.writeUTF(this.classNames[n]);
            dataOutputStream.writeLong(this.objectsSizePerClass[n]);
        }
        dataOutputStream.writeBoolean(this.stacksForClasses != null);
        if (this.stacksForClasses != null) {
            dataOutputStream.writeInt(this.stacksForClasses.length);
            for (n = 0; n < this.stacksForClasses.length; ++n) {
                if (this.stacksForClasses[n] == null) {
                    dataOutputStream.writeInt(0);
                    continue;
                }
                dataOutputStream.writeInt(this.stacksForClasses[n].getType());
                this.stacksForClasses[n].writeToStream(dataOutputStream);
            }
            dataOutputStream.writeBoolean(this.table != null);
            if (this.table != null) {
                this.table.writeToStream(dataOutputStream);
            }
        }
    }

    protected abstract PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode var1, int var2, boolean var3);

    protected void performInit(ProfilerClient profilerClient, MemoryCCTProvider memoryCCTProvider) throws ClientUtils.TargetAppOrVMTerminated {
        this.nProfiledClasses = memoryCCTProvider.getNProfiledClasses();
        int n = 0;
        if (memoryCCTProvider.getObjectsSizePerClass() != null) {
            n = memoryCCTProvider.getObjectsSizePerClass().length;
            this.objectsSizePerClass = new long[n];
            System.arraycopy(memoryCCTProvider.getObjectsSizePerClass(), 0, this.objectsSizePerClass, 0, n);
        }
        String[] stringArray = profilerClient.getStatus().getClassNames();
        n = this.nProfiledClasses;
        this.classNames = new String[n];
        System.arraycopy(stringArray, 0, this.classNames, 0, n);
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = memoryCCTProvider.getStacksForClasses();
        if (runtimeMemoryCCTNodeArray != null && this.checkContainsStacks(runtimeMemoryCCTNodeArray)) {
            this.stacksForClasses = new RuntimeMemoryCCTNode[runtimeMemoryCCTNodeArray.length];
            for (int i = 0; i < this.stacksForClasses.length; ++i) {
                if (runtimeMemoryCCTNodeArray[i] == null) continue;
                this.stacksForClasses[i] = (RuntimeMemoryCCTNode)runtimeMemoryCCTNodeArray[i].clone();
            }
            this.table = new JMethodIdTable(JMethodIdTable.getDefault());
        }
    }

    private boolean checkContainsStacks(RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray) {
        for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
            RuntimeMemoryCCTNode runtimeMemoryCCTNode = runtimeMemoryCCTNodeArray[i];
            if (runtimeMemoryCCTNode == null || runtimeMemoryCCTNode instanceof RuntimeObjAllocTermCCTNode || runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) continue;
            return true;
        }
        return false;
    }

    void debugValues() {
        LOGGER.finest("nProfiledClasses: " + this.nProfiledClasses);
        LOGGER.finest("stacksForClasses.length: " + this.debugLength(this.stacksForClasses));
        LOGGER.finest("objectsSizePerClass.length: " + this.debugLength(this.objectsSizePerClass));
        LOGGER.finest("classNames.length: " + this.debugLength(this.classNames));
        LOGGER.finest("table: " + (this.table == null ? "null" : this.table.debug()));
    }
}

